/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzbaz;
import com.google.android.gms.internal.zzbba;
import com.google.android.gms.internal.zzbdq;
import com.google.android.gms.internal.zzbdr;
import com.google.android.gms.internal.zzbds;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzbat
extends zzbaz {
    private final SparseArray<zza> zzaBB = new SparseArray();

    public static zzbat zza(zzbdq zzbdq2) {
        zzbds zzbds2 = zzbat.zzb((zzbdq)zzbdq2);
        zzbat zzbat2 = (zzbat)zzbds2.zza("AutoManageHelper", zzbat.class);
        if (zzbat2 != null) {
            return zzbat2;
        }
        return new zzbat(zzbds2);
    }

    private zzbat(zzbds zzbds2) {
        super(zzbds2);
        this.zzaEG.zza("AutoManageHelper", (zzbdr)this);
    }

    public final void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzbo.zzb((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzbo.zza((this.zzaBB.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        zzbba zzbba2 = (zzbba)this.zzaBN.get();
        boolean bl = this.mStarted;
        String string2 = String.valueOf(zzbba2);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(string2).toString());
        zza zza2 = new zza(this, n, googleApiClient, onConnectionFailedListener);
        this.zzaBB.put(n, (Object)zza2);
        if (this.mStarted && zzbba2 == null) {
            string2 = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string2).length()).append("connecting ").append(string2).toString());
            googleApiClient.connect();
        }
    }

    public final void zzal(int n) {
        zza zza2 = (zza)this.zzaBB.get(n);
        this.zzaBB.remove(n);
        if (zza2 != null) {
            zza zza3 = zza2;
            zza3.zzaBD.unregisterConnectionFailedListener(zza3);
            zza3.zzaBD.disconnect();
        }
    }

    @Override
    public final void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.zzaBB);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (this.zzaBN.get() == null) {
            for (n = 0; n < this.zzaBB.size(); ++n) {
                object = this.zzam(n);
                if (object == null) continue;
                ((zza)object).zzaBD.connect();
            }
        }
    }

    @Override
    public final void onStop() {
        super.onStop();
        for (int i = 0; i < this.zzaBB.size(); ++i) {
            zza zza2 = this.zzam(i);
            if (zza2 == null) continue;
            zza2.zzaBD.disconnect();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.zzaBB.size(); ++i) {
            zza zza2 = this.zzam(i);
            if (zza2 == null) continue;
            String[] stringArray2 = stringArray;
            PrintWriter printWriter2 = printWriter;
            FileDescriptor fileDescriptor2 = fileDescriptor;
            String string3 = string2;
            zza zza3 = zza2;
            printWriter2.append(string3).append("GoogleApiClient #").print(zza3.zzaBC);
            printWriter2.println(":");
            zza3.zzaBD.dump(String.valueOf(string3).concat("  "), fileDescriptor2, printWriter2, stringArray2);
        }
    }

    @Override
    protected final void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.zzaBB.get(n);
        if (zza2 != null) {
            this.zzal(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzaBE;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected final void zzps() {
        for (int i = 0; i < this.zzaBB.size(); ++i) {
            zza zza2 = this.zzam(i);
            if (zza2 == null) continue;
            zza2.zzaBD.connect();
        }
    }

    @Nullable
    private final zza zzam(int n) {
        if (this.zzaBB.size() <= n) {
            return null;
        }
        return (zza)this.zzaBB.get(this.zzaBB.keyAt(n));
    }

    final class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzaBC;
        public final GoogleApiClient zzaBD;
        public final GoogleApiClient.OnConnectionFailedListener zzaBE;
        private /* synthetic */ zzbat zzaBF;

        public zza(zzbat zzbat2, int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzaBF = zzbat2;
            this.zzaBC = n;
            this.zzaBD = googleApiClient;
            this.zzaBE = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string2 = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("beginFailureResolution for ").append(string2).toString());
            this.zzaBF.zzb(connectionResult, this.zzaBC);
        }
    }
}

