/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.auth.api.signin.zzc;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzbp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zza
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope zzece = new Scope("profile");
    public static final Scope zzecf = new Scope("email");
    public static final Scope zzecg = new Scope("openid");
    private static Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(SCOPE_GAMES, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzd();
    private int versionCode;
    private final ArrayList<Scope> zzech;
    private Account zzdva;
    private boolean zzeaq;
    private final boolean zzeci;
    private final boolean zzecj;
    private String zzear;
    private String zzeck;
    private ArrayList<zzn> zzecl;
    private Map<Integer, zzn> zzecm;
    private static Comparator<Scope> zzecd = new zzc();

    @Nullable
    public static GoogleSignInOptions zzeo(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, zzn>());
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, ArrayList<zzn> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zzu(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map<Integer, zzn> map) {
        this.versionCode = n;
        this.zzech = arrayList;
        this.zzdva = account;
        this.zzeaq = bl;
        this.zzeci = bl2;
        this.zzecj = bl3;
        this.zzear = string2;
        this.zzeck = string3;
        this.zzecl = new ArrayList<zzn>(map.values());
        this.zzecm = map;
    }

    public final ArrayList<Scope> zzaae() {
        return new ArrayList<Scope>(this.zzech);
    }

    public Scope[] getScopeArray() {
        return this.zzech.toArray(new Scope[this.zzech.size()]);
    }

    public final Account getAccount() {
        return this.zzdva;
    }

    public final boolean isIdTokenRequested() {
        return this.zzeaq;
    }

    public final boolean zzaaf() {
        return this.zzeci;
    }

    public final String getServerClientId() {
        return this.zzear;
    }

    private static Map<Integer, zzn> zzu(@Nullable List<zzn> list) {
        HashMap<Integer, zzn> hashMap = new HashMap<Integer, zzn>();
        if (list == null) {
            return hashMap;
        }
        for (zzn zzn2 : list) {
            hashMap.put(zzn2.getType(), zzn2);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = com.google.android.gms.common.internal.safeparcel.zzd.zze((Parcel)parcel2);
        com.google.android.gms.common.internal.safeparcel.zzd.zzc((Parcel)parcel2, (int)1, (int)googleSignInOptions.versionCode);
        com.google.android.gms.common.internal.safeparcel.zzd.zzc((Parcel)parcel2, (int)2, googleSignInOptions.zzaae(), (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.zzdva, (int)n, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.zzeaq);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.zzeci);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.zzecj);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)7, (String)googleSignInOptions.zzear, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)8, (String)googleSignInOptions.zzeck, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zzc((Parcel)parcel2, (int)9, googleSignInOptions.zzecl, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzecl.size() > 0 || googleSignInOptions.zzecl.size() > 0) {
                return false;
            }
            if (this.zzech.size() != googleSignInOptions.zzaae().size() || !this.zzech.containsAll(googleSignInOptions.zzaae())) {
                return false;
            }
            return (this.zzdva == null ? googleSignInOptions.zzdva == null : this.zzdva.equals((Object)googleSignInOptions.zzdva)) && (TextUtils.isEmpty((CharSequence)this.zzear) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzear) : this.zzear.equals(googleSignInOptions.zzear)) && this.zzecj == googleSignInOptions.zzecj && this.zzeaq == googleSignInOptions.zzeaq && this.zzeci == googleSignInOptions.zzeci;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zzech;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.zzafs());
        }
        Collections.sort(arrayList);
        return new zzo().zzo(arrayList).zzo(this.zzdva).zzo(this.zzear).zzaq(this.zzecj).zzaq(this.zzeaq).zzaq(this.zzeci).zzaan();
    }

    public final String zzaag() {
        return this.toJsonObject().toString();
    }

    private final JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzech, zzecd);
            ArrayList<Scope> arrayList = this.zzech;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.zzafs());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzdva != null) {
                jSONObject.put("accountName", (Object)this.zzdva.name);
            }
            jSONObject.put("idTokenRequested", this.zzeaq);
            jSONObject.put("forceCodeForRefreshToken", this.zzecj);
            jSONObject.put("serverAuthRequested", this.zzeci);
            if (!TextUtils.isEmpty((CharSequence)this.zzear)) {
                jSONObject.put("serverClientId", (Object)this.zzear);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzeck)) {
                jSONObject.put("hostedDomain", (Object)this.zzeck);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map map, zzc zzc2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string2, string3, map);
    }

    public static final class Builder {
        private Set<Scope> zzecn = new HashSet<Scope>();
        private boolean zzeci;
        private boolean zzecj;
        private boolean zzeaq;
        private String zzear;
        private Account zzdva;
        private String zzeck;
        private Map<Integer, zzn> zzeco = new HashMap<Integer, zzn>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzbp.zzu((Object)googleSignInOptions);
            this.zzecn = new HashSet<Scope>(googleSignInOptions.zzech);
            this.zzeci = googleSignInOptions.zzeci;
            this.zzecj = googleSignInOptions.zzecj;
            this.zzeaq = googleSignInOptions.zzeaq;
            this.zzear = googleSignInOptions.zzear;
            this.zzdva = googleSignInOptions.zzdva;
            this.zzeck = googleSignInOptions.zzeck;
            this.zzeco = GoogleSignInOptions.zzu(googleSignInOptions.zzecl);
        }

        public final Builder requestId() {
            this.zzecn.add(zzecg);
            return this;
        }

        public final Builder requestEmail() {
            this.zzecn.add(zzecf);
            return this;
        }

        public final Builder requestProfile() {
            this.zzecn.add(zzece);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzecn.add(scope);
            this.zzecn.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string2) {
            this.zzeaq = true;
            this.zzear = this.zzep(string2);
            return this;
        }

        public final Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public final Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzeci = true;
            this.zzear = this.zzep(string2);
            this.zzecj = bl;
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzdva = new Account(zzbp.zzgf((String)string2), "com.google");
            return this;
        }

        public final Builder setHostedDomain(String string2) {
            this.zzeck = zzbp.zzgf((String)string2);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzeco.containsKey(1)) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            this.zzeco.put(1, new zzn(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.zzeaq && (this.zzdva == null || !this.zzecn.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zzecn), this.zzdva, this.zzeaq, this.zzeci, this.zzecj, this.zzear, this.zzeck, this.zzeco, null);
        }

        private final String zzep(String string2) {
            zzbp.zzgf((String)string2);
            zzbp.zzb((this.zzear == null || this.zzear.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

