/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzcp;
import com.google.android.gms.common.api.internal.zzda;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.internal.zzbp;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status status) {
        zzbp.zzb((Object)status, (Object)"Result must not be null");
        zzda zzda2 = new zzda(Looper.getMainLooper());
        zzda2.setResult(status);
        return zzda2;
    }

    public static PendingResult<Status> zza(Status status, GoogleApiClient googleApiClient) {
        zzbp.zzb((Object)status, (Object)"Result must not be null");
        zzda zzda2 = new zzda(googleApiClient);
        zzda2.setResult(status);
        return zzda2;
    }

    public static <R extends Result> PendingResult<R> zza(R r, GoogleApiClient googleApiClient) {
        zzbp.zzb(r, (Object)"Result must not be null");
        zzbp.zzb((!r.getStatus().isSuccess() ? 1 : 0) != 0, (Object)"Status code must not be SUCCESS");
        zzb<R> zzb2 = new zzb<R>(googleApiClient, r);
        zzb2.setResult(r);
        return zzb2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R r) {
        zzbp.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(null);
        zzc2.setResult(r);
        return new zzcp(zzc2);
    }

    public static <R extends Result> OptionalPendingResult<R> zzb(R r, GoogleApiClient googleApiClient) {
        zzbp.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(googleApiClient);
        zzc2.setResult(r);
        return new zzcp(zzc2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzda zzda2 = new zzda(Looper.getMainLooper());
        ((PendingResult)zzda2).cancel();
        return zzda2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R r) {
        zzbp.zzb(r, (Object)"Result must not be null");
        zzbp.zzb((r.getStatus().getStatusCode() == 16 ? 1 : 0) != 0, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(r);
        ((PendingResult)zza2).cancel();
        return zza2;
    }

    private PendingResults() {
    }

    static final class zza<R extends Result>
    extends zzs<R> {
        private final R zzfhk;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.zzfhk = r;
        }

        @Override
        protected final R zzb(Status status) {
            if (status.getStatusCode() != this.zzfhk.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zzfhk;
        }
    }

    static final class zzb<R extends Result>
    extends zzs<R> {
        private final R zzfhl;

        public zzb(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.zzfhl = r;
        }

        @Override
        protected final R zzb(Status status) {
            return this.zzfhl;
        }
    }

    static final class zzc<R extends Result>
    extends zzs<R> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected final R zzb(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

