/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzao;
import com.google.android.gms.common.api.internal.zzar;
import com.google.android.gms.common.api.internal.zzbc;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbk;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzbn;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzce;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcpm;
import com.google.android.gms.internal.zzcpn;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbl
implements zzcd,
zzx {
    private final Lock zzfjy;
    private final Condition zzfmu;
    private final Context mContext;
    private final zze zzfki;
    private final zzbn zzfmv;
    final Map<Api.zzc<?>, Api.zze> zzfmh;
    final Map<Api.zzc<?>, ConnectionResult> zzfmw = new HashMap();
    private zzq zzfkd;
    private Map<Api<?>, Boolean> zzfkg;
    private Api.zza<? extends zzcpm, zzcpn> zzfhg;
    private volatile zzbk zzfmx;
    private ConnectionResult zzfmy = null;
    int zzfmz;
    final zzbd zzfjo;
    final zzce zzfna;

    public zzbl(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcpm, zzcpn> zza2, ArrayList<zzw> arrayList, zzce zzce2) {
        this.mContext = context;
        this.zzfjy = lock;
        this.zzfki = zze2;
        this.zzfmh = map;
        this.zzfkd = zzq2;
        this.zzfkg = map2;
        this.zzfhg = zza2;
        this.zzfjo = zzbd2;
        this.zzfna = zzce2;
        ArrayList<zzw> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList2.get(i);
            zzw2.zza(this);
        }
        this.zzfmv = new zzbn(this, looper);
        this.zzfmu = lock.newCondition();
        this.zzfmx = new zzbc(this);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        t.zzagf();
        return this.zzfmx.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        t.zzagf();
        return this.zzfmx.zze(t);
    }

    @Override
    public final void connect() {
        this.zzfmx.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfmu.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfez;
        }
        if (this.zzfmy != null) {
            return this.zzfmy;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfmu.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfez;
        }
        if (this.zzfmy != null) {
            return this.zzfmy;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        if (this.zzfmx.disconnect()) {
            this.zzfmw.clear();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzafd();
        if (this.zzfmh.containsKey(zzc2)) {
            if (this.zzfmh.get(zzc2).isConnected()) {
                return ConnectionResult.zzfez;
            }
            if (this.zzfmw.containsKey(zzc2)) {
                return this.zzfmw.get(zzc2);
            }
        }
        return null;
    }

    final void zzahk() {
        this.zzfjy.lock();
        try {
            this.zzfmx = new zzar(this, this.zzfkd, this.zzfkg, this.zzfki, this.zzfhg, this.zzfjy, this.mContext);
            this.zzfmx.begin();
            this.zzfmu.signalAll();
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    final void zzahl() {
        this.zzfjy.lock();
        try {
            this.zzfjo.zzahh();
            this.zzfmx = new zzao(this);
            this.zzfmx.begin();
            this.zzfmu.signalAll();
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    final void zzg(ConnectionResult connectionResult) {
        this.zzfjy.lock();
        try {
            this.zzfmy = connectionResult;
            this.zzfmx = new zzbc(this);
            this.zzfmx.begin();
            this.zzfmu.signalAll();
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zzfmx instanceof zzao;
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfmx instanceof zzar;
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        return false;
    }

    @Override
    public final void zzafo() {
    }

    @Override
    public final void zzagh() {
        if (this.isConnected()) {
            ((zzao)this.zzfmx).zzagx();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzfjy.lock();
        try {
            this.zzfmx.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzfjy.lock();
        try {
            this.zzfmx.onConnected(bundle);
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzfjy.lock();
        try {
            this.zzfmx.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    final void zza(zzbm zzbm2) {
        Message message = this.zzfmv.obtainMessage(1, zzbm2);
        this.zzfmv.sendMessage(message);
    }

    final void zza(RuntimeException runtimeException) {
        Message message = this.zzfmv.obtainMessage(2, runtimeException);
        this.zzfmv.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzfmx);
        for (Api<?> api : this.zzfkg.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zzfmh.get(api.zzafd()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbl zzbl2) {
        return zzbl2.zzfjy;
    }

    static /* synthetic */ zzbk zzb(zzbl zzbl2) {
        return zzbl2.zzfmx;
    }
}

