/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.data.zzf;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzc;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@KeepName
public final class DataHolder
extends com.google.android.gms.common.internal.safeparcel.zza
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new zzf();
    private int zzdxt;
    private final String[] zzfqf;
    private Bundle zzfqg;
    private final CursorWindow[] zzfqh;
    private final int zzezx;
    private final Bundle zzfqi;
    private int[] zzfqj;
    int zzfqk;
    private boolean mClosed = false;
    private boolean zzfql = true;
    private static final zza zzfqm = new zze(new String[0], null);

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.zzdxt = n;
        this.zzfqf = stringArray;
        this.zzfqh = cursorWindowArray;
        this.zzezx = n2;
        this.zzfqi = bundle;
    }

    private DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.zzdxt = 1;
        this.zzfqf = (String[])zzbp.zzu((Object)stringArray);
        this.zzfqh = (CursorWindow[])zzbp.zzu((Object)cursorWindowArray);
        this.zzezx = n;
        this.zzfqi = bundle;
        this.zzaiv();
    }

    private DataHolder(zza zza2, int n, Bundle bundle) {
        this(zza2.zzfqf, DataHolder.zza(zza2, -1), n, null);
    }

    public final void zzaiv() {
        int n;
        this.zzfqg = new Bundle();
        for (n = 0; n < this.zzfqf.length; ++n) {
            this.zzfqg.putInt(this.zzfqf[n], n);
        }
        this.zzfqj = new int[this.zzfqh.length];
        n = 0;
        for (int i = 0; i < this.zzfqh.length; ++i) {
            this.zzfqj[i] = n;
            int n2 = this.zzfqh[i].getStartPosition();
            int n3 = n - n2;
            n += this.zzfqh[i].getNumRows() - n3;
        }
        this.zzfqk = n;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataHolder dataHolder = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String[])dataHolder.zzfqf, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable[])dataHolder.zzfqh, (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, (int)dataHolder.zzezx);
        zzd.zza((Parcel)parcel2, (int)4, (Bundle)dataHolder.zzfqi, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataHolder.zzdxt);
        zzd.zzai((Parcel)parcel2, (int)n2);
        if ((n & 1) != 0) {
            this.close();
        }
    }

    public final int getStatusCode() {
        return this.zzezx;
    }

    public final Bundle zzafh() {
        return this.zzfqi;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zzfqf.length == 0) {
            return new CursorWindow[0];
        }
        ArrayList arrayList = zza2.zzfqn;
        int n2 = arrayList.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList2 = new ArrayList<CursorWindow>();
        arrayList2.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zzfqf.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzfqf.length);
                    arrayList2.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList2.remove(cursorWindow);
                        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
                    }
                }
                Map map = (Map)arrayList.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < zza2.zzfqf.length && bl2; ++n3) {
                    String string2 = zza2.zzfqf[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzfqf.length);
                    arrayList2.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList2.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList2.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
    }

    private final void zzh(String string2, int n) {
        if (this.zzfqg == null || !this.zzfqg.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zzfqk) {
            throw new CursorIndexOutOfBoundsException(n, this.zzfqk);
        }
    }

    public final boolean zzft(String string2) {
        return this.zzfqg.containsKey(string2);
    }

    public final long zzb(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqh[n2].getLong(n, this.zzfqg.getInt(string2));
    }

    public final int zzc(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqh[n2].getInt(n, this.zzfqg.getInt(string2));
    }

    public final String zzd(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqh[n2].getString(n, this.zzfqg.getInt(string2));
    }

    public final boolean zze(String string2, int n, int n2) {
        this.zzh(string2, n);
        return Long.valueOf(this.zzfqh[n2].getLong(n, this.zzfqg.getInt(string2))) == 1L;
    }

    public final float zzf(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqh[n2].getFloat(n, this.zzfqg.getInt(string2));
    }

    public final byte[] zzg(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqh[n2].getBlob(n, this.zzfqg.getInt(string2));
    }

    public final void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzh(string2, n);
        this.zzfqh[n2].copyStringToBuffer(n, this.zzfqg.getInt(string2), charArrayBuffer);
    }

    public final boolean zzh(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqh[n2].isNull(n, this.zzfqg.getInt(string2));
    }

    public final int getCount() {
        return this.zzfqk;
    }

    public final int zzbw(int n) {
        int n2;
        zzbp.zzbg((n >= 0 && n < this.zzfqk ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zzfqj.length; ++n2) {
            if (n >= this.zzfqj[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zzfqj.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zzfqh.length; ++i) {
                    this.zzfqh[i].close();
                }
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        try {
            if (this.zzfql && this.zzfqh.length > 0 && !this.isClosed()) {
                this.close();
                String string2 = this.toString();
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public static zza zza(String[] stringArray) {
        return new zza(stringArray, null, null);
    }

    public static DataHolder zzbx(int n) {
        int n2 = n;
        return new DataHolder(zzfqm, n2, null);
    }

    /* synthetic */ DataHolder(zza zza2, int n, Bundle bundle, zze zze2) {
        this(zza2, 0, null);
    }

    public static final class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zzfqf;
        private final ArrayList<HashMap<String, Object>> zzfqn;
        private final String zzfqo;
        private final HashMap<Object, Integer> zzfqp;
        private boolean zzfqq;
        private String zzfqr;

        private zza(String[] stringArray, String string2) {
            this.zzfqf = (String[])zzbp.zzu((Object)stringArray);
            this.zzfqn = new ArrayList();
            this.zzfqo = string2;
            this.zzfqp = new HashMap();
            this.zzfqq = false;
            this.zzfqr = null;
        }

        public zza zza(HashMap<String, Object> hashMap) {
            int n;
            int n2;
            zzc.zzr(hashMap);
            HashMap<String, Object> hashMap2 = hashMap;
            zza zza2 = this;
            if (zza2.zzfqo == null) {
                n2 = -1;
            } else {
                Object object = hashMap2.get(zza2.zzfqo);
                if (object == null) {
                    n2 = -1;
                } else {
                    Integer n3 = zza2.zzfqp.get(object);
                    if (n3 == null) {
                        zza2.zzfqp.put(object, zza2.zzfqn.size());
                        n2 = -1;
                    } else {
                        n2 = n = n3.intValue();
                    }
                }
            }
            if (n2 == -1) {
                this.zzfqn.add(hashMap);
            } else {
                this.zzfqn.remove(n);
                this.zzfqn.add(n, hashMap);
            }
            this.zzfqq = false;
            return this;
        }

        public zza zza(ContentValues contentValues) {
            zzc.zzr((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            for (Map.Entry entry : contentValues.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zza(hashMap);
        }

        public final DataHolder zzby(int n) {
            return new DataHolder(this, 0, null, null);
        }

        /* synthetic */ zza(String[] stringArray, String string2, zze zze2) {
            this(stringArray, null);
        }
    }
}

