/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.util.LruCache;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.internal.zzbcb;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object zzfqv = new Object();
    private static HashSet<Uri> zzfqw = new HashSet();
    private static ImageManager zzfqx;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zzfqy;
    private final zza zzfqz;
    private final zzbcb zzfra;
    private final Map<com.google.android.gms.common.images.zza, ImageReceiver> zzfrb;
    private final Map<Uri, ImageReceiver> zzfrc;
    private final Map<Uri, Long> zzfrd;

    public static ImageManager create(Context context) {
        Context context2 = context;
        if (zzfqx == null) {
            zzfqx = new ImageManager(context2, false);
        }
        return zzfqx;
    }

    private ImageManager(Context context, boolean bl) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzfqy = Executors.newFixedThreadPool(4);
        this.zzfqz = null;
        this.zzfra = new zzbcb();
        this.zzfrb = new HashMap<com.google.android.gms.common.images.zza, ImageReceiver>();
        this.zzfrc = new HashMap<Uri, ImageReceiver>();
        this.zzfrd = new HashMap<Uri, Long>();
    }

    public final void loadImage(ImageView imageView, Uri uri) {
        com.google.android.gms.common.images.zzc zzc2 = new com.google.android.gms.common.images.zzc(imageView, uri);
        this.zza(zzc2);
    }

    public final void loadImage(ImageView imageView, int n) {
        com.google.android.gms.common.images.zzc zzc2 = new com.google.android.gms.common.images.zzc(imageView, n);
        this.zza(zzc2);
    }

    public final void loadImage(ImageView imageView, Uri uri, int n) {
        com.google.android.gms.common.images.zzc zzc2 = new com.google.android.gms.common.images.zzc(imageView, uri);
        new com.google.android.gms.common.images.zzc(imageView, uri).zzfrl = n;
        this.zza(zzc2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        com.google.android.gms.common.images.zzd zzd2 = new com.google.android.gms.common.images.zzd(onImageLoadedListener, uri);
        this.zza(zzd2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        com.google.android.gms.common.images.zzd zzd2 = new com.google.android.gms.common.images.zzd(onImageLoadedListener, uri);
        new com.google.android.gms.common.images.zzd(onImageLoadedListener, uri).zzfrl = n;
        this.zza(zzd2);
    }

    private final void zza(com.google.android.gms.common.images.zza zza2) {
        com.google.android.gms.common.internal.zzc.zzfx((String)"ImageManager.loadImage() must be called in the main thread");
        new zzc(this, zza2).run();
    }

    private final Bitmap zza(com.google.android.gms.common.images.zzb zzb2) {
        if (this.zzfqz == null) {
            return null;
        }
        return (Bitmap)this.zzfqz.get(zzb2);
    }

    static final class zza
    extends LruCache<com.google.android.gms.common.images.zzb, Bitmap> {
        protected final /* synthetic */ int sizeOf(Object object, Object object2) {
            Bitmap bitmap = (Bitmap)object2;
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected final /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, Object object3) {
            Bitmap bitmap = (Bitmap)object3;
            Bitmap bitmap2 = (Bitmap)object2;
            com.google.android.gms.common.images.zzb zzb2 = (com.google.android.gms.common.images.zzb)object;
            super.entryRemoved(bl, (Object)zzb2, (Object)bitmap2, (Object)bitmap);
        }
    }

    final class zzd
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zzaop;
        private boolean zzfri;
        private /* synthetic */ ImageManager zzfrf;

        public zzd(ImageManager imageManager, Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.zzfrf = imageManager;
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.zzfri = bl;
            this.zzaop = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            com.google.android.gms.common.internal.zzc.zzfx((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (this.zzfrf.zzfqz != null) {
                if (this.zzfri) {
                    this.zzfrf.zzfqz.evictAll();
                    System.gc();
                    this.zzfri = false;
                    this.zzfrf.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    this.zzfrf.zzfqz.put(new com.google.android.gms.common.images.zzb(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)this.zzfrf.zzfrc.remove(this.mUri))) != null) {
                boolean bl3 = bl;
                ImageReceiver imageReceiver2 = imageReceiver;
                zzd zzd2 = this;
                ArrayList arrayList = imageReceiver2.zzfre;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.images.zza zza2 = (com.google.android.gms.common.images.zza)arrayList.get(i);
                    if (bl3) {
                        zza2.zza(zzd2.zzfrf.mContext, zzd2.mBitmap, false);
                    } else {
                        zzd2.zzfrf.zzfrd.put(zzd2.mUri, SystemClock.elapsedRealtime());
                        zza2.zza(zzd2.zzfrf.mContext, zzd2.zzfrf.zzfra, false);
                    }
                    if (zza2 instanceof com.google.android.gms.common.images.zzd) continue;
                    zzd2.zzfrf.zzfrb.remove(zza2);
                }
            }
            this.zzaop.countDown();
            Object object = zzfqv;
            synchronized (object) {
                zzfqw.remove(this.mUri);
                return;
            }
        }
    }

    final class zzb
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor zzfrg;
        private /* synthetic */ ImageManager zzfrf;

        public zzb(ImageManager imageManager, Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.zzfrf = imageManager;
            this.mUri = uri;
            this.zzfrg = parcelFileDescriptor;
        }

        @Override
        public final void run() {
            String string2 = "LoadBitmapFromDiskRunnable can't be executed in the main thread";
            if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
                String string3 = String.valueOf(Thread.currentThread());
                String string4 = String.valueOf(Looper.getMainLooper().getThread());
                Log.e((String)"Asserts", (String)new StringBuilder(56 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("checkNotMainThread: current thread ").append(string3).append(" IS the main thread ").append(string4).append("!").toString());
                throw new IllegalStateException(string2);
            }
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zzfrg != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zzfrg.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string5 = String.valueOf(this.mUri);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string5).length()).append("OOM while loading bitmap for uri: ").append(string5).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zzfrg.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.zzfrf.mHandler.post((Runnable)new zzd(this.zzfrf, this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                String string6 = String.valueOf(this.mUri);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string6).length()).append("Latch interrupted while posting ").append(string6).toString());
                return;
            }
        }
    }

    @KeepName
    final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.zza> zzfre;
        private /* synthetic */ ImageManager zzfrf;

        ImageReceiver(ImageManager imageManager, Uri uri) {
            this.zzfrf = imageManager;
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.zzfre = new ArrayList();
        }

        public final void zzb(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzc.zzfx((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zzfre.add(zza2);
        }

        public final void zzc(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzc.zzfx((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zzfre.remove(zza2);
        }

        public final void zzaiz() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            this.zzfrf.mContext.sendBroadcast(intent);
        }

        public final void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            this.zzfrf.zzfqy.execute(new zzb(this.zzfrf, this.mUri, parcelFileDescriptor));
        }
    }

    final class zzc
    implements Runnable {
        private final com.google.android.gms.common.images.zza zzfrh;
        private /* synthetic */ ImageManager zzfrf;

        public zzc(ImageManager imageManager, com.google.android.gms.common.images.zza zza2) {
            this.zzfrf = imageManager;
            this.zzfrh = zza2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            com.google.android.gms.common.internal.zzc.zzfx((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)this.zzfrf.zzfrb.get(this.zzfrh));
            if (imageReceiver != null) {
                this.zzfrf.zzfrb.remove(this.zzfrh);
                imageReceiver.zzc(this.zzfrh);
            }
            com.google.android.gms.common.images.zzb zzb2 = this.zzfrh.zzfrj;
            if (zzb2.uri == null) {
                this.zzfrh.zza(this.zzfrf.mContext, this.zzfrf.zzfra, true);
                return;
            }
            Bitmap bitmap = this.zzfrf.zza(zzb2);
            if (bitmap != null) {
                this.zzfrh.zza(this.zzfrf.mContext, bitmap, true);
                return;
            }
            Long l = (Long)this.zzfrf.zzfrd.get(zzb2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zzfrh.zza(this.zzfrf.mContext, this.zzfrf.zzfra, true);
                    return;
                }
                this.zzfrf.zzfrd.remove(zzb2.uri);
            }
            this.zzfrh.zza(this.zzfrf.mContext, this.zzfrf.zzfra);
            imageReceiver = (ImageReceiver)((Object)this.zzfrf.zzfrc.get(zzb2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(this.zzfrf, zzb2.uri);
                this.zzfrf.zzfrc.put(zzb2.uri, imageReceiver);
            }
            imageReceiver.zzb(this.zzfrh);
            if (!(this.zzfrh instanceof com.google.android.gms.common.images.zzd)) {
                this.zzfrf.zzfrb.put(this.zzfrh, imageReceiver);
            }
            Object object = zzfqv;
            synchronized (object) {
                if (!zzfqw.contains(zzb2.uri)) {
                    zzfqw.add(zzb2.uri);
                    imageReceiver.zzaiz();
                }
                return;
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

