/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzac;
import com.google.android.gms.common.api.internal.zzaf;
import com.google.android.gms.common.api.internal.zzag;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzdm;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbdy;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzad
implements zzcd {
    private final Map<Api.zzc<?>, zzac<?>> zzfkj = new HashMap();
    private final Map<Api.zzc<?>, zzac<?>> zzfkk = new HashMap();
    private final Map<Api<?>, Boolean> zzfkl;
    private final zzbp zzfgu;
    private final zzbd zzfkm;
    private final Lock zzfkd;
    private final Looper zzakf;
    private final zze zzfkn;
    private final Condition zzfko;
    private final zzq zzfki;
    private final boolean zzfkp;
    private final boolean zzfkq;
    private final Queue<zzm<?, ?>> zzfkr = new LinkedList();
    private boolean zzfks;
    private Map<zzh<?>, ConnectionResult> zzfkt;
    private Map<zzh<?>, ConnectionResult> zzfku;
    private zzag zzfkv;
    private ConnectionResult zzfkw;

    public zzad(Context context, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcps, zzcpt> zza2, ArrayList<zzw> arrayList, zzbd zzbd2, boolean bl) {
        this.zzfkd = lock;
        this.zzakf = looper;
        this.zzfko = lock.newCondition();
        this.zzfkn = zze2;
        this.zzfkm = zzbd2;
        this.zzfkl = map2;
        this.zzfki = zzq2;
        this.zzfkp = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.zzafe(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zzw> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList2.get(i);
            zzw zzw3 = zzw2;
            hashMap2.put(zzw3.zzfdf, zzw3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze3 = entry.getValue();
            if (zze3.zzaff()) {
                bl4 = true;
                if (!this.zzfkl.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zzw zzw4 = (zzw)hashMap2.get(api);
            zzac zzac2 = new zzac(context, api, looper, zze3, zzw4, zzq2, zza2);
            this.zzfkj.put(entry.getKey(), zzac2);
            if (!zze3.zzaac()) continue;
            this.zzfkk.put(entry.getKey(), zzac2);
        }
        this.zzfkq = bl4 && !bl3 && !bl2;
        this.zzfgu = zzbp.zzaho();
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzfkp && this.zzg(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zzfkr.add(t);
            return t;
        }
        this.zzfkm.zzfms.zzb(t);
        return this.zzfkj.get(t.zzafe()).zza(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        Api.zzc<A> zzc2 = t.zzafe();
        if (this.zzfkp && this.zzg(t)) {
            return t;
        }
        this.zzfkm.zzfms.zzb(t);
        return this.zzfkj.get(zzc2).zzb(t);
    }

    private final <T extends zzm<? extends Result, ? extends Api.zzb>> boolean zzg(@NonNull T t) {
        Api.zzc<? extends Api.zzb> zzc2 = t.zzafe();
        ConnectionResult connectionResult = this.zzb(zzc2);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.zzt(new Status(4, null, this.zzfgu.zza(this.zzfkj.get(zzc2).zzafk(), System.identityHashCode(this.zzfkm))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zzfkd.lock();
        try {
            if (this.zzfks) {
                return;
            }
            this.zzfks = true;
            this.zzfkt = null;
            this.zzfku = null;
            this.zzfkv = null;
            this.zzfkw = null;
            this.zzfgu.zzafw();
            this.zzfgu.zza(this.zzfkj.values()).addOnCompleteListener((Executor)new zzbdy(this.zzakf), (OnCompleteListener)new zzaf(this, null));
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfko.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzffe;
        }
        if (this.zzfkw != null) {
            return this.zzfkw;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfko.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzffe;
        }
        if (this.zzfkw != null) {
            return this.zzfkw;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zzfkd.lock();
        try {
            this.zzfks = false;
            this.zzfkt = null;
            this.zzfku = null;
            if (this.zzfkv != null) {
                this.zzfkv.cancel();
                this.zzfkv = null;
            }
            this.zzfkw = null;
            while (!this.zzfkr.isEmpty()) {
                zzm<?, ?> zzm2 = this.zzfkr.remove();
                ((zzs)zzm2).zza((zzdm)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfko.signalAll();
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zzb(api.zzafe());
    }

    @Nullable
    private final ConnectionResult zzb(@NonNull Api.zzc<?> zzc2) {
        this.zzfkd.lock();
        try {
            zzac<?> zzac2 = this.zzfkj.get(zzc2);
            if (this.zzfkt != null && zzac2 != null) {
                ConnectionResult connectionResult = this.zzfkt.get(zzac2.zzafk());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        this.zzfkd.lock();
        try {
            boolean bl = this.zzfkt != null && this.zzfkw == null;
            return bl;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfkd.lock();
        try {
            boolean bl = this.zzfkt == null && this.zzfks;
            return bl;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    private final boolean zzago() {
        this.zzfkd.lock();
        try {
            if (!this.zzfks || !this.zzfkp) {
                return false;
            }
            for (Api.zzc<?> zzc2 : this.zzfkk.keySet()) {
                ConnectionResult connectionResult = this.zzb(zzc2);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        this.zzfkd.lock();
        try {
            if (this.zzfks && !this.zzago()) {
                this.zzfgu.zzafw();
                this.zzfkv = new zzag(this, zzcv2);
                this.zzfgu.zza(this.zzfkk.values()).addOnCompleteListener((Executor)new zzbdy(this.zzakf), (OnCompleteListener)this.zzfkv);
                return true;
            }
            return false;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final void zzafp() {
        this.zzfkd.lock();
        try {
            this.zzfgu.zzafp();
            if (this.zzfkv != null) {
                this.zzfkv.cancel();
                this.zzfkv = null;
            }
            if (this.zzfku == null) {
                this.zzfku = new ArrayMap(this.zzfkk.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzac<?> zzac2 : this.zzfkk.values()) {
                this.zzfku.put(zzac2.zzafk(), connectionResult);
            }
            if (this.zzfkt != null) {
                this.zzfkt.putAll(this.zzfku);
            }
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zzagi() {
    }

    private final void zzagp() {
        if (this.zzfki == null) {
            this.zzfkm.zzfmn = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzfki.zzajs());
        Map<Api<?>, com.google.android.gms.common.internal.zzs> map = this.zzfki.zzaju();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).zzecl);
        }
        this.zzfkm.zzfmn = hashSet;
    }

    private final void zzagq() {
        while (!this.zzfkr.isEmpty()) {
            this.zze(this.zzfkr.remove());
        }
        this.zzfkm.zzj(null);
    }

    private final boolean zza(zzac<?> zzac2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzfkl.get(zzac2.zzafj()) != false && zzac2.zzagn().zzaff() && this.zzfkn.isUserResolvableError(connectionResult.getErrorCode());
    }

    @Nullable
    private final ConnectionResult zzagr() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzac<?> zzac2 : this.zzfkj.values()) {
            int n3;
            Api api = zzac2.zzafj();
            zzh zzh2 = zzac2.zzafk();
            ConnectionResult connectionResult3 = this.zzfkt.get(zzh2);
            if (connectionResult3.isSuccess() || this.zzfkl.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzfkn.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzfkp) {
                n3 = api.zzafc().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zzafc().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zza(zzad zzad2) {
        return zzad2.zzfkd;
    }

    static /* synthetic */ boolean zzb(zzad zzad2) {
        return zzad2.zzfks;
    }

    static /* synthetic */ Map zza(zzad zzad2, Map map) {
        zzad2.zzfkt = map;
        return zzad2.zzfkt;
    }

    static /* synthetic */ Map zzc(zzad zzad2) {
        return zzad2.zzfkj;
    }

    static /* synthetic */ Map zzd(zzad zzad2) {
        return zzad2.zzfkt;
    }

    static /* synthetic */ boolean zze(zzad zzad2) {
        return zzad2.zzfkq;
    }

    static /* synthetic */ boolean zza(zzad zzad2, zzac zzac2, ConnectionResult connectionResult) {
        return zzad2.zza(zzac2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zza(zzad zzad2, ConnectionResult connectionResult) {
        zzad2.zzfkw = connectionResult;
        return zzad2.zzfkw;
    }

    static /* synthetic */ ConnectionResult zzf(zzad zzad2) {
        return zzad2.zzagr();
    }

    static /* synthetic */ Map zzg(zzad zzad2) {
        return zzad2.zzfku;
    }

    static /* synthetic */ ConnectionResult zzh(zzad zzad2) {
        return zzad2.zzfkw;
    }

    static /* synthetic */ void zzi(zzad zzad2) {
        zzad2.zzagp();
    }

    static /* synthetic */ void zzj(zzad zzad2) {
        zzad2.zzagq();
    }

    static /* synthetic */ boolean zza(zzad zzad2, boolean bl) {
        zzad2.zzfks = false;
        return false;
    }

    static /* synthetic */ zzbd zzk(zzad zzad2) {
        return zzad2.zzfkm;
    }

    static /* synthetic */ Condition zzl(zzad zzad2) {
        return zzad2.zzfko;
    }

    static /* synthetic */ Map zzb(zzad zzad2, Map map) {
        zzad2.zzfku = map;
        return zzad2.zzfku;
    }

    static /* synthetic */ Map zzm(zzad zzad2) {
        return zzad2.zzfkk;
    }
}

