/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArraySet;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzak;
import com.google.android.gms.common.api.internal.zzbq;
import com.google.android.gms.common.api.internal.zzbr;
import com.google.android.gms.common.api.internal.zzc;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzcq;
import com.google.android.gms.common.api.internal.zzcr;
import com.google.android.gms.common.api.internal.zzcs;
import com.google.android.gms.common.api.internal.zzcz;
import com.google.android.gms.common.api.internal.zzd;
import com.google.android.gms.common.api.internal.zzdd;
import com.google.android.gms.common.api.internal.zzdn;
import com.google.android.gms.common.api.internal.zze;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzbp
implements Handler.Callback {
    public static final Status zzfnj = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zzfnk = new Status(4, "The user must be signed in to make this API call.");
    private long zzfmj = 5000L;
    private long zzfmi = 120000L;
    private long zzfnl = 10000L;
    private static final Object zzaqc = new Object();
    private static zzbp zzfnm;
    private final Context mContext;
    private final GoogleApiAvailability zzfhk;
    private int zzfnn = -1;
    private final AtomicInteger zzfno = new AtomicInteger(1);
    private final AtomicInteger zzfnp = new AtomicInteger(0);
    private final Map<zzh<?>, zzbr<?>> zzfkj = new ConcurrentHashMap(5, 0.75f, 1);
    private zzak zzfnq = null;
    private final Set<zzh<?>> zzfnr = new ArraySet();
    private final Set<zzh<?>> zzfns = new ArraySet();
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbp zzca(Context context) {
        Object object = zzaqc;
        synchronized (object) {
            if (zzfnm == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zzfnm = new zzbp(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zzfnm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbp zzaho() {
        Object object = zzaqc;
        synchronized (object) {
            com.google.android.gms.common.internal.zzbp.zzb((Object)zzfnm, (Object)"Must guarantee manager is non-null before using getInstance");
            return zzfnm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzahp() {
        Object object = zzaqc;
        synchronized (object) {
            if (zzfnm != null) {
                zzbp zzbp2 = zzfnm;
                zzbp2.zzfnp.incrementAndGet();
                zzbp2.mHandler.sendMessageAtFrontOfQueue(zzbp2.mHandler.obtainMessage(10));
            }
            return;
        }
    }

    private zzbp(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
        this.zzfhk = googleApiAvailability;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6));
    }

    public final int zzahq() {
        return this.zzfno.getAndIncrement();
    }

    public final void zza(GoogleApi<?> googleApi) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final void zzb(GoogleApi<?> googleApi) {
        zzh<?> zzh2 = googleApi.zzafk();
        zzbr<Object> zzbr2 = this.zzfkj.get(zzh2);
        if (zzbr2 == null) {
            zzbr2 = new zzbr(this, googleApi);
            this.zzfkj.put(zzh2, zzbr2);
        }
        if (zzbr2.zzaac()) {
            this.zzfns.add(zzh2);
        }
        zzbr2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull zzak zzak2) {
        Object object = zzaqc;
        synchronized (object) {
            if (this.zzfnq != zzak2) {
                this.zzfnq = zzak2;
                this.zzfnr.clear();
                this.zzfnr.addAll((Collection<zzh<?>>)zzak2.zzagv());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzb(@NonNull zzak zzak2) {
        Object object = zzaqc;
        synchronized (object) {
            if (this.zzfnq == zzak2) {
                this.zzfnq = null;
                this.zzfnr.clear();
            }
            return;
        }
    }

    public final Task<Void> zza(Iterable<? extends GoogleApi<?>> iterable) {
        zzj zzj2 = new zzj(iterable);
        for (GoogleApi<?> googleApi : iterable) {
            zzbr<?> zzbr2 = this.zzfkj.get(googleApi.zzafk());
            if (zzbr2 != null && zzbr2.isConnected()) continue;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)zzj2));
            return zzj2.getTask();
        }
        zzj2.zzafy();
        return zzj2.getTask();
    }

    public final void zzafw() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
    }

    final void zzafp() {
        this.zzfnp.incrementAndGet();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(10));
    }

    @WorkerThread
    private final void zzahr() {
        for (zzh<?> zzh2 : this.zzfns) {
            this.zzfkj.remove(zzh2).signOut();
        }
        this.zzfns.clear();
    }

    public final <O extends Api.ApiOptions> void zza(GoogleApi<O> googleApi, int n, zzm<? extends Result, Api.zzb> zzm2) {
        zzc<zzm<? extends Result, Api.zzb>> zzc2 = new zzc<zzm<? extends Result, Api.zzb>>(n, zzm2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzcq(zzc2, this.zzfnp.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, TResult> void zza(GoogleApi<O> googleApi, int n, zzdd<Api.zzb, TResult> zzdd2, TaskCompletionSource<TResult> taskCompletionSource, zzcz zzcz2) {
        zze<TResult> zze2 = new zze<TResult>(n, zzdd2, taskCompletionSource, zzcz2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzcq(zze2, this.zzfnp.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzcr<Api.zzb, ?> zzcr2, @NonNull zzdn<Api.zzb, ?> zzdn2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzd zzd2 = new zzd(new zzcs(zzcr2, zzdn2), (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(8, (Object)new zzcq(zzd2, this.zzfnp.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Boolean> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzcl<?> zzcl2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzf zzf2 = new zzf(zzcl2, (TaskCompletionSource<Boolean>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(13, (Object)new zzcq(zzf2, this.zzfnp.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public final boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                zzbp zzbp2 = this;
                this.zzfnl = bl ? 10000L : 300000L;
                zzbp2.mHandler.removeMessages(12);
                for (zzh<?> zzh2 : zzbp2.zzfkj.keySet()) {
                    zzbp2.mHandler.sendMessageDelayed(zzbp2.mHandler.obtainMessage(12, zzh2), zzbp2.zzfnl);
                }
                break;
            }
            case 2: {
                zzj zzj2 = (zzj)message.obj;
                zzbp zzbp3 = this;
                for (zzh<?> zzh3 : zzj2.zzafx()) {
                    zzbr<?> zzbr2 = zzbp3.zzfkj.get(zzh3);
                    if (zzbr2 == null) {
                        ConnectionResult connectionResult = new ConnectionResult(13);
                        zzj2.zza(zzh3, connectionResult);
                        break block0;
                    }
                    if (zzbr2.isConnected()) {
                        zzj2.zza(zzh3, ConnectionResult.zzffe);
                        continue;
                    }
                    if (zzbr2.zzahy() != null) {
                        zzj2.zza(zzh3, zzbr2.zzahy());
                        continue;
                    }
                    zzbr2.zza(zzj2);
                }
                break;
            }
            case 3: {
                for (zzbr<?> zzbr3 : this.zzfkj.values()) {
                    zzbr3.zzahx();
                    zzbr3.connect();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zzcq zzcq2 = (zzcq)message.obj;
                zzbp zzbp4 = this;
                zzbr<?> zzbr4 = zzbp4.zzfkj.get(zzcq2.zzfpa.zzafk());
                if (zzbr4 == null) {
                    zzbp4.zzb(zzcq2.zzfpa);
                    zzbr4 = zzbp4.zzfkj.get(zzcq2.zzfpa.zzafk());
                }
                if (zzbr4.zzaac() && zzbp4.zzfnp.get() != zzcq2.zzfoz) {
                    zzcq2.zzfoy.zzr(zzfnj);
                    zzbr4.signOut();
                    break;
                }
                zzbr4.zza(zzcq2.zzfoy);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                zzbp zzbp5 = this;
                zzbr<?> zzbr5 = null;
                for (zzbr<?> zzbr6 : zzbp5.zzfkj.values()) {
                    if (zzbr6.getInstanceId() != n) continue;
                    zzbr5 = zzbr6;
                    break;
                }
                if (zzbr5 != null) {
                    zzbr<?> zzbr6;
                    String string2 = zzbp5.zzfhk.getErrorString(connectionResult.getErrorCode());
                    zzbr6 = connectionResult.getErrorMessage();
                    zzbr5.zzv(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zzbr6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zzbr6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                zzbp zzbp6 = this;
                if (!(zzbp6.mContext.getApplicationContext() instanceof Application)) break;
                zzk.zza((Application)((Application)zzbp6.mContext.getApplicationContext()));
                zzk.zzafz().zza((zzl)new zzbq(zzbp6));
                if (zzk.zzafz().zzbd(true)) break;
                zzbp6.zzfnl = 300000L;
                break;
            }
            case 7: {
                this.zzb((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zzfkj.containsKey(message.obj)) break;
                this.zzfkj.get(message.obj).resume();
                break;
            }
            case 10: {
                this.zzahr();
                break;
            }
            case 11: {
                if (!this.zzfkj.containsKey(message.obj)) break;
                this.zzfkj.get(message.obj).zzahh();
                break;
            }
            case 12: {
                if (!this.zzfkj.containsKey(message.obj)) break;
                this.zzfkj.get(message.obj).zzaib();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final PendingIntent zza(zzh<?> zzh2, int n) {
        zzbr<?> zzbr2 = this.zzfkj.get(zzh2);
        if (zzbr2 == null) {
            return null;
        }
        zzcps zzcps2 = zzbr2.zzaic();
        if (zzcps2 == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)n, (Intent)zzcps2.zzaam(), (int)0x8000000);
    }

    final boolean zzc(ConnectionResult connectionResult, int n) {
        return this.zzfhk.zza(this.mContext, connectionResult, n);
    }

    public final void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    static /* synthetic */ Handler zza(zzbp zzbp2) {
        return zzbp2.mHandler;
    }

    static /* synthetic */ Context zzb(zzbp zzbp2) {
        return zzbp2.mContext;
    }

    static /* synthetic */ long zzc(zzbp zzbp2) {
        return zzbp2.zzfmj;
    }

    static /* synthetic */ long zzd(zzbp zzbp2) {
        return zzbp2.zzfmi;
    }

    static /* synthetic */ int zza(zzbp zzbp2, int n) {
        zzbp2.zzfnn = n;
        return zzbp2.zzfnn;
    }

    static /* synthetic */ Status zzahs() {
        return zzfnk;
    }

    static /* synthetic */ Object zzaht() {
        return zzaqc;
    }

    static /* synthetic */ zzak zze(zzbp zzbp2) {
        return zzbp2.zzfnq;
    }

    static /* synthetic */ Set zzf(zzbp zzbp2) {
        return zzbp2.zzfnr;
    }

    static /* synthetic */ GoogleApiAvailability zzg(zzbp zzbp2) {
        return zzbp2.zzfhk;
    }

    static /* synthetic */ long zzh(zzbp zzbp2) {
        return zzbp2.zzfnl;
    }

    static /* synthetic */ int zzi(zzbp zzbp2) {
        return zzbp2.zzfnn;
    }

    static /* synthetic */ Map zzj(zzbp zzbp2) {
        return zzbp2.zzfkj;
    }
}

