/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zze;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
extends zzbck {
    public static final Parcelable.Creator<WebImage> CREATOR = new zze();
    private int zzdxr;
    private final Uri zzeux;
    private final int zzakp;
    private final int zzakq;

    WebImage(int n, Uri uri, int n2, int n3) {
        this.zzdxr = n;
        this.zzeux = uri;
        this.zzakp = n2;
        this.zzakq = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zzp(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    private static Uri zzp(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {}
        }
        return uri;
    }

    public final Uri getUrl() {
        return this.zzeux;
    }

    public final int getWidth() {
        return this.zzakp;
    }

    public final int getHeight() {
        return this.zzakq;
    }

    public final String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zzakp, this.zzakq, this.zzeux.toString());
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zzeux.toString());
            jSONObject.put("width", this.zzakp);
            jSONObject.put("height", this.zzakq);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return zzbf.equal((Object)this.zzeux, (Object)webImage.zzeux) && this.zzakp == webImage.zzakp && this.zzakq == webImage.zzakq;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzeux, this.zzakp, this.zzakq});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WebImage webImage = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)webImage.zzdxr);
        zzbcn.zza((Parcel)parcel2, (int)2, (Parcelable)webImage.getUrl(), (int)n, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)3, (int)webImage.getWidth());
        zzbcn.zzc((Parcel)parcel2, (int)4, (int)webImage.getHeight());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }
}

