/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.internal.zzbch;

public final class zzbcd
extends Drawable
implements Drawable.Callback {
    private int zzfrx = 0;
    private long zzdqs;
    private int mFrom;
    private int zzfry;
    private int zzfrz = 255;
    private int zzfsa;
    private int zzfsb = 0;
    private boolean zzfrs = true;
    private boolean zzfsc;
    private zzbch zzfsd;
    private Drawable zzfse;
    private Drawable zzfsf;
    private boolean zzfsg;
    private boolean zzfsh;
    private boolean zzfsi;
    private int zzfsj;

    public zzbcd(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zzbcf.zzajc();
        }
        this.zzfse = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzfsd.zzfsm |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zzbcf.zzajc();
        }
        this.zzfsf = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzfsd.zzfsm |= drawable3.getChangingConfigurations();
    }

    zzbcd(zzbch zzbch2) {
        this.zzfsd = new zzbch(zzbch2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzfsd.mChangingConfigurations | this.zzfsd.zzfsm;
    }

    public final void setAlpha(int n) {
        if (this.zzfsb == this.zzfrz) {
            this.zzfsb = n;
        }
        this.zzfrz = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzfse.setColorFilter(colorFilter);
        this.zzfsf.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zzfse.getIntrinsicWidth(), this.zzfsf.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zzfse.getIntrinsicHeight(), this.zzfsf.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zzfse.setBounds(rect);
        this.zzfsf.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzfsd.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzfsd;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zzfsi) {
            this.zzfsj = Drawable.resolveOpacity((int)this.zzfse.getOpacity(), (int)this.zzfsf.getOpacity());
            this.zzfsi = true;
        }
        return this.zzfsj;
    }

    private final boolean canConstantState() {
        if (!this.zzfsg) {
            this.zzfsh = this.zzfse.getConstantState() != null && this.zzfsf.getConstantState() != null;
            this.zzfsg = true;
        }
        return this.zzfsh;
    }

    public final Drawable mutate() {
        if (!this.zzfsc && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzfse.mutate();
            this.zzfsf.mutate();
            this.zzfsc = true;
        }
        return this;
    }

    public final Drawable zzajb() {
        return this.zzfsf;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zzfry = this.zzfrz;
        this.zzfsb = 0;
        this.zzfsa = 250;
        this.zzfrx = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzfrx) {
            case 1: {
                this.zzdqs = SystemClock.uptimeMillis();
                bl = false;
                this.zzfrx = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zzdqs < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zzdqs) / (float)this.zzfsa;
                bl = f >= 1.0f;
                if (bl) {
                    this.zzfrx = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.zzfsb = (int)(0.0f + (float)this.zzfry * f2);
            }
        }
        int n = this.zzfsb;
        boolean bl2 = this.zzfrs;
        Drawable drawable2 = this.zzfse;
        Drawable drawable3 = this.zzfsf;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzfrz) {
                drawable3.setAlpha(this.zzfrz);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zzfrz - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zzfrz);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzfrz);
        }
        this.invalidateSelf();
    }
}

