/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.internal.zzbch;

public final class zzbcd
extends Drawable
implements Drawable.Callback {
    private int zzfry = 0;
    private long zzdqt;
    private int mFrom;
    private int zzfrz;
    private int zzfsa = 255;
    private int zzfsb;
    private int zzfsc = 0;
    private boolean zzfrt = true;
    private boolean zzfsd;
    private zzbch zzfse;
    private Drawable zzfsf;
    private Drawable zzfsg;
    private boolean zzfsh;
    private boolean zzfsi;
    private boolean zzfsj;
    private int zzfsk;

    public zzbcd(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zzbcf.zzajb();
        }
        this.zzfsf = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzfse.zzfsn |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zzbcf.zzajb();
        }
        this.zzfsg = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzfse.zzfsn |= drawable3.getChangingConfigurations();
    }

    zzbcd(zzbch zzbch2) {
        this.zzfse = new zzbch(zzbch2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzfse.mChangingConfigurations | this.zzfse.zzfsn;
    }

    public final void setAlpha(int n) {
        if (this.zzfsc == this.zzfsa) {
            this.zzfsc = n;
        }
        this.zzfsa = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzfsf.setColorFilter(colorFilter);
        this.zzfsg.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zzfsf.getIntrinsicWidth(), this.zzfsg.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zzfsf.getIntrinsicHeight(), this.zzfsg.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zzfsf.setBounds(rect);
        this.zzfsg.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzfse.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzfse;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zzfsj) {
            this.zzfsk = Drawable.resolveOpacity((int)this.zzfsf.getOpacity(), (int)this.zzfsg.getOpacity());
            this.zzfsj = true;
        }
        return this.zzfsk;
    }

    private final boolean canConstantState() {
        if (!this.zzfsh) {
            this.zzfsi = this.zzfsf.getConstantState() != null && this.zzfsg.getConstantState() != null;
            this.zzfsh = true;
        }
        return this.zzfsi;
    }

    public final Drawable mutate() {
        if (!this.zzfsd && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzfsf.mutate();
            this.zzfsg.mutate();
            this.zzfsd = true;
        }
        return this;
    }

    public final Drawable zzaja() {
        return this.zzfsg;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zzfrz = this.zzfsa;
        this.zzfsc = 0;
        this.zzfsb = 250;
        this.zzfry = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzfry) {
            case 1: {
                this.zzdqt = SystemClock.uptimeMillis();
                bl = false;
                this.zzfry = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zzdqt < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zzdqt) / (float)this.zzfsb;
                bl = f >= 1.0f;
                if (bl) {
                    this.zzfry = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.zzfsc = (int)(0.0f + (float)this.zzfrz * f2);
            }
        }
        int n = this.zzfsc;
        boolean bl2 = this.zzfrt;
        Drawable drawable2 = this.zzfsf;
        Drawable drawable3 = this.zzfsg;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzfsa) {
                drawable3.setAlpha(this.zzfsa);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zzfsa - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zzfsa);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzfsa);
        }
        this.invalidateSelf();
    }
}

