/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zze;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
extends zzbej {
    public static final Parcelable.Creator<WebImage> CREATOR = new zze();
    private int zzdzm;
    private final Uri zzexv;
    private final int zzakw;
    private final int zzakx;

    WebImage(int n, Uri uri, int n2, int n3) {
        this.zzdzm = n;
        this.zzexv = uri;
        this.zzakw = n2;
        this.zzakx = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zzy(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    private static Uri zzy(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {}
        }
        return uri;
    }

    public final Uri getUrl() {
        return this.zzexv;
    }

    public final int getWidth() {
        return this.zzakw;
    }

    public final int getHeight() {
        return this.zzakx;
    }

    public final String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zzakw, this.zzakx, this.zzexv.toString());
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zzexv.toString());
            jSONObject.put("width", this.zzakw);
            jSONObject.put("height", this.zzakx);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return zzbg.equal((Object)this.zzexv, (Object)webImage.zzexv) && this.zzakw == webImage.zzakw && this.zzakx == webImage.zzakx;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzexv, this.zzakw, this.zzakx});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WebImage webImage = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)1, (int)webImage.zzdzm);
        zzbem.zza((Parcel)parcel2, (int)2, (Parcelable)webImage.getUrl(), (int)n, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)3, (int)webImage.getWidth());
        zzbem.zzc((Parcel)parcel2, (int)4, (int)webImage.getHeight());
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }
}

