/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzbee;
import com.google.android.gms.internal.zzbeg;

public final class zzbec
extends Drawable
implements Drawable.Callback {
    private int zzfve = 0;
    private long zzdss;
    private int mFrom;
    private int zzfvf;
    private int zzfvg = 255;
    private int zzfvh;
    private int mAlpha = 0;
    private boolean zzfuz = true;
    private boolean zzfvi;
    private zzbeg zzfvj;
    private Drawable zzfvk;
    private Drawable zzfvl;
    private boolean zzfvm;
    private boolean zzfvn;
    private boolean zzfvo;
    private int zzfvp;

    public zzbec(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zzbee.zzaju();
        }
        this.zzfvk = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzfvj.zzfvs |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zzbee.zzaju();
        }
        this.zzfvl = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzfvj.zzfvs |= drawable3.getChangingConfigurations();
    }

    zzbec(zzbeg zzbeg2) {
        this.zzfvj = new zzbeg(zzbeg2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzfvj.mChangingConfigurations | this.zzfvj.zzfvs;
    }

    public final void setAlpha(int n) {
        if (this.mAlpha == this.zzfvg) {
            this.mAlpha = n;
        }
        this.zzfvg = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzfvk.setColorFilter(colorFilter);
        this.zzfvl.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zzfvk.getIntrinsicWidth(), this.zzfvl.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zzfvk.getIntrinsicHeight(), this.zzfvl.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zzfvk.setBounds(rect);
        this.zzfvl.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzfvj.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzfvj;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zzfvo) {
            this.zzfvp = Drawable.resolveOpacity((int)this.zzfvk.getOpacity(), (int)this.zzfvl.getOpacity());
            this.zzfvo = true;
        }
        return this.zzfvp;
    }

    private final boolean canConstantState() {
        if (!this.zzfvm) {
            this.zzfvn = this.zzfvk.getConstantState() != null && this.zzfvl.getConstantState() != null;
            this.zzfvm = true;
        }
        return this.zzfvn;
    }

    public final Drawable mutate() {
        if (!this.zzfvi && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzfvk.mutate();
            this.zzfvl.mutate();
            this.zzfvi = true;
        }
        return this;
    }

    public final Drawable zzajt() {
        return this.zzfvl;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zzfvf = this.zzfvg;
        this.mAlpha = 0;
        this.zzfvh = 250;
        this.zzfve = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzfve) {
            case 1: {
                this.zzdss = SystemClock.uptimeMillis();
                bl = false;
                this.zzfve = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zzdss < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zzdss) / (float)this.zzfvh;
                bl = f >= 1.0f;
                if (bl) {
                    this.zzfve = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.mAlpha = (int)(0.0f + (float)this.zzfvf * f2);
            }
        }
        int n = this.mAlpha;
        boolean bl2 = this.zzfuz;
        Drawable drawable2 = this.zzfvk;
        Drawable drawable3 = this.zzfvl;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzfvg) {
                drawable3.setAlpha(this.zzfvg);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zzfvg - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zzfvg);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzfvg);
        }
        this.invalidateSelf();
    }
}

