/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.zza;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInAccount
extends zzbej
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zzb();
    private static zzd zzeds = zzh.zzalu();
    private int versionCode;
    private String zzbte;
    private String zzect;
    private String zzedt;
    private String zzedu;
    private Uri zzedv;
    private String zzedw;
    private long zzedx;
    private String zzedy;
    private List<Scope> zzdzr;
    private String zzecc;
    private String zzecd;

    @Nullable
    public static GoogleSignInAccount zzen(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        Uri uri = null;
        String string3 = jSONObject.optString("photoUrl", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            uri = Uri.parse((String)string3);
        }
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        HashSet<Scope> hashSet2 = hashSet;
        String string4 = jSONObject.getString("obfuscatedIdentifier");
        Long l2 = l;
        Uri uri2 = uri;
        String string5 = jSONObject.optString("familyName", null);
        String string6 = jSONObject.optString("givenName", null);
        String string7 = jSONObject.optString("displayName", null);
        String string8 = jSONObject.optString("email", null);
        String string9 = jSONObject.optString("tokenId", null);
        Object object = jSONObject.optString("id");
        if (l2 == null) {
            l2 = zzeds.currentTimeMillis() / 1000L;
        }
        GoogleSignInAccount googleSignInAccount = new GoogleSignInAccount(3, (String)object, string9, string8, string7, uri2, null, l2, zzbq.zzgh((String)string4), (List<Scope>)new ArrayList<Scope>((Collection)zzbq.checkNotNull(hashSet2)), string6, string5);
        string9 = jSONObject.optString("serverAuthCode", null);
        object = googleSignInAccount;
        googleSignInAccount.zzedw = string9;
        return object;
    }

    GoogleSignInAccount(int n, String string2, String string3, String string4, String string5, Uri uri, String string6, long l, String string7, List<Scope> list, String string8, String string9) {
        this.versionCode = n;
        this.zzbte = string2;
        this.zzect = string3;
        this.zzedt = string4;
        this.zzedu = string5;
        this.zzedv = uri;
        this.zzedw = string6;
        this.zzedx = l;
        this.zzedy = string7;
        this.zzdzr = list;
        this.zzecc = string8;
        this.zzecd = string9;
    }

    @Nullable
    public String getId() {
        return this.zzbte;
    }

    @Nullable
    public String getIdToken() {
        return this.zzect;
    }

    @Nullable
    public String getEmail() {
        return this.zzedt;
    }

    @Nullable
    public Account getAccount() {
        if (this.zzedt == null) {
            return null;
        }
        return new Account(this.zzedt, "com.google");
    }

    @Nullable
    public String getDisplayName() {
        return this.zzedu;
    }

    @Nullable
    public String getGivenName() {
        return this.zzecc;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzecd;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.zzedv;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.zzedw;
    }

    public final boolean zzaan() {
        return zzeds.currentTimeMillis() / 1000L >= this.zzedx - 300L;
    }

    @NonNull
    public final String zzaao() {
        return this.zzedy;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.zzdzr);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInAccount googleSignInAccount = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)1, (int)googleSignInAccount.versionCode);
        zzbem.zza((Parcel)parcel2, (int)2, (String)googleSignInAccount.getId(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (String)googleSignInAccount.getIdToken(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (String)googleSignInAccount.getEmail(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (String)googleSignInAccount.getDisplayName(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, (Parcelable)googleSignInAccount.getPhotoUrl(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (String)googleSignInAccount.getServerAuthCode(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (long)googleSignInAccount.zzedx);
        zzbem.zza((Parcel)parcel2, (int)9, (String)googleSignInAccount.zzedy, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)10, googleSignInAccount.zzdzr, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)11, (String)googleSignInAccount.getGivenName(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)12, (String)googleSignInAccount.getFamilyName(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return (527 + this.zzedy.hashCode()) * 31 + this.zzdzr.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GoogleSignInAccount)) {
            return false;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)((Object)object);
        return googleSignInAccount.zzedy.equals(this.zzedy) && googleSignInAccount.getGrantedScopes().equals(this.getGrantedScopes());
    }

    public final String zzaap() {
        JSONObject jSONObject = this.toJsonObject();
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }

    private final JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.getId() != null) {
                jSONObject.put("id", (Object)this.getId());
            }
            if (this.getIdToken() != null) {
                jSONObject.put("tokenId", (Object)this.getIdToken());
            }
            if (this.getEmail() != null) {
                jSONObject.put("email", (Object)this.getEmail());
            }
            if (this.getDisplayName() != null) {
                jSONObject.put("displayName", (Object)this.getDisplayName());
            }
            if (this.getGivenName() != null) {
                jSONObject.put("givenName", (Object)this.getGivenName());
            }
            if (this.getFamilyName() != null) {
                jSONObject.put("familyName", (Object)this.getFamilyName());
            }
            if (this.getPhotoUrl() != null) {
                jSONObject.put("photoUrl", (Object)this.getPhotoUrl().toString());
            }
            if (this.getServerAuthCode() != null) {
                jSONObject.put("serverAuthCode", (Object)this.getServerAuthCode());
            }
            jSONObject.put("expirationTime", this.zzedx);
            jSONObject.put("obfuscatedIdentifier", (Object)this.zzedy);
            JSONArray jSONArray = new JSONArray();
            Scope[] scopeArray = this.zzdzr.toArray(new Scope[this.zzdzr.size()]);
            Arrays.sort(scopeArray, zza.zzedz);
            Scope[] scopeArray2 = scopeArray;
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                Scope scope = scopeArray2[i];
                jSONArray.put((Object)scope.zzagj());
            }
            jSONObject.put("grantedScopes", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    static final /* synthetic */ int zza(Scope scope, Scope scope2) {
        return scope.zzagj().compareTo(scope2.zzagj());
    }
}

