/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.DeadObjectException;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzbz;

@VisibleForTesting
public abstract class zzm<R extends Result, A extends Api.zzb>
extends BasePendingResult<R>
implements zzn<R> {
    private final Api.zzc<A> zzfok;
    private final Api<?> zzfin;

    @Deprecated
    protected zzm(@NonNull Api.zzc<A> zzc2, @NonNull GoogleApiClient googleApiClient) {
        super((GoogleApiClient)zzbq.checkNotNull((Object)googleApiClient, (Object)"GoogleApiClient must not be null"));
        this.zzfok = (Api.zzc)zzbq.checkNotNull(zzc2);
        this.zzfin = null;
    }

    protected zzm(@NonNull Api<?> api, @NonNull GoogleApiClient googleApiClient) {
        super((GoogleApiClient)zzbq.checkNotNull((Object)googleApiClient, (Object)"GoogleApiClient must not be null"));
        zzbq.checkNotNull(api, (Object)"Api must not be null");
        this.zzfok = api.zzagf();
        this.zzfin = api;
    }

    public final Api.zzc<A> zzagf() {
        return this.zzfok;
    }

    public final Api<?> zzagl() {
        return this.zzfin;
    }

    public final void zzb(@NonNull A object) throws DeadObjectException {
        if (object instanceof zzbz) {
            object = zzbz.zzals();
        }
        try {
            this.zza(object);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.zzc((RemoteException)((Object)deadObjectException));
            throw deadObjectException;
        }
        catch (RemoteException remoteException) {
            this.zzc(remoteException);
            return;
        }
    }

    @Override
    public final void zzu(@NonNull Status status) {
        zzbq.checkArgument((!status.isSuccess() ? 1 : 0) != 0, (Object)"Failed result must not be success");
        Object r = this.zzb(status);
        ((BasePendingResult)this).setResult(r);
    }

    protected abstract void zza(@NonNull A var1) throws RemoteException;

    private final void zzc(@NonNull RemoteException remoteException) {
        Status status = new Status(8, remoteException.getLocalizedMessage(), null);
        this.zzu(status);
    }
}

