/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.api.internal.zzq;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzo
extends LifecycleCallback
implements DialogInterface.OnCancelListener {
    protected volatile boolean zza;
    protected final AtomicReference<zzp> zzb = new AtomicReference<Object>(null);
    private final Handler zze = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability zzc;

    protected zzo(zzcf zzcf2) {
        this(zzcf2, GoogleApiAvailability.getInstance());
    }

    private zzo(zzcf zzcf2, GoogleApiAvailability googleApiAvailability) {
        super(zzcf2);
        this.zzc = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), zzo.zza(this.zzb.get()));
        this.zzd();
    }

    public final void zza(Bundle bundle) {
        super.zza(bundle);
        if (bundle != null) {
            zzp zzp2;
            Bundle bundle2 = bundle;
            if (bundle2.getBoolean("resolving_error", false)) {
                ConnectionResult connectionResult = new ConnectionResult(bundle2.getInt("failed_status"), (PendingIntent)bundle2.getParcelable("failed_resolution"));
                int n = bundle2.getInt("failed_client_id", -1);
                zzp2 = new zzp(connectionResult, n);
            } else {
                zzp2 = null;
            }
            this.zzb.set(zzp2);
        }
    }

    public final void zzb(Bundle bundle) {
        super.zzb(bundle);
        Bundle bundle2 = bundle;
        zzp zzp2 = this.zzb.get();
        if (zzp2 != null) {
            bundle2.putBoolean("resolving_error", true);
            bundle2.putInt("failed_client_id", zzp2.zza());
            bundle2.putInt("failed_status", zzp2.zzb().getErrorCode());
            bundle2.putParcelable("failed_resolution", (Parcelable)zzp2.zzb().getResolution());
        }
    }

    public void zza() {
        super.zza();
        this.zza = true;
    }

    public final void zza(int n, int n2, Intent intent) {
        boolean bl = false;
        zzp zzp2 = this.zzb.get();
        switch (n) {
            case 2: {
                int n3 = this.zzc.isGooglePlayServicesAvailable((Context)this.zzg());
                if (n3 == 0) {
                    bl = true;
                }
                if (zzp2 == null) {
                    return;
                }
                if (zzp2.zzb().getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                zzp2 = new zzp(new ConnectionResult(n4, null), zzo.zza(zzp2));
                this.zzb.set(zzp2);
            }
        }
        if (bl) {
            this.zzd();
            return;
        }
        if (zzp2 != null) {
            this.zza(zzp2.zzb(), zzp2.zza());
        }
    }

    public void zzb() {
        super.zzb();
        this.zza = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzc();

    protected final void zzd() {
        this.zzb.set(null);
        this.zzc();
    }

    public final void zzb(ConnectionResult connectionResult, int n) {
        zzp zzp2 = new zzp(connectionResult, n);
        if (this.zzb.compareAndSet(null, zzp2)) {
            this.zze.post((Runnable)new zzq(this, zzp2));
        }
    }

    private static int zza(@Nullable zzp zzp2) {
        if (zzp2 == null) {
            return -1;
        }
        return zzp2.zza();
    }
}

