/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzcs;
import com.google.android.gms.common.api.internal.zzdi;
import com.google.android.gms.common.api.internal.zzdj;
import com.google.android.gms.common.internal.zzbq;
import java.lang.ref.WeakReference;

public final class zzdh<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzgbh = null;
    private zzdh<? extends Result> zzgbi = null;
    private volatile ResultCallbacks<? super R> zzgbj = null;
    private PendingResult<R> zzgbk = null;
    private final Object zzfvc = new Object();
    private Status zzgbl = null;
    private final WeakReference<GoogleApiClient> zzfve;
    private final zzdj zzgbm;
    private boolean zzgbn = false;

    public zzdh(WeakReference<GoogleApiClient> weakReference) {
        zzbq.checkNotNull(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzfve = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfve.get();
        this.zzgbm = new zzdj(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzfvc;
        synchronized (object) {
            zzbq.zza((this.zzgbh == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbq.zza((this.zzgbj == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzgbh = resultTransform;
            zzdh<R> zzdh2 = new zzdh<R>(this.zzfve);
            this.zzgbi = zzdh2;
            this.zzala();
            return zzdh2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzfvc;
        synchronized (object) {
            zzbq.zza((this.zzgbj == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzbq.zza((this.zzgbh == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzgbj = resultCallbacks;
            this.zzala();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zzfvc;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzgbh != null) {
                    zzcs.zzajx().submit(new zzdi(this, (Result)r));
                } else if (this.zzalc()) {
                    this.zzgbj.onSuccess(r);
                }
            } else {
                this.zzd(r.getStatus());
                zzdh.zzd(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(PendingResult<?> pendingResult) {
        Object object = this.zzfvc;
        synchronized (object) {
            this.zzgbk = pendingResult;
            this.zzala();
            return;
        }
    }

    private final void zzala() {
        if (this.zzgbh == null && this.zzgbj == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfve.get();
        if (!this.zzgbn && this.zzgbh != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzgbn = true;
        }
        if (this.zzgbl != null) {
            this.zzx(this.zzgbl);
            return;
        }
        if (this.zzgbk != null) {
            this.zzgbk.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzd(Status status) {
        Object object = this.zzfvc;
        synchronized (object) {
            this.zzgbl = status;
            this.zzx(this.zzgbl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzx(Status status) {
        Object object = this.zzfvc;
        synchronized (object) {
            if (this.zzgbh != null) {
                Status status2 = this.zzgbh.onFailure(status);
                zzbq.checkNotNull((Object)status2, (Object)"onFailure must not return null");
                super.zzd(status2);
            } else if (this.zzalc()) {
                this.zzgbj.onFailure(status);
            }
            return;
        }
    }

    final void zzalb() {
        this.zzgbj = null;
    }

    private final boolean zzalc() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfve.get();
        return this.zzgbj != null && googleApiClient != null;
    }

    private static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zzc(zzdh zzdh2) {
        return zzdh2.zzgbh;
    }

    static /* synthetic */ zzdj zzd(zzdh zzdh2) {
        return zzdh2.zzgbm;
    }

    static /* synthetic */ void zza(zzdh zzdh2, Result result) {
        zzdh.zzd(result);
    }

    static /* synthetic */ WeakReference zze(zzdh zzdh2) {
        return zzdh2.zzfve;
    }

    static /* synthetic */ Object zzf(zzdh zzdh2) {
        return zzdh2.zzfvc;
    }

    static /* synthetic */ zzdh zzg(zzdh zzdh2) {
        return zzdh2.zzgbi;
    }

    static /* synthetic */ void zza(zzdh zzdh2, Status status) {
        zzdh2.zzd(status);
    }
}

