/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzba;
import com.google.android.gms.common.api.internal.zzbi;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.api.internal.zzy;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.internal.zzcyk;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzv
implements zzcc {
    private final Context mContext;
    private final zzba zzfvq;
    private final Looper zzalj;
    private final zzbi zzfvr;
    private final zzbi zzfvs;
    private final Map<Api.zzc<?>, zzbi> zzfvt;
    private final Set<zzcu> zzfvu = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzfvv;
    private Bundle zzfvw;
    private ConnectionResult zzfvx = null;
    private ConnectionResult zzfvy = null;
    private boolean zzfvz = false;
    private final Lock zzfwa;
    private int zzfwb = 0;

    public static zzv zza(Context context, zzba zzba2, Lock lock, Looper looper, zzf zzf2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcyj, zzcyk> zza2, ArrayList<zzt> arrayList) {
        Object object;
        Api.zze zze2 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzacn()) {
                zze2 = object;
            }
            if (object.zzacc()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzbq.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc2 = api.zzahm();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzt>();
        ArrayList<zzt> arrayList2 = new ArrayList<zzt>();
        ArrayList<zzt> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zzt zzt2 = arrayList3.get(i);
            zzt zzt3 = zzt2;
            if (arrayMap5.containsKey(zzt3.zzfop)) {
                ((ArrayList)object).add(zzt3);
                continue;
            }
            if (arrayMap.containsKey(zzt3.zzfop)) {
                arrayList2.add(zzt3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzv(context, zzba2, lock, looper, zzf2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzr2, zza2, zze2, (ArrayList<zzt>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzv(Context context, zzba zzba2, Lock lock, Looper looper, zzf zzf2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzr zzr2, Api.zza<? extends zzcyj, zzcyk> zza2, Api.zze zze2, ArrayList<zzt> arrayList, ArrayList<zzt> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzfvq = zzba2;
        this.zzfwa = lock;
        this.zzalj = looper;
        this.zzfvv = zze2;
        this.zzfvr = new zzbi(context, this.zzfvq, lock, looper, zzf2, map2, null, map4, null, arrayList2, new zzx(this, null));
        this.zzfvs = new zzbi(context, this.zzfvq, lock, looper, zzf2, map, zzr2, map3, zza2, arrayList, new zzy(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc2 : map2.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfvr);
        }
        for (Api.zzc<?> zzc2 : map.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfvs);
        }
        this.zzfvt = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzaiv()) {
                t.zzu(new Status(4, null, this.zzaiw()));
                return t;
            }
            return this.zzfvs.zzd(t);
        }
        return this.zzfvr.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzaiv()) {
                t.zzu(new Status(4, null, this.zzaiw()));
                return t;
            }
            return this.zzfvs.zze(t);
        }
        return this.zzfvr.zze(t);
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzfvt.get(api.zzahm()).equals(this.zzfvs)) {
            if (this.zzaiv()) {
                return new ConnectionResult(4, this.zzaiw());
            }
            return this.zzfvs.getConnectionResult(api);
        }
        return this.zzfvr.getConnectionResult(api);
    }

    @Override
    public final void connect() {
        this.zzfwb = 2;
        this.zzfvz = false;
        zzv zzv2 = this;
        this.zzfvy = null;
        zzv2.zzfvx = null;
        zzv2.zzfvr.connect();
        zzv2.zzfvs.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void disconnect() {
        this.zzfvy = null;
        this.zzfvx = null;
        this.zzfwb = 0;
        this.zzfvr.disconnect();
        this.zzfvs.disconnect();
        this.zzaiu();
    }

    @Override
    public final boolean isConnected() {
        this.zzfwa.lock();
        try {
            boolean bl = this.zzfvr.isConnected() && (this.zzfvs.isConnected() || this.zzaiv() || this.zzfwb == 1);
            return bl;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfwa.lock();
        try {
            boolean bl = this.zzfwb == 2;
            return bl;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final boolean zza(zzcu zzcu2) {
        this.zzfwa.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzfvs.isConnected()) {
                this.zzfvu.add(zzcu2);
                if (this.zzfwb == 0) {
                    this.zzfwb = 1;
                }
                this.zzfvy = null;
                this.zzfvs.connect();
                return true;
            }
        }
        finally {
            this.zzfwa.unlock();
        }
        return false;
    }

    @Override
    public final void zzais() {
        this.zzfvr.zzais();
        this.zzfvs.zzais();
    }

    @Override
    public final void zzaia() {
        this.zzfwa.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzfvs.disconnect();
            this.zzfvy = new ConnectionResult(4);
            if (bl) {
                new Handler(this.zzalj).post((Runnable)new zzw(this));
            } else {
                this.zzaiu();
            }
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    private final void zzait() {
        if (zzv.zzb(this.zzfvx)) {
            if (zzv.zzb(this.zzfvy) || this.zzaiv()) {
                zzv zzv2 = this;
                switch (zzv2.zzfwb) {
                    case 2: {
                        zzv2.zzfvq.zzk(zzv2.zzfvw);
                    }
                    case 1: {
                        zzv2.zzaiu();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zzv2.zzfwb = 0;
                return;
            }
            if (this.zzfvy != null) {
                if (this.zzfwb == 1) {
                    this.zzaiu();
                    return;
                }
                this.zza(this.zzfvy);
                this.zzfvr.disconnect();
                return;
            }
        } else {
            if (this.zzfvx != null && zzv.zzb(this.zzfvy)) {
                this.zzfvs.disconnect();
                this.zza(this.zzfvx);
                return;
            }
            if (this.zzfvx != null && this.zzfvy != null) {
                ConnectionResult connectionResult = this.zzfvx;
                if (this.zzfvs.zzfzb < this.zzfvr.zzfzb) {
                    connectionResult = this.zzfvy;
                }
                this.zza(connectionResult);
            }
        }
    }

    private final void zza(ConnectionResult connectionResult) {
        switch (this.zzfwb) {
            case 2: {
                this.zzfvq.zzc(connectionResult);
            }
            case 1: {
                this.zzaiu();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzfwb = 0;
    }

    private final void zzaiu() {
        Iterator<zzcu> iterator = this.zzfvu.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzacm();
        }
        this.zzfvu.clear();
    }

    private final void zze(int n, boolean bl) {
        this.zzfvq.zzf(n, bl);
        this.zzfvy = null;
        this.zzfvx = null;
    }

    private final boolean zzaiv() {
        return this.zzfvy != null && this.zzfvy.getErrorCode() == 4;
    }

    private final boolean zzf(zzm<? extends Result, ? extends Api.zzb> zzm2) {
        Api.zzc<? extends Api.zzb> zzc2 = zzm2.zzahm();
        zzbq.checkArgument((boolean)this.zzfvt.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzfvt.get(zzc2).equals(this.zzfvs);
    }

    @Nullable
    private final PendingIntent zzaiw() {
        if (this.zzfvv == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zzfvq), (Intent)this.zzfvv.getSignInIntent(), (int)0x8000000);
    }

    private final void zzj(Bundle bundle) {
        if (this.zzfvw == null) {
            this.zzfvw = bundle;
            return;
        }
        if (bundle != null) {
            this.zzfvw.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzfvs.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzfvr.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zza(zzv zzv2) {
        return zzv2.zzfwa;
    }

    static /* synthetic */ void zzb(zzv zzv2) {
        zzv2.zzait();
    }

    static /* synthetic */ void zza(zzv zzv2, Bundle bundle) {
        zzv2.zzj(bundle);
    }

    static /* synthetic */ ConnectionResult zza(zzv zzv2, ConnectionResult connectionResult) {
        zzv2.zzfvx = connectionResult;
        return zzv2.zzfvx;
    }

    static /* synthetic */ boolean zzc(zzv zzv2) {
        return zzv2.zzfvz;
    }

    static /* synthetic */ ConnectionResult zzd(zzv zzv2) {
        return zzv2.zzfvy;
    }

    static /* synthetic */ boolean zza(zzv zzv2, boolean bl) {
        zzv2.zzfvz = bl;
        return zzv2.zzfvz;
    }

    static /* synthetic */ void zza(zzv zzv2, int n, boolean bl) {
        zzv2.zze(n, bl);
    }

    static /* synthetic */ zzbi zze(zzv zzv2) {
        return zzv2.zzfvs;
    }

    static /* synthetic */ ConnectionResult zzb(zzv zzv2, ConnectionResult connectionResult) {
        zzv2.zzfvy = connectionResult;
        return zzv2.zzfvy;
    }

    static /* synthetic */ zzbi zzf(zzv zzv2) {
        return zzv2.zzfvr;
    }
}

