/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;

public class Storage {
    private static final Lock zzaf = new ReentrantLock();
    @GuardedBy(value="sLk")
    private static Storage zzag;
    private final Lock zzah = new ReentrantLock();
    @GuardedBy(value="mLk")
    private final SharedPreferences zzai;

    @VisibleForTesting
    public static void setInstance(@Nullable Storage storage) {
        zzaf.lock();
        try {
            zzag = storage;
            return;
        }
        finally {
            zzaf.unlock();
        }
    }

    public static Storage getInstance(Context context) {
        Preconditions.checkNotNull((Object)context);
        zzaf.lock();
        try {
            if (zzag == null) {
                zzag = new Storage(context.getApplicationContext());
            }
            Storage storage = zzag;
            return storage;
        }
        finally {
            zzaf.unlock();
        }
    }

    @VisibleForTesting
    private Storage(Context context) {
        this.zzai = context.getSharedPreferences("com.google.android.gms.signin", 0);
    }

    public void saveDefaultGoogleSignInAccount(GoogleSignInAccount googleSignInAccount, GoogleSignInOptions googleSignInOptions) {
        Preconditions.checkNotNull((Object)((Object)googleSignInAccount));
        Preconditions.checkNotNull((Object)googleSignInOptions);
        this.saveToStore("defaultGoogleSignInAccount", googleSignInAccount.getObfuscatedIdentifier());
        GoogleSignInOptions googleSignInOptions2 = googleSignInOptions;
        GoogleSignInAccount googleSignInAccount2 = googleSignInAccount;
        Storage storage = this;
        Preconditions.checkNotNull((Object)((Object)googleSignInAccount2));
        Preconditions.checkNotNull((Object)googleSignInOptions2);
        String string = googleSignInAccount2.getObfuscatedIdentifier();
        storage.saveToStore(Storage.zza("googleSignInAccount", string), googleSignInAccount2.toJsonForStorage());
        storage.saveToStore(Storage.zza("googleSignInOptions", string), googleSignInOptions2.toJson());
    }

    public void saveRefreshToken(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.saveToStore("refreshToken", string);
        }
    }

    protected void saveToStore(String string, String string2) {
        this.zzah.lock();
        try {
            this.zzai.edit().putString(string, string2).apply();
            return;
        }
        finally {
            this.zzah.unlock();
        }
    }

    @Nullable
    public GoogleSignInAccount getSavedDefaultGoogleSignInAccount() {
        String string = this.getFromStore("defaultGoogleSignInAccount");
        return this.zzb(string);
    }

    @Nullable
    @VisibleForTesting
    private final GoogleSignInAccount zzb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = this.getFromStore(Storage.zza("googleSignInAccount", string));
        try {
            if (string2 != null) {
                return GoogleSignInAccount.fromJsonString(string2);
            }
            return null;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Nullable
    public GoogleSignInOptions getSavedDefaultGoogleSignInOptions() {
        String string = this.getFromStore("defaultGoogleSignInAccount");
        return this.zzc(string);
    }

    @Nullable
    @VisibleForTesting
    private final GoogleSignInOptions zzc(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = this.getFromStore(Storage.zza("googleSignInOptions", string));
        try {
            if (string2 != null) {
                return GoogleSignInOptions.fromJsonString(string2);
            }
            return null;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Nullable
    public String getSavedRefreshToken() {
        return this.getFromStore("refreshToken");
    }

    @Nullable
    protected String getFromStore(String string) {
        this.zzah.lock();
        try {
            String string2 = this.zzai.getString(string, null);
            return string2;
        }
        finally {
            this.zzah.unlock();
        }
    }

    public void removeSavedDefaultGoogleSignInAccount() {
        String string = this.getFromStore("defaultGoogleSignInAccount");
        this.removeFromStore("defaultGoogleSignInAccount");
        String string2 = string;
        Storage storage = this;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            storage.removeFromStore(Storage.zza("googleSignInAccount", string2));
            storage.removeFromStore(Storage.zza("googleSignInOptions", string2));
        }
    }

    protected void removeFromStore(String string) {
        this.zzah.lock();
        try {
            this.zzai.edit().remove(string).apply();
            return;
        }
        finally {
            this.zzah.unlock();
        }
    }

    public void clear() {
        this.zzah.lock();
        try {
            this.zzai.edit().clear().apply();
            return;
        }
        finally {
            this.zzah.unlock();
        }
    }

    private static String zza(String string, String string2) {
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString();
    }
}

