/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzch;
import com.google.android.gms.common.api.internal.zzcn;
import com.google.android.gms.common.api.internal.zzo;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@KeepName
@KeepForSdk
public abstract class BasePendingResult<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzez = new zzo();
    private final Object zzfa = new Object();
    private final CallbackHandler<R> zzfb;
    private final WeakReference<GoogleApiClient> zzfc;
    private final CountDownLatch zzfd = new CountDownLatch(1);
    private final ArrayList<PendingResult.StatusListener> zzfe = new ArrayList();
    private ResultCallback<? super R> zzff;
    private final AtomicReference<zzcn> zzfg = new AtomicReference();
    private R zzdm;
    private Status mStatus;
    @KeepName
    private zza mResultGuardian;
    private volatile boolean zzfh;
    private boolean zzfi;
    private boolean zzfj;
    private ICancelToken zzfk;
    private volatile zzch<R> zzfl;
    private boolean zzfm = false;

    @Deprecated
    BasePendingResult() {
        this.zzfb = new CallbackHandler(Looper.getMainLooper());
        this.zzfc = new WeakReference<Object>(null);
    }

    @KeepForSdk
    protected BasePendingResult(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzfb = new CallbackHandler(looper);
        this.zzfc = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    @KeepForSdk
    protected BasePendingResult(Looper looper) {
        this.zzfb = new CallbackHandler(looper);
        this.zzfc = new WeakReference<Object>(null);
    }

    @VisibleForTesting
    @KeepForSdk
    protected BasePendingResult(@NonNull CallbackHandler<R> callbackHandler) {
        this.zzfb = (CallbackHandler)((Object)Preconditions.checkNotNull(callbackHandler, (Object)"CallbackHandler must not be null"));
        this.zzfc = new WeakReference<Object>(null);
    }

    @KeepForSdk
    public final boolean isReady() {
        return this.zzfd.getCount() == 0L;
    }

    @Override
    public final R await() {
        Preconditions.checkNotMainThread((String)"await must not be called on the UI thread");
        Preconditions.checkState((!this.zzfh ? 1 : 0) != 0, (Object)"Result has already been consumed");
        Preconditions.checkState((this.zzfl == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzfd.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzb(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        if (l > 0L) {
            Preconditions.checkNotMainThread((String)"await must not be called on the UI thread when time is greater than zero.");
        }
        Preconditions.checkState((!this.zzfh ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Preconditions.checkState((this.zzfl == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zzfd.await(l, timeUnit)) {
                this.zzb(Status.RESULT_TIMEOUT);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzb(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzfa;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzff = null;
                return;
            }
            Preconditions.checkState((!this.zzfh ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((this.zzfl == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfb.zza(resultCallback, (R)this.get());
            } else {
                this.zzff = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzfa;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzff = null;
                return;
            }
            Preconditions.checkState((!this.zzfh ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((this.zzfl == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfb.zza(resultCallback, (R)this.get());
            } else {
                this.zzff = resultCallback;
                long l2 = timeUnit.toMillis(l);
                BasePendingResult basePendingResult = this;
                CallbackHandler<R> callbackHandler = this.zzfb;
                callbackHandler.sendMessageDelayed(callbackHandler.obtainMessage(2, basePendingResult), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStatusListener(PendingResult.StatusListener statusListener) {
        Preconditions.checkArgument((statusListener != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzfa;
        synchronized (object) {
            if (this.isReady()) {
                statusListener.onComplete(this.mStatus);
            } else {
                this.zzfe.add(statusListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public void cancel() {
        Object object = this.zzfa;
        synchronized (object) {
            if (this.zzfi || this.zzfh) {
                return;
            }
            if (this.zzfk != null) {
                try {
                    this.zzfk.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            BasePendingResult.zzb(this.zzdm);
            this.zzfi = true;
            this.zza(this.createFailedResult(Status.RESULT_CANCELED));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzw() {
        Object object = this.zzfa;
        synchronized (object) {
            if ((GoogleApiClient)this.zzfc.get() == null || !this.zzfm) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzfa;
        synchronized (object) {
            return this.zzfi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        Preconditions.checkState((!this.zzfh ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzfa;
        synchronized (object) {
            Preconditions.checkState((this.zzfl == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            Preconditions.checkState((this.zzff == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            Preconditions.checkState((!this.zzfi ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzfm = true;
            this.zzfl = new zzch(this.zzfc);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zzfl).then(resultTransform);
            if (this.isReady()) {
                this.zzfb.zza(this.zzfl, this.get());
            } else {
                this.zzff = this.zzfl;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void setResult(R r) {
        Object object = this.zzfa;
        synchronized (object) {
            if (!this.zzfj && !this.zzfi) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                BasePendingResult.zzb(r);
                return;
            }
            Preconditions.checkState((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            Preconditions.checkState((!this.zzfh ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zza(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Status status) {
        Object object = this.zzfa;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.createFailedResult(status));
                this.zzfj = true;
            }
            return;
        }
    }

    @NonNull
    @KeepForSdk
    protected abstract R createFailedResult(Status var1);

    public final void zza(zzcn zzcn2) {
        this.zzfg.set(zzcn2);
    }

    @Override
    public final Integer zzo() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    protected final void setCancelToken(ICancelToken iCancelToken) {
        Object object = this.zzfa;
        synchronized (object) {
            this.zzfk = iCancelToken;
            return;
        }
    }

    public final void zzx() {
        this.zzfm = this.zzfm || zzez.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zzfa;
        synchronized (object) {
            Preconditions.checkState((!this.zzfh ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzdm;
            this.zzdm = null;
            this.zzff = null;
            this.zzfh = true;
        }
        BasePendingResult basePendingResult = this;
        zzcn zzcn2 = basePendingResult.zzfg.getAndSet(null);
        if (zzcn2 != null) {
            zzcn2.zzc(basePendingResult);
        }
        return r;
    }

    private final void zza(R r) {
        this.zzdm = r;
        this.zzfk = null;
        this.zzfd.countDown();
        this.mStatus = this.zzdm.getStatus();
        if (this.zzfi) {
            this.zzff = null;
        } else if (this.zzff == null) {
            if (this.zzdm instanceof Releasable) {
                this.mResultGuardian = new zza(null);
            }
        } else {
            this.zzfb.removeMessages(2);
            this.zzfb.zza(this.zzff, (R)this.get());
        }
        ArrayList<PendingResult.StatusListener> arrayList = this.zzfe;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.StatusListener statusListener = arrayList.get(i);
            statusListener.onComplete(this.mStatus);
        }
        this.zzfe.clear();
    }

    public static void zzb(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zza {
        private zza() {
        }

        protected final void finalize() throws Throwable {
            BasePendingResult.zzb(BasePendingResult.this.zzdm);
            super.finalize();
        }

        /* synthetic */ zza(zzo zzo2) {
            this();
        }
    }

    @VisibleForTesting
    public static class CallbackHandler<R extends Result>
    extends Handler {
        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public final void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    Result result = (Result)pair.second;
                    ResultCallback resultCallback = (ResultCallback)pair.first;
                    try {
                        resultCallback.onResult(result);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        BasePendingResult.zzb(result);
                        throw runtimeException;
                    }
                }
                case 2: {
                    ((BasePendingResult)message.obj).zzb(Status.RESULT_TIMEOUT);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }
    }
}

