/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zzag;
import com.google.android.gms.common.api.internal.zzaj;
import com.google.android.gms.common.api.internal.zzau;
import com.google.android.gms.common.api.internal.zzav;
import com.google.android.gms.common.api.internal.zzbc;
import com.google.android.gms.common.api.internal.zzbe;
import com.google.android.gms.common.api.internal.zzbf;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbq;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.signin.SignInClient;
import com.google.android.gms.signin.SignInOptions;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zzbd
implements zzbp,
zzq {
    private final Lock zzga;
    private final Condition zziz;
    private final Context mContext;
    private final GoogleApiAvailabilityLight zzgk;
    private final zzbf zzja;
    final Map<Api.AnyClientKey<?>, Api.Client> zzil;
    final Map<Api.AnyClientKey<?>, ConnectionResult> zzjb = new HashMap();
    private final ClientSettings zzgf;
    private final Map<Api<?>, Boolean> zzgi;
    private final Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> zzdh;
    private volatile zzbc zzjc;
    private ConnectionResult zzjd = null;
    int zzje;
    final zzav zzfq;
    final zzbq zzjf;

    public zzbd(Context context, zzav zzav2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> abstractClientBuilder, ArrayList<zzp> arrayList, zzbq zzbq2) {
        this.mContext = context;
        this.zzga = lock;
        this.zzgk = googleApiAvailabilityLight;
        this.zzil = map;
        this.zzgf = clientSettings;
        this.zzgi = map2;
        this.zzdh = abstractClientBuilder;
        this.zzfq = zzav2;
        this.zzjf = zzbq2;
        ArrayList<zzp> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzp zzp2 = arrayList2.get(i);
            zzp2.zza(this);
        }
        this.zzja = new zzbf(this, looper);
        this.zziz = lock.newCondition();
        this.zzjc = new zzau(this);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        t.zzx();
        return this.zzjc.enqueue(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        t.zzx();
        return this.zzjc.execute(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void connect() {
        this.zzjc.connect();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zziz.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zzjd != null) {
            return this.zzjd;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zziz.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zzjd != null) {
            return this.zzjd;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void disconnect() {
        if (this.zzjc.disconnect()) {
            this.zzjb.clear();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.AnyClientKey<?> anyClientKey = api.getClientKey();
        if (this.zzil.containsKey(anyClientKey)) {
            if (this.zzil.get(anyClientKey).isConnected()) {
                return ConnectionResult.RESULT_SUCCESS;
            }
            if (this.zzjb.containsKey(anyClientKey)) {
                return this.zzjb.get(anyClientKey);
            }
        }
        return null;
    }

    final void zzbc() {
        this.zzga.lock();
        try {
            this.zzjc = new zzaj(this, this.zzgf, this.zzgi, this.zzgk, this.zzdh, this.zzga, this.mContext);
            this.zzjc.begin();
            this.zziz.signalAll();
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    final void zzbd() {
        this.zzga.lock();
        try {
            this.zzfq.zzaz();
            this.zzjc = new zzag(this);
            this.zzjc.begin();
            this.zziz.signalAll();
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    final void zzf(ConnectionResult connectionResult) {
        this.zzga.lock();
        try {
            this.zzjd = connectionResult;
            this.zzjc = new zzau(this);
            this.zzjc.begin();
            this.zziz.signalAll();
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zzjc instanceof zzag;
    }

    @Override
    public final boolean isConnecting() {
        return this.zzjc instanceof zzaj;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        return false;
    }

    @Override
    public final void maybeSignOut() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zzz() {
        if (this.isConnected()) {
            ((zzag)this.zzjc).zzap();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzga.lock();
        try {
            this.zzjc.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzga.lock();
        try {
            this.zzjc.onConnected(bundle);
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzga.lock();
        try {
            this.zzjc.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    final void zza(zzbe zzbe2) {
        Message message = this.zzja.obtainMessage(1, zzbe2);
        this.zzja.sendMessage(message);
    }

    final void zzb(RuntimeException runtimeException) {
        Message message = this.zzja.obtainMessage(2, runtimeException);
        this.zzja.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzjc);
        for (Api<?> api : this.zzgi.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zzil.get(api.getClientKey()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbd zzbd2) {
        return zzbd2.zzga;
    }

    static /* synthetic */ zzbc zzb(zzbd zzbd2) {
        return zzbd2.zzjc;
    }
}

