/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.FastSafeParcelableJsonResponse;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.SafeParcelResponseCreator;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.MapUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@VisibleForTesting
@SafeParcelable.Class(creator="SafeParcelResponseCreator")
public class SafeParcelResponse
extends FastSafeParcelableJsonResponse {
    @SafeParcelable.VersionField(id=1, getter="getVersionCode")
    private final int zzal;
    @SafeParcelable.Field(id=2, getter="getParcel")
    private final Parcel zzxq;
    private final int zzxr;
    @SafeParcelable.Field(id=3, getter="getFieldMappingDictionary")
    private final FieldMappingDictionary zzwn;
    private final String mClassName;
    private int zzxs;
    private int zzxt;
    public static final Parcelable.Creator<SafeParcelResponse> CREATOR = new SafeParcelResponseCreator();

    public SafeParcelResponse(FieldMappingDictionary fieldMappingDictionary) {
        this(fieldMappingDictionary, fieldMappingDictionary.getRootClassName());
    }

    public SafeParcelResponse(FieldMappingDictionary fieldMappingDictionary, String string2) {
        this.zzal = 1;
        this.zzxq = Parcel.obtain();
        this.zzxr = 0;
        this.zzwn = (FieldMappingDictionary)((Object)Preconditions.checkNotNull((Object)((Object)fieldMappingDictionary)));
        this.mClassName = (String)Preconditions.checkNotNull((Object)string2);
        this.zzxs = 0;
    }

    private SafeParcelResponse(SafeParcelable safeParcelable, FieldMappingDictionary fieldMappingDictionary, String string2) {
        this.zzal = 1;
        this.zzxq = Parcel.obtain();
        safeParcelable.writeToParcel(this.zzxq, 0);
        this.zzxr = 1;
        this.zzwn = (FieldMappingDictionary)((Object)Preconditions.checkNotNull((Object)((Object)fieldMappingDictionary)));
        this.mClassName = (String)Preconditions.checkNotNull((Object)string2);
        this.zzxs = 2;
    }

    public static <T extends FastJsonResponse> SafeParcelResponse from(T t) {
        String string2 = t.getClass().getCanonicalName();
        FieldMappingDictionary fieldMappingDictionary = SafeParcelResponse.zza(t);
        return new SafeParcelResponse((SafeParcelable)t, fieldMappingDictionary, string2);
    }

    private static FieldMappingDictionary zza(FastJsonResponse fastJsonResponse) {
        FieldMappingDictionary fieldMappingDictionary = new FieldMappingDictionary(fastJsonResponse.getClass());
        SafeParcelResponse.zza(fieldMappingDictionary, fastJsonResponse);
        fieldMappingDictionary.copyInternalFieldMappings();
        fieldMappingDictionary.linkFields();
        return fieldMappingDictionary;
    }

    private static void zza(FieldMappingDictionary fieldMappingDictionary, FastJsonResponse fastJsonResponse) {
        Class<?> clazz = fastJsonResponse.getClass();
        if (!fieldMappingDictionary.hasFieldMappingForClass(clazz)) {
            Map<String, FastJsonResponse.Field<?, ?>> map = fastJsonResponse.getFieldMappings();
            fieldMappingDictionary.put(clazz, map);
            for (String string2 : map.keySet()) {
                FastJsonResponse.Field<?, ?> field = map.get(string2);
                Class<FastJsonResponse> clazz2 = field.getConcreteType();
                if (clazz2 == null) continue;
                try {
                    FastJsonResponse fastJsonResponse2 = clazz2.newInstance();
                    SafeParcelResponse.zza(fieldMappingDictionary, fastJsonResponse2);
                }
                catch (InstantiationException instantiationException) {
                    String string3 = String.valueOf(field.getConcreteType().getCanonicalName());
                    throw new IllegalStateException(string3.length() != 0 ? "Could not instantiate an object of type ".concat(string3) : new String("Could not instantiate an object of type "), instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    String string4 = String.valueOf(field.getConcreteType().getCanonicalName());
                    throw new IllegalStateException(string4.length() != 0 ? "Could not access object of type ".concat(string4) : new String("Could not access object of type "), illegalAccessException);
                }
            }
        }
    }

    public <T extends SafeParcelable> T inflate(Parcelable.Creator<T> creator) {
        Parcel parcel = this.getParcel();
        parcel.setDataPosition(0);
        return (T)((SafeParcelable)creator.createFromParcel(parcel));
    }

    public static FieldMappingDictionary generateDictionary(Class<? extends FastJsonResponse> clazz) {
        try {
            return SafeParcelResponse.zza(clazz.newInstance());
        }
        catch (InstantiationException instantiationException) {
            String string2 = String.valueOf(clazz.getCanonicalName());
            throw new IllegalStateException(string2.length() != 0 ? "Could not instantiate an object of type ".concat(string2) : new String("Could not instantiate an object of type "), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string3 = String.valueOf(clazz.getCanonicalName());
            throw new IllegalStateException(string3.length() != 0 ? "Could not access object of type ".concat(string3) : new String("Could not access object of type "), illegalAccessException);
        }
    }

    @SafeParcelable.Constructor
    SafeParcelResponse(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) Parcel parcel, @SafeParcelable.Param(id=3) FieldMappingDictionary fieldMappingDictionary) {
        this.zzal = n;
        this.zzxq = (Parcel)Preconditions.checkNotNull((Object)parcel);
        this.zzxr = 2;
        this.zzwn = fieldMappingDictionary;
        this.mClassName = this.zzwn == null ? null : this.zzwn.getRootClassName();
        this.zzxs = 2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        FieldMappingDictionary fieldMappingDictionary;
        Parcel parcel2 = parcel;
        SafeParcelResponse safeParcelResponse = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)safeParcelResponse.getVersionCode());
        SafeParcelWriter.writeParcel((Parcel)parcel2, (int)2, (Parcel)safeParcelResponse.getParcel(), (boolean)false);
        SafeParcelResponse safeParcelResponse2 = safeParcelResponse;
        switch (safeParcelResponse2.zzxr) {
            case 0: {
                fieldMappingDictionary = null;
                break;
            }
            case 1: {
                fieldMappingDictionary = safeParcelResponse2.zzwn;
                break;
            }
            case 2: {
                fieldMappingDictionary = safeParcelResponse2.zzwn;
                break;
            }
            default: {
                int n3 = safeParcelResponse2.zzxr;
                throw new IllegalStateException(new StringBuilder(34).append("Invalid creation type: ").append(n3).toString());
            }
        }
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)fieldMappingDictionary, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public int getVersionCode() {
        return this.zzal;
    }

    public Parcel getParcel() {
        switch (this.zzxs) {
            case 0: {
                this.zzxt = SafeParcelWriter.beginObjectHeader((Parcel)this.zzxq);
            }
            case 1: {
                SafeParcelWriter.finishObjectHeader((Parcel)this.zzxq, (int)this.zzxt);
                this.zzxs = 2;
            }
        }
        return this.zzxq;
    }

    @Override
    public Map<String, FastJsonResponse.Field<?, ?>> getFieldMappings() {
        if (this.zzwn == null) {
            return null;
        }
        return this.zzwn.getFieldMapping(this.mClassName);
    }

    @Override
    public Object getValueObject(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    public boolean isPrimitiveFieldSet(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    private final void zzb(FastJsonResponse.Field<?, ?> field) {
        if (!field.isValidSafeParcelableFieldId()) {
            throw new IllegalStateException("Field does not have a valid safe parcelable field id.");
        }
        if (this.zzxq == null) {
            throw new IllegalStateException("Internal Parcel object is null.");
        }
        switch (this.zzxs) {
            case 0: {
                this.zzxt = SafeParcelWriter.beginObjectHeader((Parcel)this.zzxq);
                this.zzxs = 1;
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                throw new IllegalStateException("Attempted to parse JSON with a SafeParcelResponse object that is already filled with data.");
            }
        }
        throw new IllegalStateException("Unknown parse state in SafeParcelResponse.");
    }

    @Override
    protected void setIntegerInternal(FastJsonResponse.Field<?, ?> field, String string2, int n) {
        this.zzb(field);
        SafeParcelWriter.writeInt((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (int)n);
    }

    @Override
    protected void setIntegersInternal(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<Integer> arrayList) {
        this.zzb(field);
        int n = arrayList.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeIntArray((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (int[])nArray, (boolean)true);
    }

    @Override
    protected void setBigIntegerInternal(FastJsonResponse.Field<?, ?> field, String string2, BigInteger bigInteger) {
        this.zzb(field);
        SafeParcelWriter.writeBigInteger((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (BigInteger)bigInteger, (boolean)true);
    }

    @Override
    protected void setBigIntegersInternal(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<BigInteger> arrayList) {
        this.zzb(field);
        int n = arrayList.size();
        BigInteger[] bigIntegerArray = new BigInteger[n];
        for (int i = 0; i < n; ++i) {
            bigIntegerArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeBigIntegerArray((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (BigInteger[])bigIntegerArray, (boolean)true);
    }

    @Override
    protected void setLongInternal(FastJsonResponse.Field<?, ?> field, String string2, long l) {
        this.zzb(field);
        SafeParcelWriter.writeLong((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (long)l);
    }

    @Override
    protected void setLongsInternal(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<Long> arrayList) {
        this.zzb(field);
        int n = arrayList.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeLongArray((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (long[])lArray, (boolean)true);
    }

    @Override
    protected void setFloatInternal(FastJsonResponse.Field<?, ?> field, String string2, float f) {
        this.zzb(field);
        SafeParcelWriter.writeFloat((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (float)f);
    }

    @Override
    protected void setFloatsInternal(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<Float> arrayList) {
        this.zzb(field);
        int n = arrayList.size();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = arrayList.get(i).floatValue();
        }
        SafeParcelWriter.writeFloatArray((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (float[])fArray, (boolean)true);
    }

    @Override
    protected void setDoubleInternal(FastJsonResponse.Field<?, ?> field, String string2, double d) {
        this.zzb(field);
        SafeParcelWriter.writeDouble((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (double)d);
    }

    @Override
    protected void setDoublesInternal(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<Double> arrayList) {
        this.zzb(field);
        int n = arrayList.size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeDoubleArray((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (double[])dArray, (boolean)true);
    }

    @Override
    protected void setBigDecimalInternal(FastJsonResponse.Field<?, ?> field, String string2, BigDecimal bigDecimal) {
        this.zzb(field);
        SafeParcelWriter.writeBigDecimal((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (BigDecimal)bigDecimal, (boolean)true);
    }

    @Override
    protected void setBigDecimalsInternal(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<BigDecimal> arrayList) {
        this.zzb(field);
        int n = arrayList.size();
        BigDecimal[] bigDecimalArray = new BigDecimal[n];
        for (int i = 0; i < n; ++i) {
            bigDecimalArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeBigDecimalArray((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (BigDecimal[])bigDecimalArray, (boolean)true);
    }

    @Override
    protected void setBooleanInternal(FastJsonResponse.Field<?, ?> field, String string2, boolean bl) {
        this.zzb(field);
        SafeParcelWriter.writeBoolean((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (boolean)bl);
    }

    @Override
    protected void setBooleansInternal(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<Boolean> arrayList) {
        this.zzb(field);
        int n = arrayList.size();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeBooleanArray((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (boolean[])blArray, (boolean)true);
    }

    @Override
    protected void setStringInternal(FastJsonResponse.Field<?, ?> field, String string2, String string3) {
        this.zzb(field);
        SafeParcelWriter.writeString((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (String)string3, (boolean)true);
    }

    @Override
    protected void setStringsInternal(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<String> arrayList) {
        this.zzb(field);
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeStringArray((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (String[])stringArray, (boolean)true);
    }

    @Override
    protected void setDecodedBytesInternal(FastJsonResponse.Field<?, ?> field, String string2, byte[] byArray) {
        this.zzb(field);
        SafeParcelWriter.writeByteArray((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (byte[])byArray, (boolean)true);
    }

    @Override
    protected void setStringMapInternal(FastJsonResponse.Field<?, ?> field, String string2, Map<String, String> map) {
        this.zzb(field);
        Bundle bundle = new Bundle();
        for (String string3 : map.keySet()) {
            bundle.putString(string3, map.get(string3));
        }
        SafeParcelWriter.writeBundle((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (Bundle)bundle, (boolean)true);
    }

    @Override
    public <T extends FastJsonResponse> void addConcreteTypeInternal(FastJsonResponse.Field<?, ?> field, String string2, T t) {
        this.zzb(field);
        Parcel parcel = ((SafeParcelResponse)t).getParcel();
        SafeParcelWriter.writeParcel((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), (Parcel)parcel, (boolean)true);
    }

    @Override
    public <T extends FastJsonResponse> void addConcreteTypeArrayInternal(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<T> arrayList) {
        this.zzb(field);
        ArrayList<Parcel> arrayList2 = new ArrayList<Parcel>();
        arrayList.size();
        ArrayList<T> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            T t = arrayList3.get(i);
            FastJsonResponse fastJsonResponse = (FastJsonResponse)t;
            arrayList2.add(((SafeParcelResponse)fastJsonResponse).getParcel());
        }
        SafeParcelWriter.writeParcelList((Parcel)this.zzxq, (int)field.getSafeParcelableFieldId(), arrayList2, (boolean)true);
    }

    @Override
    public String toString() {
        Preconditions.checkNotNull((Object)((Object)this.zzwn), (Object)"Cannot convert to JSON on client side.");
        Parcel parcel = this.getParcel();
        parcel.setDataPosition(0);
        StringBuilder stringBuilder = new StringBuilder(100);
        this.zza(stringBuilder, this.zzwn.getFieldMapping(this.mClassName), parcel);
        return stringBuilder.toString();
    }

    private final void zza(StringBuilder stringBuilder, Map<String, FastJsonResponse.Field<?, ?>> map, Parcel parcel) {
        Object object = map;
        Object object2 = new SparseArray();
        for (Map.Entry<String, FastJsonResponse.Field<?, ?>> object3 : object.entrySet()) {
            object2.put(object3.getValue().getSafeParcelableFieldId(), object3);
        }
        SparseArray sparseArray = object2;
        stringBuilder.append('{');
        int n = SafeParcelReader.validateObjectHeader((Parcel)parcel);
        boolean bl = false;
        while (parcel.dataPosition() < n) {
            block50: {
                Object object3;
                Object object4;
                Object object5;
                FastJsonResponse.Field field;
                Parcel parcel2;
                int n2;
                FastJsonResponse.Field field2;
                Parcel parcel3;
                int n3;
                block49: {
                    int n4 = SafeParcelReader.readHeader((Parcel)parcel);
                    int n5 = SafeParcelReader.getFieldId((int)n4);
                    Map.Entry entry = (Map.Entry)sparseArray.get(n5);
                    if (entry == null) continue;
                    if (bl) {
                        stringBuilder.append(",");
                    }
                    n3 = n4;
                    parcel3 = parcel;
                    field2 = (FastJsonResponse.Field)((Object)entry.getValue());
                    String string2 = (String)entry.getKey();
                    object2 = stringBuilder;
                    object = this;
                    ((StringBuilder)object2).append("\"").append(string2).append("\":");
                    if (!field2.hasConverter()) break block49;
                    n2 = n3;
                    parcel2 = parcel3;
                    field = field2;
                    object5 = object2;
                    object4 = object;
                    switch (field.getTypeOut()) {
                        case 0: {
                            int l = SafeParcelReader.readInt((Parcel)parcel2, (int)n2);
                            super.zzb((StringBuilder)object5, field, ((FastJsonResponse)object4).getOriginalValue(field, l));
                            break block50;
                        }
                        case 1: {
                            BigInteger f = SafeParcelReader.createBigInteger((Parcel)parcel2, (int)n2);
                            super.zzb((StringBuilder)object5, field, ((FastJsonResponse)object4).getOriginalValue(field, f));
                            break block50;
                        }
                        case 2: {
                            long d = SafeParcelReader.readLong((Parcel)parcel2, (int)n2);
                            super.zzb((StringBuilder)object5, field, ((FastJsonResponse)object4).getOriginalValue(field, d));
                            break block50;
                        }
                        case 3: {
                            float bigDecimal = SafeParcelReader.readFloat((Parcel)parcel2, (int)n2);
                            super.zzb((StringBuilder)object5, field, ((FastJsonResponse)object4).getOriginalValue(field, Float.valueOf(bigDecimal)));
                            break block50;
                        }
                        case 4: {
                            double bl2 = SafeParcelReader.readDouble((Parcel)parcel2, (int)n2);
                            super.zzb((StringBuilder)object5, field, ((FastJsonResponse)object4).getOriginalValue(field, bl2));
                            break block50;
                        }
                        case 5: {
                            BigDecimal string3 = SafeParcelReader.createBigDecimal((Parcel)parcel2, (int)n2);
                            super.zzb((StringBuilder)object5, field, ((FastJsonResponse)object4).getOriginalValue(field, string3));
                            break block50;
                        }
                        case 6: {
                            boolean byArray = SafeParcelReader.readBoolean((Parcel)parcel2, (int)n2);
                            super.zzb((StringBuilder)object5, field, ((FastJsonResponse)object4).getOriginalValue(field, byArray));
                            break block50;
                        }
                        case 7: {
                            String n7 = SafeParcelReader.createString((Parcel)parcel2, (int)n2);
                            super.zzb((StringBuilder)object5, field, ((FastJsonResponse)object4).getOriginalValue(field, n7));
                            break block50;
                        }
                        case 8: 
                        case 9: {
                            byte[] objectArray = SafeParcelReader.createByteArray((Parcel)parcel2, (int)n2);
                            super.zzb((StringBuilder)object5, field, ((FastJsonResponse)object4).getOriginalValue(field, objectArray));
                            break block50;
                        }
                        case 10: {
                            object3 = SafeParcelResponse.convertBundleToStringMap(SafeParcelReader.createBundle((Parcel)parcel2, (int)n2));
                            super.zzb((StringBuilder)object5, field, ((FastJsonResponse)object4).getOriginalValue(field, object3));
                            break block50;
                        }
                        case 11: {
                            throw new IllegalArgumentException("Method does not accept concrete type.");
                        }
                        default: {
                            int n9 = field.getTypeOut();
                            throw new IllegalArgumentException(new StringBuilder(36).append("Unknown field out type = ").append(n9).toString());
                        }
                    }
                }
                n2 = n3;
                parcel2 = parcel3;
                field = field2;
                object5 = object2;
                object4 = object;
                if (field.isTypeOutArray()) {
                    ((StringBuilder)object5).append("[");
                    switch (field.getTypeOut()) {
                        case 0: {
                            Object[] bigInteger = SafeParcelReader.createIntArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (int[])bigInteger);
                            break;
                        }
                        case 1: {
                            Object[] bigInteger = SafeParcelReader.createBigIntegerArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (Object[])bigInteger);
                            break;
                        }
                        case 2: {
                            Object[] bigInteger = SafeParcelReader.createLongArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (long[])bigInteger);
                            break;
                        }
                        case 3: {
                            Object[] bigInteger = SafeParcelReader.createFloatArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (float[])bigInteger);
                            break;
                        }
                        case 4: {
                            Object[] bigInteger = SafeParcelReader.createDoubleArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (double[])bigInteger);
                            break;
                        }
                        case 5: {
                            Object[] bigInteger = SafeParcelReader.createBigDecimalArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (Object[])bigInteger);
                            break;
                        }
                        case 6: {
                            Object[] bigInteger = SafeParcelReader.createBooleanArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (boolean[])bigInteger);
                            break;
                        }
                        case 7: {
                            Object[] bigInteger = SafeParcelReader.createStringArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeStringArray((StringBuilder)object5, (String[])bigInteger);
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: {
                            throw new UnsupportedOperationException("List of type BASE64, BASE64_URL_SAFE, or STRING_MAP is not supported");
                        }
                        case 11: {
                            Parcel[] parcelArray = SafeParcelReader.createParcelArray((Parcel)parcel2, (int)n2);
                            Object[] bigInteger = parcelArray;
                            int n6 = parcelArray.length;
                            for (int i = 0; i < n6; ++i) {
                                if (i > 0) {
                                    ((StringBuilder)object5).append(",");
                                }
                                bigInteger[i].setDataPosition(0);
                                super.zza((StringBuilder)object5, field.getConcreteTypeFieldMappingFromDictionary(), (Parcel)bigInteger[i]);
                            }
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown field type out.");
                        }
                    }
                    ((StringBuilder)object5).append("]");
                } else {
                    switch (field.getTypeOut()) {
                        case 0: {
                            int l = SafeParcelReader.readInt((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(l);
                            break;
                        }
                        case 1: {
                            BigInteger f = SafeParcelReader.createBigInteger((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(f);
                            break;
                        }
                        case 2: {
                            long d = SafeParcelReader.readLong((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(d);
                            break;
                        }
                        case 3: {
                            float bigDecimal = SafeParcelReader.readFloat((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(bigDecimal);
                            break;
                        }
                        case 4: {
                            double bl3 = SafeParcelReader.readDouble((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(bl3);
                            break;
                        }
                        case 5: {
                            BigDecimal string4 = SafeParcelReader.createBigDecimal((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(string4);
                            break;
                        }
                        case 6: {
                            boolean byArray = SafeParcelReader.readBoolean((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(byArray);
                            break;
                        }
                        case 7: {
                            String byArray = SafeParcelReader.createString((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append("\"").append(JsonUtils.escapeString((String)byArray)).append("\"");
                            break;
                        }
                        case 8: {
                            byte[] bundle = SafeParcelReader.createByteArray((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append("\"").append(Base64Utils.encode((byte[])bundle)).append("\"");
                            break;
                        }
                        case 9: {
                            byte[] parcel4 = SafeParcelReader.createByteArray((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append("\"").append(Base64Utils.encodeUrlSafe((byte[])parcel4));
                            ((StringBuilder)object5).append("\"");
                            break;
                        }
                        case 10: {
                            Bundle bundle = SafeParcelReader.createBundle((Parcel)parcel2, (int)n2);
                            object3 = bundle.keySet();
                            object3.size();
                            ((StringBuilder)object5).append("{");
                            boolean bl2 = true;
                            Iterator iterator = object3.iterator();
                            while (iterator.hasNext()) {
                                String string2 = (String)iterator.next();
                                if (!bl2) {
                                    ((StringBuilder)object5).append(",");
                                }
                                bl2 = false;
                                ((StringBuilder)object5).append("\"").append(string2).append("\"");
                                ((StringBuilder)object5).append(":");
                                ((StringBuilder)object5).append("\"").append(JsonUtils.escapeString((String)bundle.getString(string2))).append("\"");
                            }
                            ((StringBuilder)object5).append("}");
                            break;
                        }
                        case 11: {
                            Parcel parcel4 = SafeParcelReader.createParcel((Parcel)parcel2, (int)n2);
                            parcel4.setDataPosition(0);
                            super.zza((StringBuilder)object5, field.getConcreteTypeFieldMappingFromDictionary(), parcel4);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown field type out");
                        }
                    }
                }
            }
            bl = true;
        }
        if (parcel.dataPosition() != n) {
            throw new SafeParcelReader.ParseException(new StringBuilder(37).append("Overread allowed size end=").append(n).toString(), parcel);
        }
        stringBuilder.append('}');
    }

    private final void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Object object) {
        if (field.isTypeInArray()) {
            ArrayList arrayList = (ArrayList)object;
            FastJsonResponse.Field<?, ?> field2 = field;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append("[");
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuilder2.append(",");
                }
                SafeParcelResponse.zza(stringBuilder2, field2.getTypeIn(), arrayList.get(i));
            }
            stringBuilder2.append("]");
            return;
        }
        SafeParcelResponse.zza(stringBuilder, field.getTypeIn(), object);
    }

    private static void zza(StringBuilder stringBuilder, int n, Object object) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                stringBuilder.append(object);
                return;
            }
            case 7: {
                stringBuilder.append("\"").append(JsonUtils.escapeString((String)object.toString())).append("\"");
                return;
            }
            case 8: {
                stringBuilder.append("\"").append(Base64Utils.encode((byte[])((byte[])object))).append("\"");
                return;
            }
            case 9: {
                stringBuilder.append("\"").append(Base64Utils.encodeUrlSafe((byte[])((byte[])object)));
                stringBuilder.append("\"");
                return;
            }
            case 10: {
                MapUtils.writeStringMapToJson((StringBuilder)stringBuilder, (HashMap)((HashMap)object));
                return;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
        }
        throw new IllegalArgumentException(new StringBuilder(26).append("Unknown type = ").append(n).toString());
    }

    public static HashMap<String, String> convertBundleToStringMap(Bundle bundle) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : bundle.keySet()) {
            hashMap.put(string2, bundle.getString(string2));
        }
        return hashMap;
    }

    public static Bundle convertStringMapToBundle(HashMap<String, String> hashMap) {
        Bundle bundle = new Bundle();
        for (String string2 : hashMap.keySet()) {
            bundle.putString(string2, hashMap.get(string2));
        }
        return bundle;
    }
}

