/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zzav;
import com.google.android.gms.common.api.internal.zzch;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignIn;
import com.google.android.gms.signin.SignInClient;
import com.google.android.gms.signin.SignInOptions;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public abstract class GoogleApiClient {
    @KeepForSdk
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    @GuardedBy(value="sAllClients")
    private static final Set<GoogleApiClient> zzcu = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    public GoogleApiClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Set<GoogleApiClient> set = zzcu;
        synchronized (set) {
            int n = 0;
            String string3 = String.valueOf(string2).concat("  ");
            for (GoogleApiClient googleApiClient : zzcu) {
                printWriter.append(string2).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string3, fileDescriptor, printWriter, stringArray);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static Set<GoogleApiClient> getAllClients() {
        Set<GoogleApiClient> set = zzcu;
        synchronized (set) {
            return zzcu;
        }
    }

    @KeepForSdk
    public <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    @KeepForSdk
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    @KeepForSdk
    public <L> ListenerHolder<L> registerListener(@NonNull L l) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    @KeepForSdk
    public <C extends Api.Client> C getClient(@NonNull Api.AnyClientKey<C> anyClientKey) {
        throw new UnsupportedOperationException();
    }

    @KeepForSdk
    public boolean hasApi(@NonNull Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(@NonNull Api<?> var1);

    @NonNull
    public abstract ConnectionResult getConnectionResult(@NonNull Api<?> var1);

    @KeepForSdk
    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    @KeepForSdk
    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    @KeepForSdk
    public boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        throw new UnsupportedOperationException();
    }

    @KeepForSdk
    public void maybeSignOut() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int n) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, @NonNull TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(@NonNull FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(@NonNull ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(@NonNull OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public void zza(zzch zzch2) {
        throw new UnsupportedOperationException();
    }

    public void zzb(zzch zzch2) {
        throw new UnsupportedOperationException();
    }

    @KeepForSdk
    public static final class Builder {
        private Account zzs;
        private final Set<Scope> zzcv = new HashSet<Scope>();
        private final Set<Scope> zzcw = new HashSet<Scope>();
        private int zzcx;
        private View zzcy;
        private String zzcz;
        private String zzda;
        private final Map<Api<?>, ClientSettings.OptionalApiSettings> zzdb = new ArrayMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzdc = new ArrayMap();
        private LifecycleActivity zzdd;
        private int zzde = -1;
        private OnConnectionFailedListener zzdf;
        private Looper zzcn;
        private GoogleApiAvailability zzdg = GoogleApiAvailability.getInstance();
        private Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> zzdh = SignIn.CLIENT_BUILDER;
        private final ArrayList<ConnectionCallbacks> zzdi = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> zzdj = new ArrayList();
        private boolean zzdk = false;

        @KeepForSdk
        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.zzcn = context.getMainLooper();
            this.zzcz = context.getPackageName();
            this.zzda = context.getClass().getName();
        }

        @KeepForSdk
        public Builder(@NonNull Context context, @NonNull ConnectionCallbacks connectionCallbacks, @NonNull OnConnectionFailedListener onConnectionFailedListener) {
            this(context);
            Preconditions.checkNotNull((Object)connectionCallbacks, (Object)"Must provide a connected listener");
            this.zzdi.add(connectionCallbacks);
            Preconditions.checkNotNull((Object)onConnectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzdj.add(onConnectionFailedListener);
        }

        public final Builder setHandler(@NonNull Handler handler) {
            Preconditions.checkNotNull((Object)handler, (Object)"Handler must not be null");
            this.zzcn = handler.getLooper();
            return this;
        }

        public final Builder addConnectionCallbacks(@NonNull ConnectionCallbacks connectionCallbacks) {
            Preconditions.checkNotNull((Object)connectionCallbacks, (Object)"Listener must not be null");
            this.zzdi.add(connectionCallbacks);
            return this;
        }

        public final Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener onConnectionFailedListener) {
            Preconditions.checkNotNull((Object)onConnectionFailedListener, (Object)"Listener must not be null");
            this.zzdj.add(onConnectionFailedListener);
            return this;
        }

        public final Builder setViewForPopups(@NonNull View view) {
            Preconditions.checkNotNull((Object)view, (Object)"View must not be null");
            this.zzcy = view;
            return this;
        }

        public final Builder addScope(@NonNull Scope scope) {
            Preconditions.checkNotNull((Object)scope, (Object)"Scope must not be null");
            this.zzcv.add(scope);
            return this;
        }

        @KeepForSdk
        public final Builder addScopeNames(String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.zzcv.add(new Scope(stringArray[i]));
            }
            return this;
        }

        public final Builder addApi(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            Preconditions.checkNotNull(api, (Object)"Api must not be null");
            this.zzdc.put(api, null);
            List<Scope> list = api.zzj().getImpliedScopes(null);
            this.zzcw.addAll(list);
            this.zzcv.addAll(list);
            return this;
        }

        public final Builder addApiIfAvailable(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopeArray) {
            Preconditions.checkNotNull(api, (Object)"Api must not be null");
            this.zzdc.put(api, null);
            this.zza(api, null, scopeArray);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O o) {
            Preconditions.checkNotNull(api, (Object)"Api must not be null");
            Preconditions.checkNotNull(o, (Object)"Null options are not permitted for this Api");
            this.zzdc.put(api, o);
            List<Scope> list = api.zzj().getImpliedScopes(o);
            this.zzcw.addAll(list);
            this.zzcv.addAll(list);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(@NonNull Api<O> api, @NonNull O o, Scope ... scopeArray) {
            Preconditions.checkNotNull(api, (Object)"Api must not be null");
            Preconditions.checkNotNull(o, (Object)"Null options are not permitted for this Api");
            this.zzdc.put(api, o);
            this.zza(api, o, scopeArray);
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzs = string2 == null ? null : new Account(string2, "com.google");
            return this;
        }

        public final Builder useDefaultAccount() {
            return this.setAccountName(GoogleApiClient.DEFAULT_ACCOUNT);
        }

        public final Builder setGravityForPopups(int n) {
            this.zzcx = n;
            return this;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
            LifecycleActivity lifecycleActivity = new LifecycleActivity((Activity)fragmentActivity);
            Builder builder = this;
            Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"clientId must be non-negative");
            builder.zzde = n;
            builder.zzdf = onConnectionFailedListener2;
            builder.zzdd = lifecycleActivity;
            return builder;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, onConnectionFailedListener);
        }

        @VisibleForTesting
        @KeepForSdk
        public final ClientSettings buildClientSettings() {
            SignInOptions signInOptions = SignInOptions.DEFAULT;
            if (this.zzdc.containsKey(SignIn.API)) {
                signInOptions = (SignInOptions)this.zzdc.get(SignIn.API);
            }
            return new ClientSettings(this.zzs, this.zzcv, this.zzdb, this.zzcx, this.zzcy, this.zzcz, this.zzda, signInOptions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final GoogleApiClient build() {
            Preconditions.checkArgument((!this.zzdc.isEmpty() ? 1 : 0) != 0, (Object)"must call addApi() to add at least one API");
            Builder builder = this;
            Object object = builder.buildClientSettings();
            Api<?> api = null;
            boolean bl = false;
            Map<Api<?>, ClientSettings.OptionalApiSettings> map = ((ClientSettings)object).getOptionalApiSettings();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<zzp> arrayList = new ArrayList<zzp>();
            for (Api<?> api2 : builder.zzdc.keySet()) {
                Api.ApiOptions apiOptions = builder.zzdc.get(api2);
                boolean bl2 = map.get(api2) != null;
                arrayMap.put(api2, bl2);
                zzp zzp2 = new zzp(api2, bl2);
                arrayList.add(zzp2);
                Object object2 = api2.zzk();
                Api.AbstractClientBuilder<?, ?> abstractClientBuilder = object2;
                zzp zzp3 = zzp2;
                zzp zzp4 = zzp2;
                ClientSettings clientSettings = object;
                Looper looper = builder.zzcn;
                Context context = builder.mContext;
                Api.ApiOptions apiOptions2 = apiOptions;
                Object obj = ((Api.AbstractClientBuilder)object2).buildClient(context, looper, clientSettings, apiOptions2, zzp4, zzp3);
                arrayMap2.put(api2.getClientKey(), obj);
                if (abstractClientBuilder.getPriority() == 1) {
                    boolean bl3 = bl = apiOptions != null;
                }
                if (!obj.providesSignIn()) continue;
                if (api != null) {
                    object2 = api2.getName();
                    String string2 = api.getName();
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(object2).length() + String.valueOf(string2).length()).append((String)object2).append(" cannot be used with ").append(string2).toString());
                }
                api = api2;
            }
            if (api != null) {
                if (bl) {
                    String string3 = api.getName();
                    throw new IllegalStateException(new StringBuilder(82 + String.valueOf(string3).length()).append("With using ").append(string3).append(", GamesOptions can only be specified within GoogleSignInOptions.Builder").toString());
                }
                Preconditions.checkState((builder.zzs == null ? 1 : 0) != 0, (String)"Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", (Object[])new Object[]{api.getName()});
                Preconditions.checkState((boolean)builder.zzcv.equals(builder.zzcw), (String)"Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", (Object[])new Object[]{api.getName()});
            }
            int n = zzav.zza(arrayMap2.values(), true);
            zzav zzav2 = new zzav(builder.mContext, new ReentrantLock(), builder.zzcn, (ClientSettings)object, builder.zzdg, builder.zzdh, (Map<Api<?>, Boolean>)arrayMap, (List<ConnectionCallbacks>)builder.zzdi, (List<OnConnectionFailedListener>)builder.zzdj, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap2, builder.zzde, n, arrayList, false);
            Set set = zzcu;
            synchronized (set) {
                zzcu.add(zzav2);
            }
            if (this.zzde >= 0) {
                object = zzav2;
                builder = this;
                zzi.zza(builder.zzdd).zza(builder.zzde, (GoogleApiClient)object, builder.zzdf);
            }
            return zzav2;
        }

        private final <O extends Api.ApiOptions> void zza(Api<O> api, O o, Scope ... scopeArray) {
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzj().getImpliedScopes(o));
            Scope[] scopeArray2 = scopeArray;
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                Scope scope = scopeArray2[i];
                hashSet.add(scope);
            }
            this.zzdb.put(api, new ClientSettings.OptionalApiSettings(hashSet));
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

