/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public final class ListenerHolder<L> {
    private final zza zzlh;
    private volatile L zzli;
    private final ListenerKey<L> zzlj;

    @KeepForSdk
    ListenerHolder(@NonNull Looper looper, @NonNull L l, @NonNull String string2) {
        this.zzlh = new zza(looper);
        this.zzli = Preconditions.checkNotNull(l, (Object)"Listener must not be null");
        this.zzlj = new ListenerKey<L>(l, Preconditions.checkNotEmpty((String)string2));
    }

    @KeepForSdk
    public final void notifyListener(Notifier<? super L> notifier) {
        Preconditions.checkNotNull(notifier, (Object)"Notifier must not be null");
        Message message = this.zzlh.obtainMessage(1, notifier);
        this.zzlh.sendMessage(message);
    }

    @KeepForSdk
    public final boolean hasListener() {
        return this.zzli != null;
    }

    @KeepForSdk
    public final void clear() {
        this.zzli = null;
    }

    @NonNull
    @KeepForSdk
    public final ListenerKey<L> getListenerKey() {
        return this.zzlj;
    }

    @KeepForSdk
    final void notifyListenerInternal(Notifier<? super L> notifier) {
        L l = this.zzli;
        if (l == null) {
            notifier.onNotifyListenerFailed();
            return;
        }
        try {
            notifier.notifyListener(l);
            return;
        }
        catch (RuntimeException runtimeException) {
            notifier.onNotifyListenerFailed();
            throw runtimeException;
        }
    }

    @KeepForSdk
    public static final class ListenerKey<L> {
        private final L zzli;
        private final String zzll;

        @KeepForSdk
        ListenerKey(L l, String string2) {
            this.zzli = l;
            this.zzll = string2;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ListenerKey)) {
                return false;
            }
            ListenerKey listenerKey = (ListenerKey)object;
            return this.zzli == listenerKey.zzli && this.zzll.equals(listenerKey.zzll);
        }

        public final int hashCode() {
            int n = System.identityHashCode(this.zzli);
            return n * 31 + this.zzll.hashCode();
        }
    }

    private final class zza
    extends Handler {
        public zza(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            Preconditions.checkArgument((message.what == 1 ? 1 : 0) != 0);
            ListenerHolder.this.notifyListenerInternal((Notifier)message.obj);
        }
    }

    @KeepForSdk
    public static interface Notifier<L> {
        @KeepForSdk
        public void notifyListener(L var1);

        @KeepForSdk
        public void onNotifyListenerFailed();
    }
}

