/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.DataHolderCreator;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.sqlite.CursorWrapper;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@KeepName
@SafeParcelable.Class(creator="DataHolderCreator", validate=true)
public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new DataHolderCreator();
    @SafeParcelable.VersionField(id=1000)
    private final int zzal;
    @SafeParcelable.Field(id=1, getter="getColumns")
    private final String[] zznm;
    private Bundle zznn;
    @SafeParcelable.Field(id=2, getter="getWindows")
    private final CursorWindow[] zzno;
    @SafeParcelable.Field(id=3, getter="getStatusCode")
    private final int zzam;
    @SafeParcelable.Field(id=4, getter="getMetadata")
    private final Bundle zznp;
    private int[] zznq;
    private int zznr;
    private boolean mClosed = false;
    private boolean zzns = true;
    private static final Builder zznt = new com.google.android.gms.common.data.zza(new String[0], null);

    @SafeParcelable.Constructor
    DataHolder(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) String[] stringArray, @SafeParcelable.Param(id=2) CursorWindow[] cursorWindowArray, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) Bundle bundle) {
        this.zzal = n;
        this.zznm = stringArray;
        this.zzno = cursorWindowArray;
        this.zzam = n2;
        this.zznp = bundle;
    }

    public DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.zzal = 1;
        this.zznm = (String[])Preconditions.checkNotNull((Object)stringArray);
        this.zzno = (CursorWindow[])Preconditions.checkNotNull((Object)cursorWindowArray);
        this.zzam = n;
        this.zznp = bundle;
        this.validateContents();
    }

    public final void disableLeakDetection() {
        this.zzns = false;
    }

    public DataHolder(CursorWrapper cursorWrapper, int n, Bundle bundle) {
        this(cursorWrapper.getColumnNames(), DataHolder.zza(cursorWrapper), n, bundle);
    }

    public DataHolder(Cursor cursor, int n, Bundle bundle) {
        this(new CursorWrapper(cursor), n, bundle);
    }

    private DataHolder(Builder builder, int n, Bundle bundle) {
        this(builder.zznm, DataHolder.zza(builder, -1), n, bundle);
    }

    private DataHolder(Builder builder, int n, Bundle bundle, int n2) {
        this(builder.zznm, DataHolder.zza(builder, n2), n, bundle);
    }

    public final void validateContents() {
        int n;
        this.zznn = new Bundle();
        for (n = 0; n < this.zznm.length; ++n) {
            this.zznn.putInt(this.zznm[n], n);
        }
        this.zznq = new int[this.zzno.length];
        n = 0;
        for (int i = 0; i < this.zzno.length; ++i) {
            this.zznq[i] = n;
            int n2 = this.zzno[i].getStartPosition();
            int n3 = n - n2;
            n += this.zzno[i].getNumRows() - n3;
        }
        this.zznr = n;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataHolder dataHolder = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeStringArray((Parcel)parcel2, (int)1, (String[])dataHolder.zznm, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)2, (Parcelable[])dataHolder.zzno, (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)dataHolder.getStatusCode());
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)4, (Bundle)dataHolder.getMetadata(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)dataHolder.zzal);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        if ((n & 1) != 0) {
            this.close();
        }
    }

    public final void logCursorMetadataForDebugging() {
        Log.d((String)"DataHolder", (String)"*******************************************");
        int n = this.zzno.length;
        Log.d((String)"DataHolder", (String)new StringBuilder(32).append("num cursor windows : ").append(n).toString());
        n = this.zznr;
        Log.d((String)"DataHolder", (String)new StringBuilder(46).append("total number of objects in holder: ").append(n).toString());
        n = this.zznq.length;
        Log.d((String)"DataHolder", (String)new StringBuilder(42).append("total mumber of windowOffsets: ").append(n).toString());
        for (n = 0; n < this.zznq.length; ++n) {
            int n2 = n;
            int n3 = this.zznq[n];
            Log.d((String)"DataHolder", (String)new StringBuilder(43).append("offset for window ").append(n2).append(" : ").append(n3).toString());
            n2 = n;
            n3 = this.zzno[n].getNumRows();
            Log.d((String)"DataHolder", (String)new StringBuilder(45).append("num rows for window ").append(n2).append(" : ").append(n3).toString());
            n2 = n;
            n3 = this.zzno[n].getStartPosition();
            Log.d((String)"DataHolder", (String)new StringBuilder(46).append("start pos for window ").append(n2).append(" : ").append(n3).toString());
        }
        Log.d((String)"DataHolder", (String)"*******************************************");
    }

    public final int getStatusCode() {
        return this.zzam;
    }

    public final Bundle getMetadata() {
        return this.zznp;
    }

    private static CursorWindow[] zza(CursorWrapper cursorWrapper) {
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        try {
            int n = cursorWrapper.getCount();
            CursorWindow cursorWindow = cursorWrapper.getWindow();
            int n2 = 0;
            if (cursorWindow != null && cursorWindow.getStartPosition() == 0) {
                cursorWindow.acquireReference();
                cursorWrapper.setWindow(null);
                arrayList.add(cursorWindow);
                n2 = cursorWindow.getNumRows();
            }
            while (n2 < n && cursorWrapper.moveToPosition(n2)) {
                CursorWindow cursorWindow2 = cursorWrapper.getWindow();
                if (cursorWindow2 != null) {
                    cursorWindow2.acquireReference();
                    cursorWrapper.setWindow(null);
                } else {
                    cursorWindow2 = new CursorWindow(false);
                    cursorWindow2.setStartPosition(n2);
                    cursorWrapper.fillWindow(n2, cursorWindow2);
                }
                if (cursorWindow2.getNumRows() != 0) {
                    arrayList.add(cursorWindow2);
                    n2 = cursorWindow2.getStartPosition() + cursorWindow2.getNumRows();
                    continue;
                }
                break;
            }
        }
        finally {
            cursorWrapper.close();
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private static CursorWindow[] zza(Builder builder, int n) {
        if (builder.zznm.length == 0) {
            return new CursorWindow[0];
        }
        List list = n < 0 || n >= builder.zznu.size() ? builder.zznu : builder.zznu.subList(0, n);
        int n2 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(builder.zznm.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(builder.zznm.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < builder.zznm.length && bl2; ++n3) {
                    String string2 = builder.zznm[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new DataHolderException(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(builder.zznm.length);
                    arrayList.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private final void zza(String string2, int n) {
        if (this.zznn == null || !this.zznn.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zznr) {
            throw new CursorIndexOutOfBoundsException(n, this.zznr);
        }
    }

    public final boolean hasColumn(String string2) {
        return this.zznn.containsKey(string2);
    }

    public final long getLong(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zzno[n2].getLong(n, this.zznn.getInt(string2));
    }

    public final int getInteger(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zzno[n2].getInt(n, this.zznn.getInt(string2));
    }

    public final String getString(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zzno[n2].getString(n, this.zznn.getInt(string2));
    }

    public final boolean getBoolean(String string2, int n, int n2) {
        this.zza(string2, n);
        return Long.valueOf(this.zzno[n2].getLong(n, this.zznn.getInt(string2))) == 1L;
    }

    public final float getFloat(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zzno[n2].getFloat(n, this.zznn.getInt(string2));
    }

    public final double getDouble(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zzno[n2].getDouble(n, this.zznn.getInt(string2));
    }

    public final byte[] getByteArray(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zzno[n2].getBlob(n, this.zznn.getInt(string2));
    }

    public final Uri parseUri(String string2, int n, int n2) {
        String string3 = this.getString(string2, n, n2);
        if (string3 == null) {
            return null;
        }
        return Uri.parse((String)string3);
    }

    public final void copyToBuffer(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zza(string2, n);
        this.zzno[n2].copyStringToBuffer(n, this.zznn.getInt(string2), charArrayBuffer);
    }

    public final boolean hasNull(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zzno[n2].isNull(n, this.zznn.getInt(string2));
    }

    public final void clearColumn(String string2, int n, int n2) {
        this.zza(string2, n);
        this.zzno[n2].putNull(n, this.zznn.getInt(string2));
    }

    public final void replaceValue(String string2, int n, int n2, String string3) {
        this.zza(string2, n);
        this.zzno[n2].putString(string3, n, this.zznn.getInt(string2));
    }

    public final void replaceValue(String string2, int n, int n2, double d) {
        this.zza(string2, n);
        this.zzno[n2].putDouble(d, n, this.zznn.getInt(string2));
    }

    public final void replaceValue(String string2, int n, int n2, long l) {
        this.zza(string2, n);
        this.zzno[n2].putLong(l, n, this.zznn.getInt(string2));
    }

    public final void replaceValue(String string2, int n, int n2, byte[] byArray) {
        this.zza(string2, n);
        this.zzno[n2].putBlob(byArray, n, this.zznn.getInt(string2));
    }

    public final int getCount() {
        return this.zznr;
    }

    public final int getWindowIndex(int n) {
        int n2;
        Preconditions.checkState((n >= 0 && n < this.zznr ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zznq.length; ++n2) {
            if (n >= this.zznq[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zznq.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zzno.length; ++i) {
                    this.zzno[i].close();
                }
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        try {
            if (this.zzns && this.zzno.length > 0 && !this.isClosed()) {
                this.close();
                String string2 = this.toString();
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public static Builder builder(String[] stringArray) {
        return new Builder(stringArray, null, null);
    }

    public static Builder builder(String[] stringArray, String string2) {
        Preconditions.checkNotNull((Object)string2);
        return new Builder(stringArray, string2, null);
    }

    public static DataHolder empty(int n) {
        return DataHolder.empty(n, null);
    }

    public static DataHolder empty(int n, Bundle bundle) {
        return new DataHolder(zznt, n, bundle);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, com.google.android.gms.common.data.zza zza2) {
        this(builder, n, null);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, int n2, com.google.android.gms.common.data.zza zza2) {
        this(builder, n, bundle, n2);
    }

    public static class DataHolderException
    extends RuntimeException {
        public DataHolderException(String string2) {
            super(string2);
        }
    }

    private static final class zza
    implements Comparator<HashMap<String, Object>> {
        private final String zznz;

        zza(String string2) {
            this.zznz = (String)Preconditions.checkNotNull((Object)string2);
        }

        @Override
        public final /* synthetic */ int compare(Object object, Object object2) {
            Object object3;
            HashMap hashMap = (HashMap)object2;
            HashMap hashMap2 = (HashMap)object;
            zza zza2 = this;
            Object object4 = Preconditions.checkNotNull(hashMap2.get(zza2.zznz));
            if (object4.equals(object3 = Preconditions.checkNotNull(hashMap.get(zza2.zznz)))) {
                return 0;
            }
            if (object4 instanceof Boolean) {
                return ((Boolean)object4).compareTo((Boolean)object3);
            }
            if (object4 instanceof Long) {
                return ((Long)object4).compareTo((Long)object3);
            }
            if (object4 instanceof Integer) {
                return ((Integer)object4).compareTo((Integer)object3);
            }
            if (object4 instanceof String) {
                return ((String)object4).compareTo((String)object3);
            }
            if (object4 instanceof Double) {
                return ((Double)object4).compareTo((Double)object3);
            }
            if (object4 instanceof Float) {
                return ((Float)object4).compareTo((Float)object3);
            }
            String string2 = String.valueOf(object4);
            throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string2).length()).append("Unknown type for lValue ").append(string2).toString());
        }
    }

    public static class Builder {
        private final String[] zznm;
        private final ArrayList<HashMap<String, Object>> zznu;
        private final String zznv;
        private final HashMap<Object, Integer> zznw;
        private boolean zznx;
        private String zzny;

        private Builder(String[] stringArray, String string2) {
            this.zznm = (String[])Preconditions.checkNotNull((Object)stringArray);
            this.zznu = new ArrayList();
            this.zznv = string2;
            this.zznw = new HashMap();
            this.zznx = false;
            this.zzny = null;
        }

        public Builder withRow(HashMap<String, Object> hashMap) {
            int n;
            int n2;
            Asserts.checkNotNull(hashMap);
            HashMap<String, Object> hashMap2 = hashMap;
            Builder builder = this;
            if (builder.zznv == null) {
                n2 = -1;
            } else {
                Object object = hashMap2.get(builder.zznv);
                if (object == null) {
                    n2 = -1;
                } else {
                    Integer n3 = builder.zznw.get(object);
                    if (n3 == null) {
                        builder.zznw.put(object, builder.zznu.size());
                        n2 = -1;
                    } else {
                        n2 = n = n3.intValue();
                    }
                }
            }
            if (n2 == -1) {
                this.zznu.add(hashMap);
            } else {
                this.zznu.remove(n);
                this.zznu.add(n, hashMap);
            }
            this.zznx = false;
            return this;
        }

        public void modifyUniqueRowValue(Object object, String string2, Object object2) {
            if (this.zznv == null) {
                return;
            }
            Integer n = this.zznw.get(object);
            if (n == null) {
                return;
            }
            this.zznu.get(n).put(string2, object2);
        }

        public Builder withRow(ContentValues contentValues) {
            Asserts.checkNotNull((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            for (Map.Entry entry : contentValues.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.withRow(hashMap);
        }

        public boolean containsRowWithValue(String string2, Object object) {
            int n = this.zznu.size();
            for (int i = 0; i < n; ++i) {
                if (!Objects.equal((Object)this.zznu.get(i).get(string2), (Object)object)) continue;
                return true;
            }
            return false;
        }

        public Builder removeRowsWithValue(String string2, Object object) {
            for (int i = this.zznu.size() - 1; i >= 0; --i) {
                if (!Objects.equal((Object)this.zznu.get(i).get(string2), (Object)object)) continue;
                this.zznu.remove(i);
            }
            return this;
        }

        public Builder sort(String string2) {
            if (this.zzg(string2)) {
                return this;
            }
            Collections.sort(this.zznu, new zza(string2));
            Builder builder = this;
            if (builder.zznv != null) {
                builder.zznw.clear();
                int n = builder.zznu.size();
                for (int i = 0; i < n; ++i) {
                    Object object = builder.zznu.get(i).get(builder.zznv);
                    if (object == null) continue;
                    builder.zznw.put(object, i);
                }
            }
            this.zznx = true;
            this.zzny = string2;
            return this;
        }

        public Builder descendingSort(String string2) {
            if (this.zzg(string2)) {
                return this;
            }
            this.sort(string2);
            Collections.reverse(this.zznu);
            return this;
        }

        private final boolean zzg(String string2) {
            Asserts.checkNotNull((Object)string2);
            return this.zznx && string2.equals(this.zzny);
        }

        public int getCount() {
            return this.zznu.size();
        }

        public DataHolder build(int n) {
            return new DataHolder(this, n, null, null);
        }

        public DataHolder build(int n, Bundle bundle) {
            return new DataHolder(this, n, bundle, -1, null);
        }

        public DataHolder build(int n, Bundle bundle, int n2) {
            return new DataHolder(this, n, bundle, n2, null);
        }

        /* synthetic */ Builder(String[] stringArray, String string2, com.google.android.gms.common.data.zza zza2) {
            this(stringArray, string2);
        }
    }
}

