/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.AccountAccessor;
import com.google.android.gms.common.internal.AuthAccountRequestCreator;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

@SafeParcelable.Class(creator="AuthAccountRequestCreator")
public class AuthAccountRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<AuthAccountRequest> CREATOR = new AuthAccountRequestCreator();
    @SafeParcelable.VersionField(id=1)
    private final int zzal;
    @Deprecated
    @SafeParcelable.Field(id=2)
    private final IBinder zzqv;
    @SafeParcelable.Field(id=3)
    private final Scope[] zzqw;
    @SafeParcelable.Field(id=4)
    private Integer zzqx;
    @SafeParcelable.Field(id=5)
    private Integer zzqy;
    @SafeParcelable.Field(id=6, type="android.accounts.Account")
    private Account zzs;

    @SafeParcelable.Constructor
    AuthAccountRequest(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) IBinder iBinder, @SafeParcelable.Param(id=3) Scope[] scopeArray, @SafeParcelable.Param(id=4) Integer n2, @SafeParcelable.Param(id=5) Integer n3, @SafeParcelable.Param(id=6) Account account) {
        this.zzal = n;
        this.zzqv = iBinder;
        this.zzqw = scopeArray;
        this.zzqx = n2;
        this.zzqy = n3;
        this.zzs = account;
    }

    @Deprecated
    public AuthAccountRequest(IAccountAccessor iAccountAccessor, Set<Scope> set) {
        this(3, iAccountAccessor.asBinder(), set.toArray(new Scope[set.size()]), null, null, null);
    }

    public AuthAccountRequest(Account account, Set<Scope> set) {
        this(3, null, set.toArray(new Scope[set.size()]), null, null, (Account)Preconditions.checkNotNull((Object)account));
    }

    public Account getAccount() {
        Account account = null;
        if (this.zzs != null) {
            account = this.zzs;
        } else if (this.zzqv != null) {
            account = AccountAccessor.getAccountBinderSafe((IAccountAccessor)IAccountAccessor.Stub.asInterface((IBinder)this.zzqv));
        }
        return account;
    }

    public Set<Scope> getScopes() {
        return new HashSet<Scope>(Arrays.asList(this.zzqw));
    }

    public AuthAccountRequest setOauthPolicy(@Nullable Integer n) {
        this.zzqx = n;
        return this;
    }

    @Nullable
    public Integer getOauthPolicy() {
        return this.zzqx;
    }

    public AuthAccountRequest setPolicyAction(@Nullable Integer n) {
        this.zzqy = n;
        return this;
    }

    @Nullable
    public Integer getPolicyAction() {
        return this.zzqy;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AuthAccountRequest authAccountRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)authAccountRequest.zzal);
        SafeParcelWriter.writeIBinder((Parcel)parcel2, (int)2, (IBinder)authAccountRequest.zzqv, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)3, (Parcelable[])authAccountRequest.zzqw, (int)n, (boolean)false);
        SafeParcelWriter.writeIntegerObject((Parcel)parcel2, (int)4, (Integer)authAccountRequest.zzqx, (boolean)false);
        SafeParcelWriter.writeIntegerObject((Parcel)parcel2, (int)5, (Integer)authAccountRequest.zzqy, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)6, (Parcelable)authAccountRequest.zzs, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

