/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.Context;
import android.os.DeadObjectException;
import android.os.IInterface;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.internal.Preconditions;

public abstract class BaseSimpleClient<T extends IInterface>
implements Api.SimpleClient<T> {
    private final Context mContext;
    private final Object mLock = new Object();
    private T zzrj = null;
    private int mState = 1;

    public BaseSimpleClient(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getService() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState == 5) {
                throw new DeadObjectException();
            }
            if (this.mState != 4) {
                throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
            }
            Preconditions.checkState((this.zzrj != null ? 1 : 0) != 0, (Object)"Client is connected but service is null");
            return this.zzrj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(int n, T t) {
        Object object = this.mLock;
        synchronized (object) {
            this.mState = n;
            this.zzrj = t;
            return;
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public Feature[] getRequiredFeatures() {
        return new Feature[0];
    }
}

