/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class GmsClientEventManager
implements Handler.Callback {
    private final GmsClientEventState zztf;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zztg = new ArrayList();
    @VisibleForTesting
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zzth = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zzti = new ArrayList();
    private volatile boolean zztj = false;
    private final AtomicInteger zztk = new AtomicInteger(0);
    private boolean zztl = false;
    private final Handler mHandler;
    private final Object mLock = new Object();

    public GmsClientEventManager(Looper looper, GmsClientEventState gmsClientEventState) {
        this.zztf = gmsClientEventState;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public final void disableCallbacks() {
        this.zztj = false;
        this.zztk.incrementAndGet();
    }

    public final void enableCallbacks() {
        this.zztj = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected final void onConnectionSuccess() {
        Object object = this.mLock;
        synchronized (object) {
            this.onConnectionSuccess(this.zztf.getConnectionHint());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void onConnectionSuccess(Bundle bundle) {
        Preconditions.checkState((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.mLock;
        synchronized (object) {
            Preconditions.checkState((!this.zztl ? 1 : 0) != 0);
            this.mHandler.removeMessages(1);
            this.zztl = true;
            Preconditions.checkState((this.zzth.size() == 0 ? 1 : 0) != 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zztg);
            int n = this.zztk.get();
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                GoogleApiClient.ConnectionCallbacks connectionCallbacks = arrayList2.get(i);
                GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
                if (!this.zztj || !this.zztf.isConnected() || this.zztk.get() != n) break;
                if (this.zzth.contains(connectionCallbacks2)) continue;
                connectionCallbacks2.onConnected(bundle);
            }
            this.zzth.clear();
            this.zztl = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void onUnintentionalDisconnection(int n) {
        Preconditions.checkState((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.mLock;
        synchronized (object) {
            this.zztl = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zztg);
            int n2 = this.zztk.get();
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = arrayList;
            int n3 = arrayList2.size();
            for (int i = 0; i < n3; ++i) {
                GoogleApiClient.ConnectionCallbacks connectionCallbacks = arrayList2.get(i);
                GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
                if (!this.zztj || this.zztk.get() != n2) break;
                if (!this.zztg.contains(connectionCallbacks2)) continue;
                connectionCallbacks2.onConnectionSuspended(n);
            }
            this.zzth.clear();
            this.zztl = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void onConnectionFailure(ConnectionResult connectionResult) {
        Preconditions.checkState((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zzti);
            int n = this.zztk.get();
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = arrayList2.get(i);
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
                if (this.zztj && this.zztk.get() == n) continue;
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            if (this.zztg.contains(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(62 + String.valueOf(string2).length()).append("registerConnectionCallbacks(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zztg.add(connectionCallbacks);
            }
        }
        if (this.zztf.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)connectionCallbacks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            return this.zztg.contains(connectionCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zztg.remove(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(52 + String.valueOf(string2).length()).append("unregisterConnectionCallbacks(): listener ").append(string2).append(" not found").toString());
            } else if (this.zztl) {
                this.zzth.add(connectionCallbacks);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzti.contains(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(67 + String.valueOf(string2).length()).append("registerConnectionFailedListener(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zzti.add(onConnectionFailedListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            return this.zzti.contains(onConnectionFailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzti.remove(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(57 + String.valueOf(string2).length()).append("unregisterConnectionFailedListener(): listener ").append(string2).append(" not found").toString());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleMessage(Message message) {
        if (message.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)message.obj;
            Object object = this.mLock;
            synchronized (object) {
                if (this.zztj && this.zztf.isConnected() && this.zztg.contains(connectionCallbacks)) {
                    Bundle bundle = this.zztf.getConnectionHint();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        int n = message.what;
        Log.wtf((String)"GmsClientEvents", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        return false;
    }

    public final boolean areCallbacksEnabled() {
        return this.zztj;
    }

    @VisibleForTesting
    public static interface GmsClientEventState {
        public boolean isConnected();

        public Bundle getConnectionHint();
    }
}

