/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.common.internal.AuthAccountRequest;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IResolveAccountCallbacks;
import com.google.android.gms.common.internal.ResolveAccountRequest;
import com.google.android.gms.internal.stable.zza;
import com.google.android.gms.internal.stable.zzb;
import com.google.android.gms.internal.stable.zzc;
import com.google.android.gms.signin.internal.CheckServerAuthResult;
import com.google.android.gms.signin.internal.ISignInCallbacks;
import com.google.android.gms.signin.internal.RecordConsentRequest;
import com.google.android.gms.signin.internal.SignInRequest;

public interface ISignInService
extends IInterface {
    public void authAccount(AuthAccountRequest var1, ISignInCallbacks var2) throws RemoteException;

    public void onCheckServerAuthorization(CheckServerAuthResult var1) throws RemoteException;

    public void onUploadServerAuthCode(boolean var1) throws RemoteException;

    public void resolveAccount(ResolveAccountRequest var1, IResolveAccountCallbacks var2) throws RemoteException;

    public void clearAccountFromSessionStore(int var1) throws RemoteException;

    public void saveAccountToSessionStore(int var1, Account var2, ISignInCallbacks var3) throws RemoteException;

    public void saveDefaultAccountToSharedPref(IAccountAccessor var1, int var2, boolean var3) throws RemoteException;

    public void recordConsent(RecordConsentRequest var1, ISignInCallbacks var2) throws RemoteException;

    public void getCurrentAccount(ISignInCallbacks var1) throws RemoteException;

    public void signIn(SignInRequest var1, ISignInCallbacks var2) throws RemoteException;

    public void setGamesHasBeenGreeted(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends zzb
    implements ISignInService {
        public Stub() {
            super("com.google.android.gms.signin.internal.ISignInService");
        }

        public static ISignInService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.signin.internal.ISignInService");
            if (iInterface instanceof ISignInService) {
                return (ISignInService)iInterface;
            }
            return new Proxy(iBinder);
        }

        protected boolean dispatchTransaction(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                case 2: {
                    AuthAccountRequest authAccountRequest = (AuthAccountRequest)zzc.zza((Parcel)parcel, AuthAccountRequest.CREATOR);
                    ISignInCallbacks iSignInCallbacks = ISignInCallbacks.Stub.asInterface(parcel.readStrongBinder());
                    this.authAccount(authAccountRequest, iSignInCallbacks);
                    break;
                }
                case 3: {
                    CheckServerAuthResult checkServerAuthResult = (CheckServerAuthResult)zzc.zza((Parcel)parcel, CheckServerAuthResult.CREATOR);
                    this.onCheckServerAuthorization(checkServerAuthResult);
                    break;
                }
                case 4: {
                    boolean bl = zzc.zza((Parcel)parcel);
                    this.onUploadServerAuthCode(bl);
                    break;
                }
                case 5: {
                    ResolveAccountRequest resolveAccountRequest = (ResolveAccountRequest)zzc.zza((Parcel)parcel, ResolveAccountRequest.CREATOR);
                    IResolveAccountCallbacks iResolveAccountCallbacks = IResolveAccountCallbacks.Stub.asInterface(parcel.readStrongBinder());
                    this.resolveAccount(resolveAccountRequest, iResolveAccountCallbacks);
                    break;
                }
                case 7: {
                    int n3 = parcel.readInt();
                    this.clearAccountFromSessionStore(n3);
                    break;
                }
                case 8: {
                    int n4 = parcel.readInt();
                    Account account = (Account)zzc.zza((Parcel)parcel, (Parcelable.Creator)Account.CREATOR);
                    ISignInCallbacks iSignInCallbacks = ISignInCallbacks.Stub.asInterface(parcel.readStrongBinder());
                    this.saveAccountToSessionStore(n4, account, iSignInCallbacks);
                    break;
                }
                case 9: {
                    IAccountAccessor iAccountAccessor = IAccountAccessor.Stub.asInterface((IBinder)parcel.readStrongBinder());
                    int n5 = parcel.readInt();
                    boolean bl = zzc.zza((Parcel)parcel);
                    this.saveDefaultAccountToSharedPref(iAccountAccessor, n5, bl);
                    break;
                }
                case 10: {
                    RecordConsentRequest recordConsentRequest = (RecordConsentRequest)zzc.zza((Parcel)parcel, RecordConsentRequest.CREATOR);
                    ISignInCallbacks iSignInCallbacks = ISignInCallbacks.Stub.asInterface(parcel.readStrongBinder());
                    this.recordConsent(recordConsentRequest, iSignInCallbacks);
                    break;
                }
                case 11: {
                    ISignInCallbacks iSignInCallbacks = ISignInCallbacks.Stub.asInterface(parcel.readStrongBinder());
                    this.getCurrentAccount(iSignInCallbacks);
                    break;
                }
                case 12: {
                    SignInRequest signInRequest = (SignInRequest)zzc.zza((Parcel)parcel, SignInRequest.CREATOR);
                    ISignInCallbacks iSignInCallbacks = ISignInCallbacks.Stub.asInterface(parcel.readStrongBinder());
                    this.signIn(signInRequest, iSignInCallbacks);
                    break;
                }
                case 13: {
                    boolean bl = zzc.zza((Parcel)parcel);
                    this.setGamesHasBeenGreeted(bl);
                    break;
                }
                default: {
                    return false;
                }
            }
            parcel2.writeNoException();
            return true;
        }

        public static class Proxy
        extends zza
        implements ISignInService {
            Proxy(IBinder iBinder) {
                super(iBinder, "com.google.android.gms.signin.internal.ISignInService");
            }

            @Override
            public void authAccount(AuthAccountRequest authAccountRequest, ISignInCallbacks iSignInCallbacks) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (Parcelable)authAccountRequest);
                zzc.zza((Parcel)parcel, (IInterface)iSignInCallbacks);
                this.transactAndReadExceptionReturnVoid(2, parcel);
            }

            @Override
            public void onCheckServerAuthorization(CheckServerAuthResult checkServerAuthResult) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (Parcelable)checkServerAuthResult);
                this.transactAndReadExceptionReturnVoid(3, parcel);
            }

            @Override
            public void onUploadServerAuthCode(boolean bl) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (boolean)bl);
                this.transactAndReadExceptionReturnVoid(4, parcel);
            }

            @Override
            public void resolveAccount(ResolveAccountRequest resolveAccountRequest, IResolveAccountCallbacks iResolveAccountCallbacks) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (Parcelable)resolveAccountRequest);
                zzc.zza((Parcel)parcel, (IInterface)iResolveAccountCallbacks);
                this.transactAndReadExceptionReturnVoid(5, parcel);
            }

            @Override
            public void clearAccountFromSessionStore(int n) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeInt(n);
                this.transactAndReadExceptionReturnVoid(7, parcel);
            }

            @Override
            public void saveAccountToSessionStore(int n, Account account, ISignInCallbacks iSignInCallbacks) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeInt(n);
                zzc.zza((Parcel)parcel, (Parcelable)account);
                zzc.zza((Parcel)parcel, (IInterface)iSignInCallbacks);
                this.transactAndReadExceptionReturnVoid(8, parcel);
            }

            @Override
            public void saveDefaultAccountToSharedPref(IAccountAccessor iAccountAccessor, int n, boolean bl) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (IInterface)iAccountAccessor);
                parcel.writeInt(n);
                zzc.zza((Parcel)parcel, (boolean)bl);
                this.transactAndReadExceptionReturnVoid(9, parcel);
            }

            @Override
            public void recordConsent(RecordConsentRequest recordConsentRequest, ISignInCallbacks iSignInCallbacks) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (Parcelable)recordConsentRequest);
                zzc.zza((Parcel)parcel, (IInterface)iSignInCallbacks);
                this.transactAndReadExceptionReturnVoid(10, parcel);
            }

            @Override
            public void getCurrentAccount(ISignInCallbacks iSignInCallbacks) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (IInterface)iSignInCallbacks);
                this.transactAndReadExceptionReturnVoid(11, parcel);
            }

            @Override
            public void signIn(SignInRequest signInRequest, ISignInCallbacks iSignInCallbacks) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (Parcelable)signInRequest);
                zzc.zza((Parcel)parcel, (IInterface)iSignInCallbacks);
                this.transactAndReadExceptionReturnVoid(12, parcel);
            }

            @Override
            public void setGamesHasBeenGreeted(boolean bl) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (boolean)bl);
                this.transactAndReadExceptionReturnVoid(13, parcel);
            }
        }
    }
}

