/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaaa;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zai;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zaw;
import com.google.android.gms.common.api.internal.zaz;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.util.concurrent.HandlerExecutor;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zax
implements zabs {
    private final Map<Api.AnyClientKey<?>, zaw<?>> zaet = new HashMap();
    private final Map<Api.AnyClientKey<?>, zaw<?>> zaeu = new HashMap();
    private final Map<Api<?>, Boolean> zaev;
    private final GoogleApiManager zabm;
    private final zaaw zaew;
    private final Lock zaen;
    private final Looper zabj;
    private final GoogleApiAvailabilityLight zaex;
    private final Condition zaey;
    private final ClientSettings zaes;
    private final boolean zaez;
    private final boolean zafa;
    private final Queue<BaseImplementation.ApiMethodImpl<?, ?>> zafb = new LinkedList();
    @GuardedBy(value="mLock")
    private boolean zafc;
    @GuardedBy(value="mLock")
    private Map<zai<?>, ConnectionResult> zafd;
    @GuardedBy(value="mLock")
    private Map<zai<?>, ConnectionResult> zafe;
    @GuardedBy(value="mLock")
    private zaaa zaff;
    @GuardedBy(value="mLock")
    private ConnectionResult zafg;

    public zax(Context context, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, ArrayList<zaq> arrayList, zaaw zaaw2, boolean bl) {
        this.zaen = lock;
        this.zabj = looper;
        this.zaey = lock.newCondition();
        this.zaex = googleApiAvailabilityLight;
        this.zaew = zaaw2;
        this.zaev = map2;
        this.zaes = clientSettings;
        this.zaez = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.getClientKey(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zaq> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zaq zaq2 = arrayList2.get(i);
            zaq zaq3 = zaq2;
            hashMap2.put(zaq3.mApi, zaq3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.AnyClientKey<?>, Api.Client> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.Client client = entry.getValue();
            if (client.requiresGooglePlayServices()) {
                bl4 = true;
                if (!this.zaev.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zaq zaq4 = (zaq)hashMap2.get(api);
            zaw zaw2 = new zaw(context, api, looper, client, zaq4, clientSettings, abstractClientBuilder);
            this.zaet.put(entry.getKey(), zaw2);
            if (!client.requiresSignIn()) continue;
            this.zaeu.put(entry.getKey(), zaw2);
        }
        this.zafa = bl4 && !bl3 && !bl2;
        this.zabm = GoogleApiManager.zabc();
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        if (this.zaez && this.zab(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zafb.add(t);
            return t;
        }
        this.zaew.zahe.zab(t);
        return this.zaet.get(t.getClientKey()).doRead(t);
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        Api.AnyClientKey<A> anyClientKey = t.getClientKey();
        if (this.zaez && this.zab(t)) {
            return t;
        }
        this.zaew.zahe.zab(t);
        return this.zaet.get(anyClientKey).doWrite(t);
    }

    private final <T extends BaseImplementation.ApiMethodImpl<? extends Result, ? extends Api.AnyClient>> boolean zab(@NonNull T t) {
        Api.AnyClientKey<? extends Api.AnyClient> anyClientKey = t.getClientKey();
        ConnectionResult connectionResult = this.zaa(anyClientKey);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.setFailedResult(new Status(4, null, this.zabm.zaa(this.zaet.get(anyClientKey).zak(), System.identityHashCode(this.zaew))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zaen.lock();
        try {
            if (this.zafc) {
                return;
            }
            this.zafc = true;
            this.zafd = null;
            this.zafe = null;
            this.zaff = null;
            this.zafg = null;
            this.zabm.zao();
            this.zabm.zaa(this.zaet.values()).addOnCompleteListener((Executor)new HandlerExecutor(this.zabj), (OnCompleteListener)new zaz(this, null));
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zaey.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zafg != null) {
            return this.zafg;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zaey.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zafg != null) {
            return this.zafg;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zaen.lock();
        try {
            this.zafc = false;
            this.zafd = null;
            this.zafe = null;
            if (this.zaff != null) {
                this.zaff.cancel();
                this.zaff = null;
            }
            this.zafg = null;
            while (!this.zafb.isEmpty()) {
                BaseImplementation.ApiMethodImpl<?, ?> apiMethodImpl = this.zafb.remove();
                apiMethodImpl.zaa(null);
                ((PendingResult)apiMethodImpl).cancel();
            }
            this.zaey.signalAll();
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zaa(api.getClientKey());
    }

    @Nullable
    private final ConnectionResult zaa(@NonNull Api.AnyClientKey<?> anyClientKey) {
        this.zaen.lock();
        try {
            zaw<?> zaw2 = this.zaet.get(anyClientKey);
            if (this.zafd != null && zaw2 != null) {
                ConnectionResult connectionResult = this.zafd.get(zaw2.zak());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        this.zaen.lock();
        try {
            boolean bl = this.zafd != null && this.zafg == null;
            return bl;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zaen.lock();
        try {
            boolean bl = this.zafd == null && this.zafc;
            return bl;
        }
        finally {
            this.zaen.unlock();
        }
    }

    private final boolean zaac() {
        this.zaen.lock();
        try {
            if (!this.zafc || !this.zaez) {
                return false;
            }
            for (Api.AnyClientKey<?> anyClientKey : this.zaeu.keySet()) {
                ConnectionResult connectionResult = this.zaa(anyClientKey);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        this.zaen.lock();
        try {
            if (this.zafc && !this.zaac()) {
                this.zabm.zao();
                this.zaff = new zaaa(this, signInConnectionListener);
                this.zabm.zaa(this.zaeu.values()).addOnCompleteListener((Executor)new HandlerExecutor(this.zabj), (OnCompleteListener)this.zaff);
                return true;
            }
            return false;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final void maybeSignOut() {
        this.zaen.lock();
        try {
            this.zabm.maybeSignOut();
            if (this.zaff != null) {
                this.zaff.cancel();
                this.zaff = null;
            }
            if (this.zafe == null) {
                this.zafe = new ArrayMap(this.zaeu.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zaw<?> zaw2 : this.zaeu.values()) {
                this.zafe.put(zaw2.zak(), connectionResult);
            }
            if (this.zafd != null) {
                this.zafd.putAll(this.zafe);
            }
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zaw() {
    }

    @GuardedBy(value="mLock")
    private final void zaad() {
        if (this.zaes == null) {
            this.zaew.zagz = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zaes.getRequiredScopes());
        Map<Api<?>, ClientSettings.OptionalApiSettings> map = this.zaes.getOptionalApiSettings();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).mScopes);
        }
        this.zaew.zagz = hashSet;
    }

    @GuardedBy(value="mLock")
    private final void zaae() {
        while (!this.zafb.isEmpty()) {
            this.execute(this.zafb.remove());
        }
        this.zaew.zab((Bundle)null);
    }

    private final boolean zaa(zaw<?> zaw2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zaev.get(zaw2.getApi()) != false && zaw2.zaab().requiresGooglePlayServices() && this.zaex.isUserResolvableError(connectionResult.getErrorCode());
    }

    @GuardedBy(value="mLock")
    @Nullable
    private final ConnectionResult zaaf() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zaw<?> zaw2 : this.zaet.values()) {
            int n3;
            Api api = zaw2.getApi();
            zai zai2 = zaw2.zak();
            ConnectionResult connectionResult3 = this.zafd.get(zai2);
            if (connectionResult3.isSuccess() || this.zaev.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zaex.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zaez) {
                n3 = api.zah().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zah().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zaa(zax zax2) {
        return zax2.zaen;
    }

    static /* synthetic */ boolean zab(zax zax2) {
        return zax2.zafc;
    }

    static /* synthetic */ Map zaa(zax zax2, Map map) {
        zax2.zafd = map;
        return zax2.zafd;
    }

    static /* synthetic */ Map zac(zax zax2) {
        return zax2.zaet;
    }

    static /* synthetic */ Map zad(zax zax2) {
        return zax2.zafd;
    }

    static /* synthetic */ boolean zae(zax zax2) {
        return zax2.zafa;
    }

    static /* synthetic */ boolean zaa(zax zax2, zaw zaw2, ConnectionResult connectionResult) {
        return zax2.zaa(zaw2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zaa(zax zax2, ConnectionResult connectionResult) {
        zax2.zafg = connectionResult;
        return zax2.zafg;
    }

    static /* synthetic */ ConnectionResult zaf(zax zax2) {
        return zax2.zaaf();
    }

    static /* synthetic */ Map zag(zax zax2) {
        return zax2.zafe;
    }

    static /* synthetic */ ConnectionResult zah(zax zax2) {
        return zax2.zafg;
    }

    static /* synthetic */ void zai(zax zax2) {
        zax2.zaad();
    }

    static /* synthetic */ void zaj(zax zax2) {
        zax2.zaae();
    }

    static /* synthetic */ boolean zaa(zax zax2, boolean bl) {
        zax2.zafc = false;
        return false;
    }

    static /* synthetic */ zaaw zak(zax zax2) {
        return zax2.zaew;
    }

    static /* synthetic */ Condition zal(zax zax2) {
        return zax2.zaey;
    }

    static /* synthetic */ Map zab(zax zax2, Map map) {
        zax2.zafe = map;
        return zax2.zafe;
    }

    static /* synthetic */ Map zam(zax zax2) {
        return zax2.zaeu;
    }
}

