/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.base.zal;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class GmsClientEventManager
implements Handler.Callback {
    private final GmsClientEventState zaok;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zaol = new ArrayList();
    @VisibleForTesting
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zaom = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zaon = new ArrayList();
    private volatile boolean zaoo = false;
    private final AtomicInteger zaop = new AtomicInteger(0);
    private boolean zaoq = false;
    private final Handler mHandler;
    private final Object mLock = new Object();

    public GmsClientEventManager(Looper looper, GmsClientEventState gmsClientEventState) {
        this.zaok = gmsClientEventState;
        this.mHandler = new zal(looper, this);
    }

    public final void disableCallbacks() {
        this.zaoo = false;
        this.zaop.incrementAndGet();
    }

    public final void enableCallbacks() {
        this.zaoo = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected final void onConnectionSuccess() {
        Object object = this.mLock;
        synchronized (object) {
            this.onConnectionSuccess(this.zaok.getConnectionHint());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void onConnectionSuccess(Bundle bundle) {
        Preconditions.checkState((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.mLock;
        synchronized (object) {
            Preconditions.checkState((!this.zaoq ? 1 : 0) != 0);
            this.mHandler.removeMessages(1);
            this.zaoq = true;
            Preconditions.checkState((this.zaom.size() == 0 ? 1 : 0) != 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zaol);
            int n = this.zaop.get();
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                GoogleApiClient.ConnectionCallbacks connectionCallbacks = arrayList2.get(i);
                GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
                if (!this.zaoo || !this.zaok.isConnected() || this.zaop.get() != n) break;
                if (this.zaom.contains(connectionCallbacks2)) continue;
                connectionCallbacks2.onConnected(bundle);
            }
            this.zaom.clear();
            this.zaoq = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void onUnintentionalDisconnection(int n) {
        Preconditions.checkState((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.mLock;
        synchronized (object) {
            this.zaoq = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zaol);
            int n2 = this.zaop.get();
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = arrayList;
            int n3 = arrayList2.size();
            for (int i = 0; i < n3; ++i) {
                GoogleApiClient.ConnectionCallbacks connectionCallbacks = arrayList2.get(i);
                GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
                if (!this.zaoo || this.zaop.get() != n2) break;
                if (!this.zaol.contains(connectionCallbacks2)) continue;
                connectionCallbacks2.onConnectionSuspended(n);
            }
            this.zaom.clear();
            this.zaoq = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void onConnectionFailure(ConnectionResult connectionResult) {
        Preconditions.checkState((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zaon);
            int n = this.zaop.get();
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = arrayList2.get(i);
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
                if (this.zaoo && this.zaop.get() == n) continue;
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            if (this.zaol.contains(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(62 + String.valueOf(string2).length()).append("registerConnectionCallbacks(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zaol.add(connectionCallbacks);
            }
        }
        if (this.zaok.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)connectionCallbacks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            return this.zaol.contains(connectionCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zaol.remove(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(52 + String.valueOf(string2).length()).append("unregisterConnectionCallbacks(): listener ").append(string2).append(" not found").toString());
            } else if (this.zaoq) {
                this.zaom.add(connectionCallbacks);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            if (this.zaon.contains(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(67 + String.valueOf(string2).length()).append("registerConnectionFailedListener(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zaon.add(onConnectionFailedListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            return this.zaon.contains(onConnectionFailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zaon.remove(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(57 + String.valueOf(string2).length()).append("unregisterConnectionFailedListener(): listener ").append(string2).append(" not found").toString());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleMessage(Message message) {
        if (message.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)message.obj;
            Object object = this.mLock;
            synchronized (object) {
                if (this.zaoo && this.zaok.isConnected() && this.zaol.contains(connectionCallbacks)) {
                    Bundle bundle = this.zaok.getConnectionHint();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        int n = message.what;
        Log.wtf((String)"GmsClientEvents", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        return false;
    }

    public final boolean areCallbacksEnabled() {
        return this.zaoo;
    }

    @VisibleForTesting
    public static interface GmsClientEventState {
        public boolean isConnected();

        public Bundle getConnectionHint();
    }
}

