/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.base;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.base.zag;
import com.google.android.gms.internal.base.zai;

public final class zae
extends Drawable
implements Drawable.Callback {
    private int zanh = 0;
    private long zani;
    private int mFrom;
    private int zanj;
    private int zank = 255;
    private int zanl;
    private int mAlpha = 0;
    private boolean zamz = true;
    private boolean zanm;
    private zai zann;
    private Drawable zano;
    private Drawable zanp;
    private boolean zanq;
    private boolean zanr;
    private boolean zans;
    private int zant;

    public zae(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zag.zacg();
        }
        this.zano = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zann.zanw |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zag.zacg();
        }
        this.zanp = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zann.zanw |= drawable3.getChangingConfigurations();
    }

    zae(zai zai2) {
        this.zann = new zai(zai2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zann.mChangingConfigurations | this.zann.zanw;
    }

    public final void setAlpha(int n) {
        if (this.mAlpha == this.zank) {
            this.mAlpha = n;
        }
        this.zank = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zano.setColorFilter(colorFilter);
        this.zanp.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zano.getIntrinsicWidth(), this.zanp.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zano.getIntrinsicHeight(), this.zanp.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zano.setBounds(rect);
        this.zanp.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zann.mChangingConfigurations = this.getChangingConfigurations();
            return this.zann;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zans) {
            this.zant = Drawable.resolveOpacity((int)this.zano.getOpacity(), (int)this.zanp.getOpacity());
            this.zans = true;
        }
        return this.zant;
    }

    private final boolean canConstantState() {
        if (!this.zanq) {
            this.zanr = this.zano.getConstantState() != null && this.zanp.getConstantState() != null;
            this.zanq = true;
        }
        return this.zanr;
    }

    public final Drawable mutate() {
        if (!this.zanm && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zano.mutate();
            this.zanp.mutate();
            this.zanm = true;
        }
        return this;
    }

    public final Drawable zacf() {
        return this.zanp;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zanj = this.zank;
        this.mAlpha = 0;
        this.zanl = 250;
        this.zanh = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zanh) {
            case 1: {
                this.zani = SystemClock.uptimeMillis();
                bl = false;
                this.zanh = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zani < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zani) / (float)this.zanl;
                bl = f >= 1.0f;
                if (bl) {
                    this.zanh = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.mAlpha = (int)(0.0f + (float)this.zanj * f2);
            }
        }
        int n = this.mAlpha;
        boolean bl2 = this.zamz;
        Drawable drawable2 = this.zano;
        Drawable drawable3 = this.zanp;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zank) {
                drawable3.setAlpha(this.zank);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zank - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zank);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zank);
        }
        this.invalidateSelf();
    }
}

