/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ConnectionErrorMessages;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.dynamic.zab;
import com.google.android.gms.dynamic.zac;
import com.google.android.gms.dynamic.zad;
import com.google.android.gms.dynamic.zae;
import com.google.android.gms.dynamic.zaf;
import com.google.android.gms.dynamic.zag;
import java.util.LinkedList;

@KeepForSdk
public abstract class DeferredLifecycleHelper<T extends LifecycleDelegate> {
    private T zarf;
    private Bundle zarg;
    private LinkedList<zaa> zarh;
    private final OnDelegateCreatedListener<T> zari = new com.google.android.gms.dynamic.zaa(this);

    @KeepForSdk
    public DeferredLifecycleHelper() {
    }

    @KeepForSdk
    public T getDelegate() {
        return this.zarf;
    }

    private final void zal(int n) {
        while (!this.zarh.isEmpty() && this.zarh.getLast().getState() >= n) {
            this.zarh.removeLast();
        }
    }

    private final void zaa(Bundle bundle, zaa zaa2) {
        if (this.zarf != null) {
            zaa2.zaa((LifecycleDelegate)this.zarf);
            return;
        }
        if (this.zarh == null) {
            this.zarh = new LinkedList();
        }
        this.zarh.add(zaa2);
        if (bundle != null) {
            if (this.zarg == null) {
                this.zarg = (Bundle)bundle.clone();
            } else {
                this.zarg.putAll(bundle);
            }
        }
        this.createDelegate(this.zari);
    }

    @KeepForSdk
    protected abstract void createDelegate(OnDelegateCreatedListener<T> var1);

    @KeepForSdk
    public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
        this.zaa(bundle2, new zab(this, activity, bundle, bundle2));
    }

    @KeepForSdk
    public void onCreate(Bundle bundle) {
        this.zaa(bundle, new zac(this, bundle));
    }

    @KeepForSdk
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        FrameLayout frameLayout = new FrameLayout(layoutInflater.getContext());
        this.zaa(bundle, new zad(this, frameLayout, layoutInflater, viewGroup, bundle));
        if (this.zarf == null) {
            this.handleGooglePlayUnavailable(frameLayout);
        }
        return frameLayout;
    }

    @KeepForSdk
    protected void handleGooglePlayUnavailable(FrameLayout frameLayout) {
        DeferredLifecycleHelper.showGooglePlayUnavailableMessage(frameLayout);
    }

    @KeepForSdk
    public static void showGooglePlayUnavailableMessage(FrameLayout frameLayout) {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        FrameLayout frameLayout2 = frameLayout;
        Context context = frameLayout2.getContext();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        String string2 = ConnectionErrorMessages.getErrorMessage(context, n);
        String string3 = ConnectionErrorMessages.getErrorDialogButtonMessage(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout2.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout2.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout2.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        Intent intent = googleApiAvailability.getErrorResolutionIntent(context, n, null);
        if (intent != null) {
            Button button = new Button(context);
            button.setId(16908313);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener((View.OnClickListener)new zae(context, intent));
        }
    }

    @KeepForSdk
    public void onStart() {
        this.zaa(null, new zaf(this));
    }

    @KeepForSdk
    public void onResume() {
        this.zaa(null, new zag(this));
    }

    @KeepForSdk
    public void onPause() {
        if (this.zarf != null) {
            this.zarf.onPause();
            return;
        }
        this.zal(5);
    }

    @KeepForSdk
    public void onStop() {
        if (this.zarf != null) {
            this.zarf.onStop();
            return;
        }
        this.zal(4);
    }

    @KeepForSdk
    public void onDestroyView() {
        if (this.zarf != null) {
            this.zarf.onDestroyView();
            return;
        }
        this.zal(2);
    }

    @KeepForSdk
    public void onDestroy() {
        if (this.zarf != null) {
            this.zarf.onDestroy();
            return;
        }
        this.zal(1);
    }

    @KeepForSdk
    public void onSaveInstanceState(Bundle bundle) {
        if (this.zarf != null) {
            this.zarf.onSaveInstanceState(bundle);
            return;
        }
        if (this.zarg != null) {
            bundle.putAll(this.zarg);
        }
    }

    @KeepForSdk
    public void onLowMemory() {
        if (this.zarf != null) {
            this.zarf.onLowMemory();
        }
    }

    static /* synthetic */ LifecycleDelegate zaa(DeferredLifecycleHelper deferredLifecycleHelper, LifecycleDelegate lifecycleDelegate) {
        deferredLifecycleHelper.zarf = lifecycleDelegate;
        return deferredLifecycleHelper.zarf;
    }

    static /* synthetic */ LinkedList zaa(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zarh;
    }

    static /* synthetic */ LifecycleDelegate zab(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zarf;
    }

    static /* synthetic */ Bundle zaa(DeferredLifecycleHelper deferredLifecycleHelper, Bundle bundle) {
        deferredLifecycleHelper.zarg = null;
        return null;
    }

    private static interface zaa {
        public int getState();

        public void zaa(LifecycleDelegate var1);
    }
}

