/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.text.TextUtils;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.internal.Preconditions;
import java.util.ArrayList;

public class AvailabilityException
extends Exception {
    private final ArrayMap<ApiKey<?>, ConnectionResult> zaba;

    public AvailabilityException(ArrayMap<ApiKey<?>, ConnectionResult> arrayMap) {
        this.zaba = arrayMap;
    }

    public ConnectionResult getConnectionResult(GoogleApi<? extends Api.ApiOptions> googleApi) {
        ApiKey<? extends Api.ApiOptions> apiKey = googleApi.getApiKey();
        Preconditions.checkArgument((this.zaba.get(apiKey) != null ? 1 : 0) != 0, (Object)"The given API was not part of the availability request.");
        return (ConnectionResult)this.zaba.get(apiKey);
    }

    public ConnectionResult getConnectionResult(HasApiKey<? extends Api.ApiOptions> hasApiKey) {
        ApiKey<? extends Api.ApiOptions> apiKey = hasApiKey.getApiKey();
        Preconditions.checkArgument((this.zaba.get(apiKey) != null ? 1 : 0) != 0, (Object)"The given API was not part of the availability request.");
        return (ConnectionResult)this.zaba.get(apiKey);
    }

    public final ArrayMap<ApiKey<?>, ConnectionResult> zaj() {
        return this.zaba;
    }

    @Override
    public String getMessage() {
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ApiKey apiKey : this.zaba.keySet()) {
            ConnectionResult connectionResult = (ConnectionResult)this.zaba.get((Object)apiKey);
            if (connectionResult.isSuccess()) {
                bl = false;
            }
            String string2 = apiKey.getApiName();
            String string3 = String.valueOf(connectionResult);
            arrayList.add(new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(": ").append(string3).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("None of the queried APIs are available. ");
        } else {
            stringBuilder.append("Some of the queried APIs are unavailable. ");
        }
        stringBuilder.append(TextUtils.join((CharSequence)"; ", arrayList));
        return stringBuilder.toString();
    }
}

