/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.BinderThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.zacd;
import com.google.android.gms.common.api.internal.zacf;
import com.google.android.gms.common.api.internal.zacg;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.zad;
import com.google.android.gms.signin.internal.zak;
import com.google.android.gms.signin.zab;
import com.google.android.gms.signin.zac;
import java.util.Set;

public final class zace
extends zad
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static Api.AbstractClientBuilder<? extends zac, SignInOptions> zakm = zab.zapv;
    private final Context mContext;
    private final Handler mHandler;
    private final Api.AbstractClientBuilder<? extends zac, SignInOptions> zaaw;
    private Set<Scope> mScopes;
    private ClientSettings zafa;
    private zac zagf;
    private zacf zakn;

    @WorkerThread
    public zace(Context context, Handler handler, @NonNull ClientSettings clientSettings) {
        this(context, handler, clientSettings, zakm);
    }

    @WorkerThread
    public zace(Context context, Handler handler, @NonNull ClientSettings clientSettings, Api.AbstractClientBuilder<? extends zac, SignInOptions> abstractClientBuilder) {
        this.mContext = context;
        this.mHandler = handler;
        this.zafa = (ClientSettings)Preconditions.checkNotNull((Object)clientSettings, (Object)"ClientSettings must not be null");
        this.mScopes = clientSettings.getRequiredScopes();
        this.zaaw = abstractClientBuilder;
    }

    @WorkerThread
    public final void zaa(zacf zacf2) {
        if (this.zagf != null) {
            this.zagf.disconnect();
        }
        this.zafa.setClientSessionId(System.identityHashCode(this));
        this.zagf = this.zaaw.buildClient(this.mContext, this.mHandler.getLooper(), this.zafa, this.zafa.getSignInOptions(), this, this);
        this.zakn = zacf2;
        if (this.mScopes == null || this.mScopes.isEmpty()) {
            this.mHandler.post((Runnable)new zacd(this));
            return;
        }
        this.zagf.connect();
    }

    public final zac zabo() {
        return this.zagf;
    }

    public final void zabq() {
        if (this.zagf != null) {
            this.zagf.disconnect();
        }
    }

    @Override
    @WorkerThread
    public final void onConnected(@Nullable Bundle bundle) {
        this.zagf.zaa(this);
    }

    @Override
    @WorkerThread
    public final void onConnectionSuspended(int n) {
        this.zagf.disconnect();
    }

    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        this.zakn.zag(connectionResult);
    }

    @Override
    @BinderThread
    public final void zab(zak zak2) {
        this.mHandler.post((Runnable)new zacg(this, zak2));
    }

    @WorkerThread
    private final void zac(zak zak2) {
        ConnectionResult connectionResult = zak2.getConnectionResult();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = zak2.zacv();
            ConnectionResult connectionResult2 = resolveAccountResponse.getConnectionResult();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"SignInCoordinator", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zakn.zag(connectionResult2);
                this.zagf.disconnect();
                return;
            }
            this.zakn.zaa(resolveAccountResponse.getAccountAccessor(), this.mScopes);
        } else {
            this.zakn.zag(connectionResult);
        }
        this.zagf.disconnect();
    }

    static /* synthetic */ zacf zaa(zace zace2) {
        return zace2.zakn;
    }

    static /* synthetic */ void zaa(zace zace2, zak zak2) {
        zace2.zac(zak2);
    }
}

