/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.api.internal.zas;
import com.google.android.gms.common.api.internal.zat;
import com.google.android.gms.common.api.internal.zau;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zar;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zac;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

final class zaq
implements zabr {
    private final Context mContext;
    private final zaaw zaeh;
    private final Looper zabl;
    private final zabe zaei;
    private final zabe zaej;
    private final Map<Api.AnyClientKey<?>, zabe> zaek;
    private final Set<SignInConnectionListener> zael = Collections.newSetFromMap(new WeakHashMap());
    private final Api.Client zaem;
    private Bundle zaen;
    private ConnectionResult zaeo = null;
    private ConnectionResult zaep = null;
    private boolean zaeq = false;
    private final Lock zaer;
    @GuardedBy(value="mLock")
    private int zaes = 0;

    public static zaq zaa(Context context, zaaw zaaw2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zac, SignInOptions> abstractClientBuilder, ArrayList<zap> arrayList) {
        Object object;
        Api.Client client = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.AnyClientKey<?>, Api.Client> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.providesSignIn()) {
                client = object;
            }
            if (object.requiresSignIn()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        Preconditions.checkState((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.AnyClientKey<?> anyClientKey = api.getClientKey();
            if (arrayMap2.containsKey(anyClientKey)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(anyClientKey)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zap>();
        ArrayList<zap> arrayList2 = new ArrayList<zap>();
        ArrayList<zap> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zap zap2 = arrayList3.get(i);
            zap zap3 = zap2;
            if (arrayMap5.containsKey(zap3.mApi)) {
                ((ArrayList)object).add(zap3);
                continue;
            }
            if (arrayMap.containsKey(zap3.mApi)) {
                arrayList2.add(zap3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zaq(context, zaaw2, lock, looper, googleApiAvailabilityLight, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap2, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap3, clientSettings, abstractClientBuilder, client, (ArrayList<zap>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zaq(Context context, zaaw zaaw2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, Map<Api.AnyClientKey<?>, Api.Client> map2, ClientSettings clientSettings, Api.AbstractClientBuilder<? extends zac, SignInOptions> abstractClientBuilder, Api.Client client, ArrayList<zap> arrayList, ArrayList<zap> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zaeh = zaaw2;
        this.zaer = lock;
        this.zabl = looper;
        this.zaem = client;
        this.zaei = new zabe(context, this.zaeh, lock, looper, googleApiAvailabilityLight, map2, null, map4, null, arrayList2, new zas(this, null));
        this.zaej = new zabe(context, this.zaeh, lock, looper, googleApiAvailabilityLight, map, clientSettings, map3, abstractClientBuilder, arrayList, new zau(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.AnyClientKey<?> anyClientKey : map2.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zaei);
        }
        for (Api.AnyClientKey<?> anyClientKey : map.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zaej);
        }
        this.zaek = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        if (this.zaa(t)) {
            if (this.zax()) {
                t.setFailedResult(new Status(4, null, this.zay()));
                return t;
            }
            return this.zaej.enqueue(t);
        }
        return this.zaei.enqueue(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        if (this.zaa(t)) {
            if (this.zax()) {
                t.setFailedResult(new Status(4, null, this.zay()));
                return t;
            }
            return this.zaej.execute(t);
        }
        return this.zaei.execute(t);
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zaek.get(api.getClientKey()).equals(this.zaej)) {
            if (this.zax()) {
                return new ConnectionResult(4, this.zay());
            }
            return this.zaej.getConnectionResult(api);
        }
        return this.zaei.getConnectionResult(api);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void connect() {
        this.zaes = 2;
        this.zaeq = false;
        zaq zaq2 = this;
        this.zaep = null;
        zaq2.zaeo = null;
        zaq2.zaei.connect();
        zaq2.zaej.connect();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final void disconnect() {
        this.zaep = null;
        this.zaeo = null;
        this.zaes = 0;
        this.zaei.disconnect();
        this.zaej.disconnect();
        this.zaw();
    }

    @Override
    public final boolean isConnected() {
        this.zaer.lock();
        try {
            boolean bl = this.zaei.isConnected() && (this.zaej.isConnected() || this.zax() || this.zaes == 1);
            return bl;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zaer.lock();
        try {
            boolean bl = this.zaes == 2;
            return bl;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        this.zaer.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zaej.isConnected()) {
                this.zael.add(signInConnectionListener);
                if (this.zaes == 0) {
                    this.zaes = 1;
                }
                this.zaep = null;
                this.zaej.connect();
                return true;
            }
        }
        finally {
            this.zaer.unlock();
        }
        return false;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zau() {
        this.zaei.zau();
        this.zaej.zau();
    }

    @Override
    public final void maybeSignOut() {
        this.zaer.lock();
        try {
            boolean bl = this.isConnecting();
            this.zaej.disconnect();
            this.zaep = new ConnectionResult(4);
            if (bl) {
                new zar(this.zabl).post(new zat(this));
            } else {
                this.zaw();
            }
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @GuardedBy(value="mLock")
    private final void zav() {
        if (zaq.zab(this.zaeo)) {
            if (zaq.zab(this.zaep) || this.zax()) {
                zaq zaq2 = this;
                switch (zaq2.zaes) {
                    case 2: {
                        zaq2.zaeh.zab(zaq2.zaen);
                    }
                    case 1: {
                        zaq2.zaw();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zaq2.zaes = 0;
                return;
            }
            if (this.zaep != null) {
                if (this.zaes == 1) {
                    this.zaw();
                    return;
                }
                this.zaa(this.zaep);
                this.zaei.disconnect();
                return;
            }
        } else {
            if (this.zaeo != null && zaq.zab(this.zaep)) {
                this.zaej.disconnect();
                this.zaa(this.zaeo);
                return;
            }
            if (this.zaeo != null && this.zaep != null) {
                ConnectionResult connectionResult = this.zaeo;
                if (this.zaej.zahw < this.zaei.zahw) {
                    connectionResult = this.zaep;
                }
                this.zaa(connectionResult);
            }
        }
    }

    @GuardedBy(value="mLock")
    private final void zaa(ConnectionResult connectionResult) {
        switch (this.zaes) {
            case 2: {
                this.zaeh.zac(connectionResult);
            }
            case 1: {
                this.zaw();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zaes = 0;
    }

    @GuardedBy(value="mLock")
    private final void zaw() {
        Iterator<SignInConnectionListener> iterator = this.zael.iterator();
        while (iterator.hasNext()) {
            iterator.next().onComplete();
        }
        this.zael.clear();
    }

    @GuardedBy(value="mLock")
    private final void zaa(int n, boolean bl) {
        this.zaeh.zab(n, bl);
        this.zaep = null;
        this.zaeo = null;
    }

    @GuardedBy(value="mLock")
    private final boolean zax() {
        return this.zaep != null && this.zaep.getErrorCode() == 4;
    }

    private final boolean zaa(BaseImplementation.ApiMethodImpl<? extends Result, ? extends Api.AnyClient> apiMethodImpl) {
        Api.AnyClientKey<? extends Api.AnyClient> anyClientKey = apiMethodImpl.getClientKey();
        Preconditions.checkArgument((boolean)this.zaek.containsKey(anyClientKey), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zaek.get(anyClientKey).equals(this.zaej);
    }

    @Nullable
    private final PendingIntent zay() {
        if (this.zaem == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zaeh), (Intent)this.zaem.getSignInIntent(), (int)0x8000000);
    }

    private final void zaa(Bundle bundle) {
        if (this.zaen == null) {
            this.zaen = bundle;
            return;
        }
        if (bundle != null) {
            this.zaen.putAll(bundle);
        }
    }

    private static boolean zab(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zaej.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zaei.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zaa(zaq zaq2) {
        return zaq2.zaer;
    }

    static /* synthetic */ void zab(zaq zaq2) {
        zaq2.zav();
    }

    static /* synthetic */ void zaa(zaq zaq2, Bundle bundle) {
        zaq2.zaa(bundle);
    }

    static /* synthetic */ ConnectionResult zaa(zaq zaq2, ConnectionResult connectionResult) {
        zaq2.zaeo = connectionResult;
        return zaq2.zaeo;
    }

    static /* synthetic */ boolean zac(zaq zaq2) {
        return zaq2.zaeq;
    }

    static /* synthetic */ ConnectionResult zad(zaq zaq2) {
        return zaq2.zaep;
    }

    static /* synthetic */ boolean zaa(zaq zaq2, boolean bl) {
        zaq2.zaeq = bl;
        return zaq2.zaeq;
    }

    static /* synthetic */ void zaa(zaq zaq2, int n, boolean bl) {
        zaq2.zaa(n, bl);
    }

    static /* synthetic */ zabe zae(zaq zaq2) {
        return zaq2.zaej;
    }

    static /* synthetic */ ConnectionResult zab(zaq zaq2, ConnectionResult connectionResult) {
        zaq2.zaep = connectionResult;
        return zaq2.zaep;
    }

    static /* synthetic */ zabe zaf(zaq zaq2) {
        return zaq2.zaei;
    }
}

