/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import androidx.collection.LruCache;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.internal.base.zaj;
import com.google.android.gms.internal.base.zan;
import com.google.android.gms.internal.base.zao;
import com.google.android.gms.internal.base.zar;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public final class ImageManager {
    private static final Object zamj = new Object();
    private static HashSet<Uri> zamk = new HashSet();
    private static ImageManager zaml;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zamm;
    private final zaa zamn;
    private final zaj zamo;
    private final Map<com.google.android.gms.common.images.zab, ImageReceiver> zamp;
    private final Map<Uri, ImageReceiver> zamq;
    private final Map<Uri, Long> zamr;

    public static ImageManager create(Context context) {
        Context context2 = context;
        if (zaml == null) {
            zaml = new ImageManager(context2, false);
        }
        return zaml;
    }

    private ImageManager(Context context, boolean bl) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new zar(Looper.getMainLooper());
        this.zamm = zan.zact().zaa(4, zao.zasg);
        this.zamn = null;
        this.zamo = new zaj();
        this.zamp = new HashMap<com.google.android.gms.common.images.zab, ImageReceiver>();
        this.zamq = new HashMap<Uri, ImageReceiver>();
        this.zamr = new HashMap<Uri, Long>();
    }

    public final void loadImage(ImageView imageView, Uri uri) {
        com.google.android.gms.common.images.zad zad2 = new com.google.android.gms.common.images.zad(imageView, uri);
        this.zaa(zad2);
    }

    public final void loadImage(ImageView imageView, int n) {
        com.google.android.gms.common.images.zad zad2 = new com.google.android.gms.common.images.zad(imageView, n);
        this.zaa(zad2);
    }

    public final void loadImage(ImageView imageView, Uri uri, int n) {
        com.google.android.gms.common.images.zad zad2 = new com.google.android.gms.common.images.zad(imageView, uri);
        new com.google.android.gms.common.images.zad(imageView, uri).zanb = n;
        this.zaa(zad2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        com.google.android.gms.common.images.zac zac2 = new com.google.android.gms.common.images.zac(onImageLoadedListener, uri);
        this.zaa(zac2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        com.google.android.gms.common.images.zac zac2 = new com.google.android.gms.common.images.zac(onImageLoadedListener, uri);
        new com.google.android.gms.common.images.zac(onImageLoadedListener, uri).zanb = n;
        this.zaa(zac2);
    }

    private final void zaa(com.google.android.gms.common.images.zab zab2) {
        Asserts.checkMainThread((String)"ImageManager.loadImage() must be called in the main thread");
        new zab(zab2).run();
    }

    private final Bitmap zaa(com.google.android.gms.common.images.zaa zaa2) {
        if (this.zamn == null) {
            return null;
        }
        return (Bitmap)this.zamn.get(zaa2);
    }

    private static final class zaa
    extends LruCache<com.google.android.gms.common.images.zaa, Bitmap> {
        protected final /* synthetic */ int sizeOf(Object object, Object object2) {
            Bitmap bitmap = (Bitmap)object2;
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected final /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, Object object3) {
            Bitmap bitmap = (Bitmap)object3;
            Bitmap bitmap2 = (Bitmap)object2;
            com.google.android.gms.common.images.zaa zaa2 = (com.google.android.gms.common.images.zaa)object;
            super.entryRemoved(bl, (Object)zaa2, (Object)bitmap2, (Object)bitmap);
        }
    }

    private final class zad
    implements Runnable {
        private final Uri zamt;
        private final Bitmap mBitmap;
        private final CountDownLatch zads;
        private boolean zamy;

        public zad(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.zamt = uri;
            this.mBitmap = bitmap;
            this.zamy = bl;
            this.zads = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            Asserts.checkMainThread((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.zamn != null) {
                if (this.zamy) {
                    ImageManager.this.zamn.evictAll();
                    System.gc();
                    this.zamy = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.zamn.put(new com.google.android.gms.common.images.zaa(this.zamt), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.zamq.remove(this.zamt))) != null) {
                boolean bl3 = bl;
                ImageReceiver imageReceiver2 = imageReceiver;
                zad zad2 = this;
                ArrayList arrayList = imageReceiver2.zamu;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.images.zab zab2 = (com.google.android.gms.common.images.zab)arrayList.get(i);
                    if (bl3) {
                        zab2.zaa(zad2.ImageManager.this.mContext, zad2.mBitmap, false);
                    } else {
                        zad2.ImageManager.this.zamr.put(zad2.zamt, SystemClock.elapsedRealtime());
                        zab2.zaa(zad2.ImageManager.this.mContext, zad2.ImageManager.this.zamo, false);
                    }
                    if (zab2 instanceof com.google.android.gms.common.images.zac) continue;
                    zad2.ImageManager.this.zamp.remove(zab2);
                }
            }
            this.zads.countDown();
            Object object = zamj;
            synchronized (object) {
                zamk.remove(this.zamt);
                return;
            }
        }
    }

    private final class zac
    implements Runnable {
        private final Uri zamt;
        private final ParcelFileDescriptor zamx;

        public zac(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.zamt = uri;
            this.zamx = parcelFileDescriptor;
        }

        @Override
        public final void run() {
            Asserts.checkNotMainThread((String)"LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zamx != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zamx.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string2 = String.valueOf(this.zamt);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string2).length()).append("OOM while loading bitmap for uri: ").append(string2).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zamx.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zad(this.zamt, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                String string3 = String.valueOf(this.zamt);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string3).length()).append("Latch interrupted while posting ").append(string3).toString());
                return;
            }
        }
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri zamt;
        private final ArrayList<com.google.android.gms.common.images.zab> zamu;

        ImageReceiver(Uri uri) {
            super((Handler)new zar(Looper.getMainLooper()));
            this.zamt = uri;
            this.zamu = new ArrayList();
        }

        public final void zab(com.google.android.gms.common.images.zab zab2) {
            Asserts.checkMainThread((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zamu.add(zab2);
        }

        public final void zac(com.google.android.gms.common.images.zab zab2) {
            Asserts.checkMainThread((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zamu.remove(zab2);
        }

        public final void zacc() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.zamt);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public final void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.zamm.execute(new zac(this.zamt, parcelFileDescriptor));
        }
    }

    private final class zab
    implements Runnable {
        private final com.google.android.gms.common.images.zab zamw;

        public zab(com.google.android.gms.common.images.zab zab2) {
            this.zamw = zab2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Asserts.checkMainThread((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.zamp.get(this.zamw));
            if (imageReceiver != null) {
                ImageManager.this.zamp.remove(this.zamw);
                imageReceiver.zac(this.zamw);
            }
            com.google.android.gms.common.images.zaa zaa2 = this.zamw.zamz;
            if (zaa2.uri == null) {
                this.zamw.zaa(ImageManager.this.mContext, ImageManager.this.zamo, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zaa(zaa2);
            if (bitmap != null) {
                this.zamw.zaa(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.zamr.get(zaa2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zamw.zaa(ImageManager.this.mContext, ImageManager.this.zamo, true);
                    return;
                }
                ImageManager.this.zamr.remove(zaa2.uri);
            }
            this.zamw.zaa(ImageManager.this.mContext, ImageManager.this.zamo);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.zamq.get(zaa2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zaa2.uri);
                ImageManager.this.zamq.put(zaa2.uri, imageReceiver);
            }
            imageReceiver.zab(this.zamw);
            if (!(this.zamw instanceof com.google.android.gms.common.images.zac)) {
                ImageManager.this.zamp.put(this.zamw, imageReceiver);
            }
            Object object = zamj;
            synchronized (object) {
                if (!zamk.contains(zaa2.uri)) {
                    zamk.add(zaa2.uri);
                    imageReceiver.zacc();
                }
                return;
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

