/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zabc;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabf;
import com.google.android.gms.common.api.internal.zabh;
import com.google.android.gms.common.api.internal.zabj;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zacc;
import com.google.android.gms.common.api.internal.zacd;
import com.google.android.gms.common.api.internal.zad;
import com.google.android.gms.common.api.internal.zae;
import com.google.android.gms.common.api.internal.zaf;
import com.google.android.gms.common.api.internal.zag;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zaj;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.api.internal.zav;
import com.google.android.gms.common.api.internal.zay;
import com.google.android.gms.common.api.internal.zaz;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zal;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;

@KeepForSdk
public class GoogleApiManager
implements Handler.Callback {
    public static final Status zaa = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zab = new Status(4, "The user must be signed in to make this API call.");
    private long zac = 5000L;
    private long zad = 120000L;
    private long zae = 10000L;
    private static final Object zaf = new Object();
    @GuardedBy(value="lock")
    @Nullable
    private static GoogleApiManager zag;
    private final Context zah;
    private final GoogleApiAvailability zai;
    private final zal zaj;
    private final AtomicInteger zak = new AtomicInteger(1);
    private final AtomicInteger zal = new AtomicInteger(0);
    private final Map<ApiKey<?>, zaa<?>> zam = new ConcurrentHashMap(5, 0.75f, 1);
    @GuardedBy(value="lock")
    @Nullable
    private zay zan = null;
    @GuardedBy(value="lock")
    private final Set<ApiKey<?>> zao = new ArraySet();
    private final Set<ApiKey<?>> zap = new ArraySet();
    @NotOnlyInitialized
    private final Handler zaq;
    private volatile boolean zar = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleApiManager zaa(Context context) {
        Object object = zaf;
        synchronized (object) {
            if (zag == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zag = new GoogleApiManager(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleApiManager zaa() {
        Object object = zaf;
        synchronized (object) {
            Preconditions.checkNotNull((Object)zag, (Object)"Must guarantee manager is non-null before using getInstance");
            return zag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void reportSignOut() {
        Object object = zaf;
        synchronized (object) {
            if (zag != null) {
                GoogleApiManager googleApiManager = zag;
                googleApiManager.zal.incrementAndGet();
                googleApiManager.zaq.sendMessageAtFrontOfQueue(googleApiManager.zaq.obtainMessage(10));
            }
            return;
        }
    }

    @KeepForSdk
    private GoogleApiManager(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.zah = context;
        this.zaq = new com.google.android.gms.internal.base.zap(looper, this);
        this.zai = googleApiAvailability;
        this.zaj = new zal(googleApiAvailability);
        if (DeviceProperties.isAuto((Context)context)) {
            this.zar = false;
        }
        this.zaq.sendMessage(this.zaq.obtainMessage(6));
    }

    public final int zab() {
        return this.zak.getAndIncrement();
    }

    public final void zaa(@UnknownInitialization GoogleApi<?> googleApi) {
        this.zaq.sendMessage(this.zaq.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final zaa<?> zac(GoogleApi<?> googleApi) {
        ApiKey<?> apiKey = googleApi.getApiKey();
        zaa<?> zaa2 = this.zam.get(apiKey);
        if (zaa2 == null) {
            zaa2 = new zaa(googleApi);
            this.zam.put(apiKey, zaa2);
        }
        if (zaa2.zak()) {
            this.zap.add(apiKey);
        }
        zaa2.zai();
        return zaa2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(@NonNull zay zay2) {
        Object object = zaf;
        synchronized (object) {
            if (this.zan != zay2) {
                this.zan = zay2;
                this.zao.clear();
            }
            this.zao.addAll((Collection<ApiKey<?>>)zay2.zac());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zab(@NonNull zay zay2) {
        Object object = zaf;
        synchronized (object) {
            if (this.zan == zay2) {
                this.zan = null;
                this.zao.clear();
            }
            return;
        }
    }

    public final Task<Map<ApiKey<?>, String>> zaa(Iterable<? extends HasApiKey<?>> iterable) {
        zaj zaj2 = new zaj(iterable);
        this.zaq.sendMessage(this.zaq.obtainMessage(2, (Object)zaj2));
        return zaj2.zab();
    }

    public final void zac() {
        this.zaq.sendMessage(this.zaq.obtainMessage(3));
    }

    public final Task<Boolean> zab(GoogleApi<?> googleApi) {
        zaz zaz2 = new zaz(googleApi.getApiKey());
        this.zaq.sendMessage(this.zaq.obtainMessage(14, (Object)zaz2));
        return zaz2.zab().getTask();
    }

    public final <O extends Api.ApiOptions> void zaa(GoogleApi<O> googleApi, int n, BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient> apiMethodImpl) {
        zaf<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>> zaf2 = new zaf<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>>(n, apiMethodImpl);
        this.zaq.sendMessage(this.zaq.obtainMessage(4, (Object)new zabr(zaf2, this.zal.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, ResultT> void zaa(GoogleApi<O> googleApi, int n, TaskApiCall<Api.AnyClient, ResultT> taskApiCall, TaskCompletionSource<ResultT> taskCompletionSource, StatusExceptionMapper statusExceptionMapper) {
        zah<ResultT> zah2 = new zah<ResultT>(n, taskApiCall, taskCompletionSource, statusExceptionMapper);
        this.zaq.sendMessage(this.zaq.obtainMessage(4, (Object)new zabr(zah2, this.zal.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zaa(@NonNull GoogleApi<O> googleApi, @NonNull RegisterListenerMethod<Api.AnyClient, ?> registerListenerMethod, @NonNull UnregisterListenerMethod<Api.AnyClient, ?> unregisterListenerMethod, @NonNull Runnable runnable) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zae zae2 = new zae(new zabs(registerListenerMethod, unregisterListenerMethod, runnable), (TaskCompletionSource<Void>)taskCompletionSource);
        this.zaq.sendMessage(this.zaq.obtainMessage(8, (Object)new zabr(zae2, this.zal.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Boolean> zaa(@NonNull GoogleApi<O> googleApi, @NonNull ListenerHolder.ListenerKey<?> listenerKey) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zag zag2 = new zag(listenerKey, (TaskCompletionSource<Boolean>)taskCompletionSource);
        this.zaq.sendMessage(this.zaq.obtainMessage(13, (Object)new zabr(zag2, this.zal.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                GoogleApiManager googleApiManager = this;
                this.zae = bl ? 10000L : 300000L;
                googleApiManager.zaq.removeMessages(12);
                for (ApiKey<?> apiKey : googleApiManager.zam.keySet()) {
                    googleApiManager.zaq.sendMessageDelayed(googleApiManager.zaq.obtainMessage(12, apiKey), googleApiManager.zae);
                }
                break;
            }
            case 2: {
                zaj zaj2 = (zaj)message.obj;
                GoogleApiManager googleApiManager = this;
                for (ApiKey<?> apiKey : zaj2.zaa()) {
                    ConnectionResult connectionResult;
                    zaa<?> zaa2 = googleApiManager.zam.get(apiKey);
                    if (zaa2 == null) {
                        connectionResult = new ConnectionResult(13);
                        zaj2.zaa(apiKey, connectionResult, null);
                        break block0;
                    }
                    if (zaa2.zaj()) {
                        zaj2.zaa(apiKey, ConnectionResult.RESULT_SUCCESS, zaa2.zab().getEndpointPackageName());
                        continue;
                    }
                    connectionResult = zaa2.zae();
                    if (connectionResult != null) {
                        zaj2.zaa(apiKey, connectionResult, null);
                        continue;
                    }
                    zaa2.zaa(zaj2);
                    zaa2.zai();
                }
                break;
            }
            case 3: {
                for (zaa<?> zaa3 : this.zam.values()) {
                    zaa3.zad();
                    zaa3.zai();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zabr zabr2 = (zabr)message.obj;
                GoogleApiManager googleApiManager = this;
                zaa<?> zaa4 = googleApiManager.zam.get(zabr2.zac.getApiKey());
                if (zaa4 == null) {
                    zaa4 = googleApiManager.zac(zabr2.zac);
                }
                if (zaa4.zak() && googleApiManager.zal.get() != zabr2.zab) {
                    zabr2.zaa.zaa(zaa);
                    zaa4.zaa();
                    break;
                }
                zaa4.zaa(zabr2.zaa);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                GoogleApiManager googleApiManager = this;
                zaa<?> zaa5 = null;
                for (zaa<?> zaa6 : googleApiManager.zam.values()) {
                    if (zaa6.zal() != n) continue;
                    zaa5 = zaa6;
                    break;
                }
                if (zaa5 != null) {
                    zaa<?> zaa6;
                    String string2 = googleApiManager.zai.getErrorString(connectionResult.getErrorCode());
                    zaa6 = connectionResult.getErrorMessage();
                    ((zaa)zaa5).zaa(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zaa6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zaa6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                GoogleApiManager googleApiManager = this;
                if (!(googleApiManager.zah.getApplicationContext() instanceof Application)) break;
                BackgroundDetector.initialize((Application)((Application)googleApiManager.zah.getApplicationContext()));
                BackgroundDetector.getInstance().addListener((BackgroundDetector.BackgroundStateChangeListener)new zabc(googleApiManager));
                if (BackgroundDetector.getInstance().readCurrentStateIfPossible(true)) break;
                googleApiManager.zae = 300000L;
                break;
            }
            case 7: {
                this.zac((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zam.containsKey(message.obj)) break;
                this.zam.get(message.obj).zaf();
                break;
            }
            case 10: {
                GoogleApiManager googleApiManager = this;
                for (ApiKey<?> apiKey : googleApiManager.zap) {
                    zaa<?> zaa7 = googleApiManager.zam.remove(apiKey);
                    if (zaa7 == null) continue;
                    zaa7.zaa();
                }
                googleApiManager.zap.clear();
                break;
            }
            case 11: {
                if (!this.zam.containsKey(message.obj)) break;
                this.zam.get(message.obj).zag();
                break;
            }
            case 12: {
                if (!this.zam.containsKey(message.obj)) break;
                this.zam.get(message.obj).zah();
                break;
            }
            case 14: {
                zaz zaz2 = (zaz)message.obj;
                GoogleApiManager googleApiManager = this;
                ApiKey<?> apiKey = zaz2.zaa();
                if (!googleApiManager.zam.containsKey(apiKey)) {
                    zaz2.zab().setResult((Object)false);
                    break;
                }
                boolean bl = ((zaa)googleApiManager.zam.get(apiKey)).zaa(false);
                zaz2.zab().setResult((Object)bl);
                break;
            }
            case 15: {
                zac zac2 = (zac)message.obj;
                if (!this.zam.containsKey(zac2.zaa)) break;
                ((zaa)this.zam.get(zac2.zaa)).zaa(zac2);
                break;
            }
            case 16: {
                zac zac3 = (zac)message.obj;
                if (!this.zam.containsKey(zac3.zaa)) break;
                ((zaa)this.zam.get(zac3.zaa)).zab(zac3);
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final boolean zaa(ConnectionResult connectionResult, int n) {
        return this.zai.zaa(this.zah, connectionResult, n);
    }

    public final void zab(ConnectionResult connectionResult, int n) {
        if (!this.zaa(connectionResult, n)) {
            this.zaq.sendMessage(this.zaq.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    private static final class zac {
        private final ApiKey<?> zaa;
        private final Feature zab;

        private zac(ApiKey<?> apiKey, Feature feature) {
            this.zaa = apiKey;
            this.zab = feature;
        }

        public final boolean equals(@Nullable Object object) {
            if (object != null && object instanceof zac) {
                zac zac2 = (zac)object;
                return Objects.equal(this.zaa, zac2.zaa) && Objects.equal((Object)this.zab, (Object)zac2.zab);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zaa, this.zab});
        }

        public final String toString() {
            return Objects.toStringHelper((Object)this).add("key", this.zaa).add("feature", (Object)this.zab).toString();
        }

        /* synthetic */ zac(ApiKey apiKey, Feature feature, zabc zabc2) {
            this(apiKey, feature);
        }
    }

    private final class zab
    implements zacd,
    BaseGmsClient.ConnectionProgressReportCallbacks {
        private final Api.Client zab;
        private final ApiKey<?> zac;
        @Nullable
        private IAccountAccessor zad = null;
        @Nullable
        private Set<Scope> zae = null;
        private boolean zaf = false;

        public zab(Api.Client client, ApiKey<?> apiKey) {
            this.zab = client;
            this.zac = apiKey;
        }

        public final void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            GoogleApiManager.this.zaq.post((Runnable)new zabj(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void zaa(ConnectionResult connectionResult) {
            zaa zaa2 = (zaa)GoogleApiManager.this.zam.get(this.zac);
            if (zaa2 != null) {
                zaa2.zaa(connectionResult);
            }
        }

        @Override
        @WorkerThread
        public final void zaa(@Nullable IAccountAccessor iAccountAccessor, @Nullable Set<Scope> set) {
            if (iAccountAccessor == null || set == null) {
                Log.wtf((String)"GoogleApiManager", (String)"Received null response from onSignInSuccess", (Throwable)new Exception());
                this.zaa(new ConnectionResult(4));
                return;
            }
            this.zad = iAccountAccessor;
            this.zae = set;
            this.zaa();
        }

        @WorkerThread
        private final void zaa() {
            if (this.zaf && this.zad != null) {
                this.zab.getRemoteService(this.zad, this.zae);
            }
        }

        static /* synthetic */ ApiKey zaa(zab zab2) {
            return zab2.zac;
        }

        static /* synthetic */ boolean zaa(zab zab2, boolean bl) {
            zab2.zaf = true;
            return true;
        }

        static /* synthetic */ Api.Client zab(zab zab2) {
            return zab2.zab;
        }

        static /* synthetic */ void zac(zab zab2) {
            zab2.zaa();
        }
    }

    public final class zaa<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener,
    zap {
        private final Queue<com.google.android.gms.common.api.internal.zab> zab = new LinkedList<com.google.android.gms.common.api.internal.zab>();
        @NotOnlyInitialized
        private final Api.Client zac;
        private final Api.AnyClient zad;
        private final ApiKey<O> zae;
        private final zav zaf;
        private final Set<zaj> zag = new HashSet<zaj>();
        private final Map<ListenerHolder.ListenerKey<?>, zabs> zah = new HashMap();
        private final int zai;
        @Nullable
        private final zacc zaj;
        private boolean zak;
        private final List<zac> zal = new ArrayList<zac>();
        @Nullable
        private ConnectionResult zam = null;

        @WorkerThread
        public zaa(GoogleApi<O> googleApi) {
            this.zac = googleApi.zaa(GoogleApiManager.this.zaq.getLooper(), this);
            if (this.zac instanceof com.google.android.gms.common.internal.zaz) {
                com.google.android.gms.common.internal.zaz cfr_ignored_0 = (com.google.android.gms.common.internal.zaz)this.zac;
                this.zad = com.google.android.gms.common.internal.zaz.zaa();
            } else {
                this.zad = this.zac;
            }
            this.zae = googleApi.getApiKey();
            this.zaf = new zav();
            this.zai = googleApi.zaa();
            if (this.zac.requiresSignIn()) {
                this.zaj = googleApi.zaa(GoogleApiManager.this.zah, GoogleApiManager.this.zaq);
                return;
            }
            this.zaj = null;
        }

        @Override
        public final void onConnected(@Nullable Bundle bundle) {
            if (Looper.myLooper() == GoogleApiManager.this.zaq.getLooper()) {
                this.zam();
                return;
            }
            GoogleApiManager.this.zaq.post((Runnable)new zabd(this));
        }

        @WorkerThread
        private final void zam() {
            this.zad();
            this.zac(ConnectionResult.RESULT_SUCCESS);
            this.zao();
            Iterator<zabs> iterator = this.zah.values().iterator();
            while (iterator.hasNext()) {
                zabs zabs2 = iterator.next();
                if (this.zaa(zabs2.zaa.getRequiredFeatures()) != null) {
                    iterator.remove();
                    continue;
                }
                try {
                    zabs2.zaa.registerListener(this.zad, (TaskCompletionSource<Void>)new TaskCompletionSource());
                }
                catch (DeadObjectException deadObjectException) {
                    this.onConnectionSuspended(3);
                    this.zac.disconnect("DeadObjectException thrown while calling register listener method.");
                    break;
                }
                catch (RemoteException remoteException) {
                    iterator.remove();
                }
            }
            this.zan();
            this.zap();
        }

        @Override
        public final void onConnectionSuspended(int n) {
            if (Looper.myLooper() == GoogleApiManager.this.zaq.getLooper()) {
                this.zaa(n);
                return;
            }
            GoogleApiManager.this.zaq.post((Runnable)new zabf(this, n));
        }

        @WorkerThread
        private final void zaa(int n) {
            this.zad();
            this.zak = true;
            this.zaf.zaa(n, this.zac.getLastDisconnectMessage());
            GoogleApiManager.this.zaq.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zaq, (int)9, this.zae), GoogleApiManager.this.zac);
            GoogleApiManager.this.zaq.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zaq, (int)11, this.zae), GoogleApiManager.this.zad);
            GoogleApiManager.this.zaj.zaa();
            Iterator<zabs> iterator = this.zah.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().zac.run();
            }
        }

        @WorkerThread
        public final void zaa(@NonNull ConnectionResult connectionResult) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            String string2 = this.zad.getClass().getName();
            String string3 = String.valueOf(connectionResult);
            this.zac.disconnect(new StringBuilder(25 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("onSignInFailed for ").append(string2).append(" with ").append(string3).toString());
            this.onConnectionFailed(connectionResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private final boolean zab(@NonNull ConnectionResult connectionResult) {
            Object object = zaf;
            synchronized (object) {
                if (GoogleApiManager.this.zan != null && GoogleApiManager.this.zao.contains(this.zae)) {
                    GoogleApiManager.this.zan.zab(connectionResult, this.zai);
                    return true;
                }
                return false;
            }
        }

        @Override
        public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
            if (Looper.myLooper() == GoogleApiManager.this.zaq.getLooper()) {
                this.onConnectionFailed(connectionResult);
                return;
            }
            GoogleApiManager.this.zaq.post((Runnable)new zabe(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            this.zaa(connectionResult, null);
        }

        @WorkerThread
        private final void zaa(@NonNull ConnectionResult connectionResult, @Nullable Exception exception) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            if (this.zaj != null) {
                this.zaj.zaa();
            }
            this.zad();
            GoogleApiManager.this.zaj.zaa();
            this.zac(connectionResult);
            if (connectionResult.getErrorCode() == 4) {
                this.zaa(zab);
                return;
            }
            if (this.zab.isEmpty()) {
                this.zam = connectionResult;
                return;
            }
            if (exception != null) {
                Exception exception2 = exception;
                zaa zaa2 = this;
                Preconditions.checkHandlerThread((Handler)zaa2.GoogleApiManager.this.zaq);
                zaa2.zaa(null, exception2, false);
                return;
            }
            if (!GoogleApiManager.this.zar) {
                this.zaa(this.zad(connectionResult));
                return;
            }
            this.zaa(this.zad(connectionResult), null, true);
            if (this.zab.isEmpty()) {
                return;
            }
            if (this.zab(connectionResult)) {
                return;
            }
            if (!GoogleApiManager.this.zaa(connectionResult, this.zai)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.zak = true;
                }
                if (this.zak) {
                    GoogleApiManager.this.zaq.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zaq, (int)9, this.zae), GoogleApiManager.this.zac);
                    return;
                }
                this.zaa(this.zad(connectionResult));
            }
        }

        @WorkerThread
        private final void zan() {
            ArrayList<com.google.android.gms.common.api.internal.zab> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zab>(this.zab);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.api.internal.zab zab2 = arrayList.get(i);
                com.google.android.gms.common.api.internal.zab zab3 = zab2;
                if (!this.zac.isConnected()) break;
                if (!this.zab(zab3)) continue;
                this.zab.remove(zab3);
            }
        }

        @WorkerThread
        public final void zaa(com.google.android.gms.common.api.internal.zab zab2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            if (this.zac.isConnected()) {
                if (this.zab(zab2)) {
                    this.zap();
                    return;
                }
                this.zab.add(zab2);
                return;
            }
            this.zab.add(zab2);
            if (this.zam != null && this.zam.hasResolution()) {
                this.onConnectionFailed(this.zam);
                return;
            }
            this.zai();
        }

        @WorkerThread
        public final void zaa() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            this.zaa(zaa);
            this.zaf.zab();
            for (ListenerHolder.ListenerKey listenerKey : this.zah.keySet().toArray(new ListenerHolder.ListenerKey[0])) {
                this.zaa(new zag(listenerKey, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
            }
            this.zac(new ConnectionResult(4));
            if (this.zac.isConnected()) {
                this.zac.onUserSignOut(new zabh(this));
            }
        }

        public final Api.Client zab() {
            return this.zac;
        }

        public final Map<ListenerHolder.ListenerKey<?>, zabs> zac() {
            return this.zah;
        }

        @WorkerThread
        public final void zad() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            this.zam = null;
        }

        @WorkerThread
        @Nullable
        public final ConnectionResult zae() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            return this.zam;
        }

        @WorkerThread
        private final boolean zab(com.google.android.gms.common.api.internal.zab zab2) {
            if (!(zab2 instanceof zad)) {
                this.zac(zab2);
                return true;
            }
            zad zad2 = (zad)zab2;
            Feature feature = this.zaa(zad2.zac(this));
            if (feature == null) {
                this.zac(zab2);
                return true;
            }
            String string2 = this.zad.getClass().getName();
            String string3 = feature.getName();
            long l = feature.getVersion();
            Log.w((String)"GoogleApiManager", (String)new StringBuilder(77 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" could not execute call because it requires feature (").append(string3).append(", ").append(l).append(").").toString());
            if (GoogleApiManager.this.zar && zad2.zad(this)) {
                Feature feature2 = feature;
                zaa zaa2 = this;
                zac zac2 = new zac(zaa2.zae, feature2, null);
                int n = zaa2.zal.indexOf(zac2);
                if (n >= 0) {
                    zac zac3 = zaa2.zal.get(n);
                    zaa2.GoogleApiManager.this.zaq.removeMessages(15, (Object)zac3);
                    zaa2.GoogleApiManager.this.zaq.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.zaq, (int)15, (Object)zac3), zaa2.GoogleApiManager.this.zac);
                } else {
                    zaa2.zal.add(zac2);
                    zaa2.GoogleApiManager.this.zaq.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.zaq, (int)15, (Object)zac2), zaa2.GoogleApiManager.this.zac);
                    zaa2.GoogleApiManager.this.zaq.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.zaq, (int)16, (Object)zac2), zaa2.GoogleApiManager.this.zad);
                    ConnectionResult connectionResult = new ConnectionResult(2, null);
                    if (!zaa2.zab(connectionResult)) {
                        zaa2.GoogleApiManager.this.zaa(connectionResult, zaa2.zai);
                    }
                }
                return false;
            }
            zad2.zaa((Exception)new UnsupportedApiCallException(feature));
            return true;
        }

        @WorkerThread
        private final void zac(com.google.android.gms.common.api.internal.zab zab2) {
            zab2.zaa(this.zaf, this.zak());
            try {
                zab2.zaa(this);
                return;
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zac.disconnect("DeadObjectException thrown while running ApiCallRunner.");
                return;
            }
            catch (Throwable throwable) {
                String string2 = String.format("Error in GoogleApi implementation for client %s.", this.zad.getClass().getName());
                throw new IllegalStateException(string2, throwable);
            }
        }

        @WorkerThread
        private final void zaa(@Nullable Status status, @Nullable Exception exception, boolean bl) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            if (status == null == (exception == null)) {
                throw new IllegalArgumentException("Status XOR exception should be null");
            }
            Iterator iterator = this.zab.iterator();
            while (iterator.hasNext()) {
                com.google.android.gms.common.api.internal.zab zab2 = (com.google.android.gms.common.api.internal.zab)iterator.next();
                if (bl && zab2.zaa != 2) continue;
                if (status != null) {
                    zab2.zaa(status);
                } else {
                    zab2.zaa(exception);
                }
                iterator.remove();
            }
        }

        @WorkerThread
        private final void zaa(Status status) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            this.zaa(status, null, false);
        }

        @WorkerThread
        public final void zaf() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            if (this.zak) {
                this.zai();
            }
        }

        @WorkerThread
        private final void zao() {
            if (this.zak) {
                GoogleApiManager.this.zaq.removeMessages(11, this.zae);
                GoogleApiManager.this.zaq.removeMessages(9, this.zae);
                this.zak = false;
            }
        }

        @WorkerThread
        public final void zag() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            if (this.zak) {
                this.zao();
                Status status = GoogleApiManager.this.zai.isGooglePlayServicesAvailable(GoogleApiManager.this.zah) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
                this.zaa(status);
                this.zac.disconnect("Timing out connection while resuming.");
            }
        }

        private final void zap() {
            GoogleApiManager.this.zaq.removeMessages(12, this.zae);
            GoogleApiManager.this.zaq.sendMessageDelayed(GoogleApiManager.this.zaq.obtainMessage(12, this.zae), GoogleApiManager.this.zae);
        }

        @WorkerThread
        public final boolean zah() {
            return this.zaa(true);
        }

        @WorkerThread
        private final boolean zaa(boolean bl) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            if (this.zac.isConnected() && this.zah.size() == 0) {
                if (this.zaf.zaa()) {
                    if (bl) {
                        this.zap();
                    }
                    return false;
                }
                this.zac.disconnect("Timing out service connection.");
                return true;
            }
            return false;
        }

        @WorkerThread
        public final void zai() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            if (this.zac.isConnected() || this.zac.isConnecting()) {
                return;
            }
            try {
                int n = GoogleApiManager.this.zaj.zaa(GoogleApiManager.this.zah, this.zac);
                if (n != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(n, null);
                    String string2 = this.zad.getClass().getName();
                    String string3 = String.valueOf(connectionResult);
                    Log.w((String)"GoogleApiManager", (String)new StringBuilder(35 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("The service for ").append(string2).append(" is not available: ").append(string3).toString());
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
            catch (IllegalStateException illegalStateException) {
                ConnectionResult connectionResult = new ConnectionResult(10);
                this.zaa(connectionResult, illegalStateException);
                return;
            }
            zab zab2 = new zab(this.zac, this.zae);
            if (this.zac.requiresSignIn()) {
                ((zacc)Preconditions.checkNotNull((Object)this.zaj)).zaa(zab2);
            }
            try {
                this.zac.connect(zab2);
                return;
            }
            catch (SecurityException securityException) {
                ConnectionResult connectionResult = new ConnectionResult(10);
                this.zaa(connectionResult, securityException);
                return;
            }
        }

        @WorkerThread
        public final void zaa(zaj zaj2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zaq);
            this.zag.add(zaj2);
        }

        @WorkerThread
        private final void zac(ConnectionResult connectionResult) {
            for (zaj zaj2 : this.zag) {
                String string2 = null;
                if (Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS)) {
                    string2 = this.zac.getEndpointPackageName();
                }
                zaj2.zaa(this.zae, connectionResult, string2);
            }
            this.zag.clear();
        }

        final boolean zaj() {
            return this.zac.isConnected();
        }

        public final boolean zak() {
            return this.zac.requiresSignIn();
        }

        public final int zal() {
            return this.zai;
        }

        @WorkerThread
        @Nullable
        private final Feature zaa(@Nullable Feature[] featureArray) {
            Feature feature;
            int n;
            if (featureArray == null || featureArray.length == 0) {
                return null;
            }
            Feature[] featureArray2 = this.zac.getAvailableFeatures();
            if (featureArray2 == null) {
                featureArray2 = new Feature[]{};
            }
            ArrayMap arrayMap = new ArrayMap(featureArray2.length);
            Feature[] featureArray3 = featureArray2;
            int n2 = featureArray2.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                arrayMap.put(feature.getName(), feature.getVersion());
            }
            featureArray3 = featureArray;
            n2 = featureArray.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                Long l = (Long)arrayMap.get(feature.getName());
                if (l != null && l >= feature.getVersion()) continue;
                return feature;
            }
            return null;
        }

        @WorkerThread
        private final void zaa(zac zac2) {
            if (!this.zal.contains(zac2)) {
                return;
            }
            if (!this.zak) {
                if (!this.zac.isConnected()) {
                    this.zai();
                    return;
                }
                this.zan();
            }
        }

        @WorkerThread
        private final void zab(zac zac2) {
            if (this.zal.remove(zac2)) {
                GoogleApiManager.this.zaq.removeMessages(15, (Object)zac2);
                GoogleApiManager.this.zaq.removeMessages(16, (Object)zac2);
                Feature feature = zac2.zab;
                zaa zaa2 = this;
                ArrayList<com.google.android.gms.common.api.internal.zab> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zab>(zaa2.zab.size());
                for (com.google.android.gms.common.api.internal.zab zab2 : zaa2.zab) {
                    Object[] objectArray;
                    if (!(zab2 instanceof zad) || (objectArray = ((zad)zab2).zac(zaa2)) == null || !ArrayUtils.contains((Object[])objectArray, (Object)feature)) continue;
                    arrayList.add(zab2);
                }
                ArrayList<com.google.android.gms.common.api.internal.zab> arrayList2 = arrayList;
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.api.internal.zab zab2;
                    Object e = arrayList2.get(i);
                    zab2 = (com.google.android.gms.common.api.internal.zab)e;
                    zaa2.zab.remove(zab2);
                    zab2.zaa((Exception)new UnsupportedApiCallException(feature));
                }
            }
        }

        private final Status zad(ConnectionResult connectionResult) {
            String string2 = this.zae.getApiName();
            String string3 = String.valueOf(connectionResult);
            return new Status(17, new StringBuilder(63 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("API: ").append(string2).append(" is not available on this device. Connection failed with: ").append(string3).toString());
        }

        static /* synthetic */ void zaa(zaa zaa2) {
            zaa2.zam();
        }

        static /* synthetic */ void zaa(zaa zaa2, int n) {
            zaa2.zaa(n);
        }

        static /* synthetic */ Api.AnyClient zab(zaa zaa2) {
            return zaa2.zad;
        }

        static /* synthetic */ Api.Client zac(zaa zaa2) {
            return zaa2.zac;
        }
    }
}

