/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.zaae;
import com.google.android.gms.common.api.internal.zaag;
import com.google.android.gms.common.api.internal.zaah;
import com.google.android.gms.common.api.internal.zaal;
import com.google.android.gms.common.api.internal.zaam;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zaaz;
import com.google.android.gms.common.api.internal.zaba;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zau;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.zam;
import com.google.android.gms.signin.zad;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zaaf
implements zaaw {
    private final zaaz zaa;
    private final Lock zab;
    private final Context zac;
    private final GoogleApiAvailabilityLight zad;
    @Nullable
    private ConnectionResult zae;
    private int zaf;
    private int zag = 0;
    private int zah;
    private final Bundle zai = new Bundle();
    private final Set<Api.AnyClientKey> zaj = new HashSet<Api.AnyClientKey>();
    @Nullable
    private zad zak;
    private boolean zal;
    private boolean zam;
    private boolean zan;
    @Nullable
    private IAccountAccessor zao;
    private boolean zap;
    private boolean zaq;
    @Nullable
    private final ClientSettings zar;
    private final Map<Api<?>, Boolean> zas;
    @Nullable
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zat;
    private ArrayList<Future<?>> zau = new ArrayList();

    public zaaf(zaaz zaaz2, @Nullable ClientSettings clientSettings, Map<Api<?>, Boolean> map, GoogleApiAvailabilityLight googleApiAvailabilityLight, @Nullable Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, Lock lock, Context context) {
        this.zaa = zaaz2;
        this.zar = clientSettings;
        this.zas = map;
        this.zad = googleApiAvailabilityLight;
        this.zat = abstractClientBuilder;
        this.zab = lock;
        this.zac = context;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa() {
        this.zaa.zab.clear();
        this.zam = false;
        this.zae = null;
        this.zag = 0;
        this.zal = true;
        this.zan = false;
        this.zap = false;
        boolean bl = false;
        HashMap<Api.Client, zaah> hashMap = new HashMap<Api.Client, zaah>();
        for (Api<?> api : this.zas.keySet()) {
            Api.Client client = (Api.Client)Preconditions.checkNotNull((Object)this.zaa.zaa.get(api.zac()));
            bl |= api.zaa().getPriority() == 1;
            boolean bl2 = this.zas.get(api);
            if (client.requiresSignIn()) {
                this.zam = true;
                if (bl2) {
                    this.zaj.add(api.zac());
                } else {
                    this.zal = false;
                }
            }
            hashMap.put(client, new zaah(this, api, bl2));
        }
        if (bl) {
            this.zam = false;
        }
        if (this.zam) {
            Preconditions.checkNotNull((Object)this.zar);
            Preconditions.checkNotNull(this.zat);
            this.zar.zaa(System.identityHashCode(this.zaa.zad));
            zaam zaam2 = new zaam(this, null);
            this.zak = this.zat.buildClient(this.zac, ((GoogleApiClient)this.zaa.zad).getLooper(), this.zar, this.zar.zac(), zaam2, zaam2);
        }
        this.zah = this.zaa.zaa.size();
        this.zau.add(zaba.zaa().submit(new zaag(this, hashMap)));
    }

    @GuardedBy(value="mLock")
    private final boolean zad() {
        --this.zah;
        if (this.zah > 0) {
            return false;
        }
        if (this.zah < 0) {
            Log.w((String)"GACConnecting", (String)this.zaa.zad.zac());
            Log.wtf((String)"GACConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zab(new ConnectionResult(8, null));
            return false;
        }
        if (this.zae != null) {
            this.zaa.zac = this.zaf;
            this.zab(this.zae);
            return false;
        }
        return true;
    }

    @GuardedBy(value="mLock")
    private final void zaa(zam zam2) {
        if (!this.zab(0)) {
            return;
        }
        ConnectionResult connectionResult = zam2.zaa();
        if (connectionResult.isSuccess()) {
            zau zau2 = (zau)((Object)Preconditions.checkNotNull((Object)((Object)zam2.zab())));
            ConnectionResult connectionResult2 = zau2.zab();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GACConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zab(connectionResult2);
                return;
            }
            this.zan = true;
            this.zao = (IAccountAccessor)Preconditions.checkNotNull((Object)zau2.zaa());
            this.zap = zau2.zac();
            this.zaq = zau2.zad();
            this.zae();
            return;
        }
        if (this.zaa(connectionResult)) {
            this.zag();
            this.zae();
            return;
        }
        this.zab(connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zae() {
        if (this.zah != 0) {
            return;
        }
        if (!this.zam || this.zan) {
            zaaf zaaf2 = this;
            ArrayList<Api.Client> arrayList = new ArrayList<Api.Client>();
            zaaf2.zag = 1;
            zaaf2.zah = zaaf2.zaa.zaa.size();
            for (Api.AnyClientKey<?> anyClientKey : zaaf2.zaa.zaa.keySet()) {
                if (zaaf2.zaa.zab.containsKey(anyClientKey)) {
                    if (!zaaf2.zad()) continue;
                    zaaf2.zaf();
                    continue;
                }
                arrayList.add(zaaf2.zaa.zaa.get(anyClientKey));
            }
            if (!arrayList.isEmpty()) {
                zaaf2.zau.add(zaba.zaa().submit(new zaal(zaaf2, arrayList)));
            }
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(@Nullable Bundle bundle) {
        if (!this.zab(1)) {
            return;
        }
        if (bundle != null) {
            this.zai.putAll(bundle);
        }
        if (this.zad()) {
            this.zaf();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (!this.zab(1)) {
            return;
        }
        this.zab(connectionResult, api, bl);
        if (this.zad()) {
            this.zaf();
        }
    }

    @GuardedBy(value="mLock")
    private final void zaf() {
        this.zaa.zai();
        zaba.zaa().execute(new zaae(this));
        if (this.zak != null) {
            if (this.zap) {
                this.zak.zaa((IAccountAccessor)Preconditions.checkNotNull((Object)this.zao), this.zaq);
            }
            this.zaa(false);
        }
        for (Api.AnyClientKey<?> anyClientKey : this.zaa.zab.keySet()) {
            ((Api.Client)Preconditions.checkNotNull((Object)this.zaa.zaa.get(anyClientKey))).disconnect();
        }
        Bundle bundle = this.zai.isEmpty() ? null : this.zai;
        this.zaa.zae.zaa(bundle);
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T zaa(T t) {
        this.zaa.zad.zaa.add(t);
        return t;
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T zab(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public final void zac() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final boolean zab() {
        this.zah();
        this.zaa(true);
        this.zaa.zaa((ConnectionResult)null);
        return true;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(int n) {
        this.zab(new ConnectionResult(8, null));
    }

    /*
     * Unable to fully structure code
     */
    @GuardedBy(value="mLock")
    private final void zab(ConnectionResult var1_1, Api<?> var2_2, boolean var3_3) {
        block3: {
            var4_4 = var2_2.zaa().getPriority();
            var7_5 = var1_1;
            var6_6 = var3_3;
            var5_7 = this;
            if (!var6_6) break block3;
            var9_8 = var7_5;
            var8_9 = var5_7;
            if (!(var9_8.hasResolution() != false ? true : var8_9.zad.getErrorResolutionIntent(var9_8.getErrorCode()) != null)) ** GOTO lbl-1000
        }
        if (var5_7.zae == null || var4_4 < var5_7.zaf) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            this.zae = var1_1;
            this.zaf = var4_4;
        }
        this.zaa.zab.put(var2_2.zac(), var1_1);
    }

    @GuardedBy(value="mLock")
    private final void zag() {
        this.zam = false;
        this.zaa.zad.zac = Collections.emptySet();
        for (Api.AnyClientKey anyClientKey : this.zaj) {
            if (this.zaa.zab.containsKey(anyClientKey)) continue;
            this.zaa.zab.put(anyClientKey, new ConnectionResult(17, null));
        }
    }

    @GuardedBy(value="mLock")
    private final boolean zaa(ConnectionResult connectionResult) {
        return this.zal && !connectionResult.hasResolution();
    }

    @GuardedBy(value="mLock")
    private final void zab(ConnectionResult connectionResult) {
        this.zah();
        this.zaa(!connectionResult.hasResolution());
        this.zaa.zaa(connectionResult);
        this.zaa.zae.zaa(connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zaa(boolean bl) {
        zad zad2 = this.zak;
        if (zad2 != null) {
            if (zad2.isConnected() && bl) {
                zad2.zaa();
            }
            zad2.disconnect();
            if (((ClientSettings)Preconditions.checkNotNull((Object)this.zar)).zae()) {
                this.zak = null;
            }
            this.zao = null;
        }
    }

    private final void zah() {
        ArrayList<Future<?>> arrayList = this.zau;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Future<?> future = arrayList.get(i);
            future.cancel(true);
        }
        this.zau.clear();
    }

    private final Set<Scope> zai() {
        if (this.zar == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zar.getRequiredScopes());
        Map<Api<?>, ClientSettings.zaa> map = this.zar.zaa();
        for (Api<?> api : map.keySet()) {
            if (this.zaa.zab.containsKey(api.zac())) continue;
            hashSet.addAll(map.get(api).zaa);
        }
        return hashSet;
    }

    @GuardedBy(value="mLock")
    private final boolean zab(int n) {
        if (this.zag != n) {
            Log.w((String)"GACConnecting", (String)this.zaa.zad.zac());
            String string2 = String.valueOf(this);
            Log.w((String)"GACConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.zah;
            Log.w((String)"GACConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = zaaf.zac(this.zag);
            String string4 = zaaf.zac(n);
            Log.e((String)"GACConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zab(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private static String zac(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ Context zaa(zaaf zaaf2) {
        return zaaf2.zac;
    }

    static /* synthetic */ GoogleApiAvailabilityLight zab(zaaf zaaf2) {
        return zaaf2.zad;
    }

    static /* synthetic */ Lock zac(zaaf zaaf2) {
        return zaaf2.zab;
    }

    static /* synthetic */ zaaz zad(zaaf zaaf2) {
        return zaaf2.zaa;
    }

    static /* synthetic */ void zaa(zaaf zaaf2, ConnectionResult connectionResult) {
        zaaf2.zab(connectionResult);
    }

    static /* synthetic */ boolean zae(zaaf zaaf2) {
        return zaaf2.zam;
    }

    static /* synthetic */ zad zaf(zaaf zaaf2) {
        return zaaf2.zak;
    }

    static /* synthetic */ Set zag(zaaf zaaf2) {
        return zaaf2.zai();
    }

    static /* synthetic */ IAccountAccessor zah(zaaf zaaf2) {
        return zaaf2.zao;
    }

    static /* synthetic */ ClientSettings zai(zaaf zaaf2) {
        return zaaf2.zar;
    }

    static /* synthetic */ boolean zab(zaaf zaaf2, ConnectionResult connectionResult) {
        return zaaf2.zaa(connectionResult);
    }

    static /* synthetic */ void zaj(zaaf zaaf2) {
        zaaf2.zag();
    }

    static /* synthetic */ void zak(zaaf zaaf2) {
        zaaf2.zae();
    }

    static /* synthetic */ boolean zaa(zaaf zaaf2, int n) {
        return zaaf2.zab(0);
    }

    static /* synthetic */ void zaa(zaaf zaaf2, ConnectionResult connectionResult, Api api, boolean bl) {
        zaaf2.zab(connectionResult, api, bl);
    }

    static /* synthetic */ boolean zal(zaaf zaaf2) {
        return zaaf2.zad();
    }

    static /* synthetic */ void zaa(zaaf zaaf2, zam zam2) {
        zaaf2.zaa(zam2);
    }
}

