/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.AbstractDataBuffer;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@KeepForSdk
public class DataBufferSafeParcelable<T extends SafeParcelable>
extends AbstractDataBuffer<T> {
    private static final String[] zaa = new String[]{"data"};
    private final Parcelable.Creator<T> zab;

    @KeepForSdk
    public DataBufferSafeParcelable(DataHolder dataHolder, Parcelable.Creator<T> creator) {
        super(dataHolder);
        this.zab = creator;
    }

    @KeepForSdk
    public static DataHolder.Builder buildDataHolder() {
        return DataHolder.builder(zaa);
    }

    @KeepForSdk
    public static <T extends SafeParcelable> void addValue(DataHolder.Builder builder, T t) {
        Parcel parcel = Parcel.obtain();
        t.writeToParcel(parcel, 0);
        ContentValues contentValues = new ContentValues();
        contentValues.put("data", parcel.marshall());
        builder.withRow(contentValues);
        parcel.recycle();
    }

    @Override
    @KeepForSdk
    public T get(int n) {
        DataHolder dataHolder = (DataHolder)Preconditions.checkNotNull((Object)this.mDataHolder);
        byte[] byArray = dataHolder.getByteArray("data", n, dataHolder.getWindowIndex(n));
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        SafeParcelable safeParcelable = (SafeParcelable)this.zab.createFromParcel(parcel);
        parcel.recycle();
        return (T)safeParcelable;
    }
}

