/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.collection.LruCache;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.internal.base.zak;
import com.google.android.gms.internal.base.zal;
import com.google.android.gms.internal.base.zap;
import com.google.android.gms.internal.base.zaq;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public final class ImageManager {
    private static final Object zaa = new Object();
    private static HashSet<Uri> zab = new HashSet();
    private static ImageManager zac;
    private final Context zad;
    private final Handler zae;
    private final ExecutorService zaf;
    @Nullable
    private final zaa zag;
    private final zak zah;
    private final Map<com.google.android.gms.common.images.zaa, ImageReceiver> zai;
    private final Map<Uri, ImageReceiver> zaj;
    private final Map<Uri, Long> zak;

    public static ImageManager create(Context context) {
        Context context2 = context;
        if (zac == null) {
            zac = new ImageManager(context2, false);
        }
        return zac;
    }

    private ImageManager(Context context, boolean bl) {
        this.zad = context.getApplicationContext();
        this.zae = new zap(Looper.getMainLooper());
        this.zaf = zal.zaa().zaa(4, zaq.zab);
        this.zag = null;
        this.zah = new zak();
        this.zai = new HashMap<com.google.android.gms.common.images.zaa, ImageReceiver>();
        this.zaj = new HashMap<Uri, ImageReceiver>();
        this.zak = new HashMap<Uri, Long>();
    }

    public final void loadImage(ImageView imageView, Uri uri) {
        com.google.android.gms.common.images.zab zab2 = new com.google.android.gms.common.images.zab(imageView, uri);
        this.zaa(zab2);
    }

    public final void loadImage(ImageView imageView, int n) {
        com.google.android.gms.common.images.zab zab2 = new com.google.android.gms.common.images.zab(imageView, n);
        this.zaa(zab2);
    }

    public final void loadImage(ImageView imageView, Uri uri, int n) {
        com.google.android.gms.common.images.zab zab2 = new com.google.android.gms.common.images.zab(imageView, uri);
        new com.google.android.gms.common.images.zab(imageView, uri).zab = n;
        this.zaa(zab2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        com.google.android.gms.common.images.zad zad2 = new com.google.android.gms.common.images.zad(onImageLoadedListener, uri);
        this.zaa(zad2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        com.google.android.gms.common.images.zad zad2 = new com.google.android.gms.common.images.zad(onImageLoadedListener, uri);
        new com.google.android.gms.common.images.zad(onImageLoadedListener, uri).zab = n;
        this.zaa(zad2);
    }

    private final void zaa(com.google.android.gms.common.images.zaa zaa2) {
        Asserts.checkMainThread((String)"ImageManager.loadImage() must be called in the main thread");
        new zad(zaa2).run();
    }

    @Nullable
    private final Bitmap zaa(com.google.android.gms.common.images.zac zac2) {
        if (this.zag == null) {
            return null;
        }
        return (Bitmap)this.zag.get(zac2);
    }

    private static final class zaa
    extends LruCache<com.google.android.gms.common.images.zac, Bitmap> {
        protected final /* synthetic */ int sizeOf(Object object, Object object2) {
            com.google.android.gms.common.images.zac cfr_ignored_0 = (com.google.android.gms.common.images.zac)object;
            Bitmap bitmap = (Bitmap)object2;
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected final /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, @Nullable Object object3) {
            Bitmap bitmap = (Bitmap)object3;
            Bitmap bitmap2 = (Bitmap)object2;
            com.google.android.gms.common.images.zac zac2 = (com.google.android.gms.common.images.zac)object;
            super.entryRemoved(bl, (Object)zac2, (Object)bitmap2, (Object)bitmap);
        }
    }

    private final class zac
    implements Runnable {
        private final Uri zaa;
        @Nullable
        private final Bitmap zab;
        private final CountDownLatch zac;
        private boolean zad;

        public zac(@Nullable Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.zaa = uri;
            this.zab = bitmap;
            this.zad = bl;
            this.zac = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            Asserts.checkMainThread((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.zab != null;
            if (ImageManager.this.zag != null) {
                if (this.zad) {
                    ImageManager.this.zag.evictAll();
                    System.gc();
                    this.zad = false;
                    ImageManager.this.zae.post((Runnable)this);
                    return;
                }
                if (this.zab != null) {
                    ImageManager.this.zag.put(new com.google.android.gms.common.images.zac(this.zaa), this.zab);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.zaj.remove(this.zaa))) != null) {
                boolean bl3 = bl;
                ImageReceiver imageReceiver2 = imageReceiver;
                zac zac2 = this;
                ArrayList arrayList = imageReceiver2.zab;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.images.zaa zaa2 = (com.google.android.gms.common.images.zaa)arrayList.get(i);
                    if (zac2.zab != null && bl3) {
                        zaa2.zaa(zac2.ImageManager.this.zad, zac2.zab, false);
                    } else {
                        zac2.ImageManager.this.zak.put(zac2.zaa, SystemClock.elapsedRealtime());
                        zaa2.zaa(zac2.ImageManager.this.zad, zac2.ImageManager.this.zah, false);
                    }
                    if (zaa2 instanceof com.google.android.gms.common.images.zad) continue;
                    zac2.ImageManager.this.zai.remove(zaa2);
                }
            }
            this.zac.countDown();
            Object object = zaa;
            synchronized (object) {
                zab.remove(this.zaa);
                return;
            }
        }
    }

    private final class zab
    implements Runnable {
        private final Uri zaa;
        @Nullable
        private final ParcelFileDescriptor zab;

        public zab(@Nullable Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.zaa = uri;
            this.zab = parcelFileDescriptor;
        }

        @Override
        public final void run() {
            Asserts.checkNotMainThread((String)"LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zab != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zab.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string2 = String.valueOf(this.zaa);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string2).length()).append("OOM while loading bitmap for uri: ").append(string2).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zab.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.zae.post((Runnable)new zac(this.zaa, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                String string3 = String.valueOf(this.zaa);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string3).length()).append("Latch interrupted while posting ").append(string3).toString());
                return;
            }
        }
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri zaa;
        private final ArrayList<com.google.android.gms.common.images.zaa> zab;

        ImageReceiver(Uri uri) {
            super((Handler)new zap(Looper.getMainLooper()));
            this.zaa = uri;
            this.zab = new ArrayList();
        }

        public final void zaa(com.google.android.gms.common.images.zaa zaa2) {
            Asserts.checkMainThread((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zab.add(zaa2);
        }

        public final void zab(com.google.android.gms.common.images.zaa zaa2) {
            Asserts.checkMainThread((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zab.remove(zaa2);
        }

        public final void zaa() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.setPackage("com.google.android.gms");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.zaa);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.zad.sendBroadcast(intent);
        }

        public final void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.zaf.execute(new zab(this.zaa, parcelFileDescriptor));
        }
    }

    private final class zad
    implements Runnable {
        private final com.google.android.gms.common.images.zaa zaa;

        public zad(com.google.android.gms.common.images.zaa zaa2) {
            this.zaa = zaa2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Asserts.checkMainThread((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.zai.get(this.zaa));
            if (imageReceiver != null) {
                ImageManager.this.zai.remove(this.zaa);
                imageReceiver.zab(this.zaa);
            }
            com.google.android.gms.common.images.zac zac2 = this.zaa.zaa;
            if (zac2.zaa == null) {
                this.zaa.zaa(ImageManager.this.zad, ImageManager.this.zah, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zaa(zac2);
            if (bitmap != null) {
                this.zaa.zaa(ImageManager.this.zad, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.zak.get(zac2.zaa);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zaa.zaa(ImageManager.this.zad, ImageManager.this.zah, true);
                    return;
                }
                ImageManager.this.zak.remove(zac2.zaa);
            }
            this.zaa.zaa(ImageManager.this.zad, ImageManager.this.zah);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.zaj.get(zac2.zaa));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zac2.zaa);
                ImageManager.this.zaj.put(zac2.zaa, imageReceiver);
            }
            imageReceiver.zaa(this.zaa);
            if (!(this.zaa instanceof com.google.android.gms.common.images.zad)) {
                ImageManager.this.zai.put(this.zaa, imageReceiver);
            }
            Object object = zaa;
            synchronized (object) {
                if (!zab.contains(zac2.zaa)) {
                    zab.add(zac2.zaa);
                    imageReceiver.zaa();
                }
                return;
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, @Nullable Drawable var2, boolean var3);
    }
}

