/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.base;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.base.zah;
import com.google.android.gms.internal.base.zaj;

public final class zaf
extends Drawable
implements Drawable.Callback {
    private int zaa = 0;
    private long zab;
    private int zac;
    private int zad;
    private int zae = 255;
    private int zaf;
    private int zag = 0;
    private boolean zah = true;
    private boolean zai;
    private zaj zaj;
    private Drawable zak;
    private Drawable zal;
    private boolean zam;
    private boolean zan;
    private boolean zao;
    private int zap;

    public zaf(@Nullable Drawable drawable2, @Nullable Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = com.google.android.gms.internal.base.zah.zaa();
        }
        this.zak = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zaj.zab |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = com.google.android.gms.internal.base.zah.zaa();
        }
        this.zal = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zaj.zab |= drawable3.getChangingConfigurations();
    }

    zaf(@Nullable zaj zaj2) {
        this.zaj = new zaj(zaj2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zaj.zaa | this.zaj.zab;
    }

    public final void setAlpha(int n) {
        if (this.zag == this.zae) {
            this.zag = n;
        }
        this.zae = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.zak.setColorFilter(colorFilter);
        this.zal.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zak.getIntrinsicWidth(), this.zal.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zak.getIntrinsicHeight(), this.zal.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zak.setBounds(rect);
        this.zal.setBounds(rect);
    }

    @Nullable
    public final Drawable.ConstantState getConstantState() {
        if (this.zab()) {
            this.zaj.zaa = this.getChangingConfigurations();
            return this.zaj;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zao) {
            this.zap = Drawable.resolveOpacity((int)this.zak.getOpacity(), (int)this.zal.getOpacity());
            this.zao = true;
        }
        return this.zap;
    }

    private final boolean zab() {
        if (!this.zam) {
            this.zan = this.zak.getConstantState() != null && this.zal.getConstantState() != null;
            this.zam = true;
        }
        return this.zan;
    }

    public final Drawable mutate() {
        if (!this.zai && super.mutate() == this) {
            if (!this.zab()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zak.mutate();
            this.zal.mutate();
            this.zai = true;
        }
        return this;
    }

    public final Drawable zaa() {
        return this.zal;
    }

    public final void zaa(int n) {
        this.zac = 0;
        this.zad = this.zae;
        this.zag = 0;
        this.zaf = 250;
        this.zaa = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zaa) {
            case 1: {
                this.zab = SystemClock.uptimeMillis();
                bl = false;
                this.zaa = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zab < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zab) / (float)this.zaf;
                bl = f >= 1.0f;
                if (bl) {
                    this.zaa = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.zag = (int)(0.0f + (float)this.zad * f2);
            }
        }
        int n = this.zag;
        boolean bl2 = this.zah;
        Drawable drawable2 = this.zak;
        Drawable drawable3 = this.zal;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zae) {
                drawable3.setAlpha(this.zae);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zae - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zae);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zae);
        }
        this.invalidateSelf();
    }
}

