/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaap;
import com.google.android.gms.common.api.internal.zaax;
import com.google.android.gms.common.api.internal.zabn;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.api.internal.zas;
import com.google.android.gms.common.api.internal.zat;
import com.google.android.gms.common.api.internal.zau;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

final class zaq
implements zabn {
    private final Context zaa;
    private final zaap zab;
    private final Looper zac;
    private final zaax zad;
    private final zaax zae;
    private final Map<Api.AnyClientKey<?>, zaax> zaf;
    private final Set<SignInConnectionListener> zag = Collections.newSetFromMap(new WeakHashMap());
    @Nullable
    private final Api.Client zah;
    @Nullable
    private Bundle zai;
    @Nullable
    private ConnectionResult zaj = null;
    @Nullable
    private ConnectionResult zak = null;
    private boolean zal = false;
    private final Lock zam;
    @GuardedBy(value="mLock")
    private int zan = 0;

    public static zaq zaa(Context context, zaap zaap2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, ArrayList<zap> arrayList) {
        Object object;
        Api.Client client = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.AnyClientKey<?>, Api.Client> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.providesSignIn()) {
                client = object;
            }
            if (object.requiresSignIn()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        Preconditions.checkState((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.AnyClientKey<?> anyClientKey = api.zac();
            if (arrayMap2.containsKey(anyClientKey)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(anyClientKey)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zap>();
        ArrayList<zap> arrayList2 = new ArrayList<zap>();
        ArrayList<zap> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zap zap2 = arrayList3.get(i);
            zap zap3 = zap2;
            if (arrayMap5.containsKey(zap3.zaa)) {
                ((ArrayList)object).add(zap3);
                continue;
            }
            if (arrayMap.containsKey(zap3.zaa)) {
                arrayList2.add(zap3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zaq(context, zaap2, lock, looper, googleApiAvailabilityLight, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap2, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap3, clientSettings, abstractClientBuilder, client, (ArrayList<zap>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zaq(Context context, zaap zaap2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, Map<Api.AnyClientKey<?>, Api.Client> map2, ClientSettings clientSettings, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, @Nullable Api.Client client, ArrayList<zap> arrayList, ArrayList<zap> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.zaa = context;
        this.zab = zaap2;
        this.zam = lock;
        this.zac = looper;
        this.zah = client;
        this.zad = new zaax(context, this.zab, lock, looper, googleApiAvailabilityLight, map2, null, map4, null, arrayList2, new zas(this, null));
        this.zae = new zaax(context, this.zab, lock, looper, googleApiAvailabilityLight, map, clientSettings, map3, abstractClientBuilder, arrayList, new zau(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.AnyClientKey<?> anyClientKey : map2.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zad);
        }
        for (Api.AnyClientKey<?> anyClientKey : map.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zae);
        }
        this.zaf = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T zaa(@NonNull T t) {
        if (this.zac(t)) {
            if (this.zaj()) {
                t.setFailedResult(new Status(4, null, this.zak()));
                return t;
            }
            return this.zae.zaa(t);
        }
        return this.zad.zaa(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T zab(@NonNull T t) {
        if (this.zac(t)) {
            if (this.zaj()) {
                t.setFailedResult(new Status(4, null, this.zak()));
                return t;
            }
            return this.zae.zab(t);
        }
        return this.zad.zab(t);
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult zaa(@NonNull Api<?> api) {
        if (Objects.equal((Object)this.zaf.get(api.zac()), (Object)this.zae)) {
            if (this.zaj()) {
                return new ConnectionResult(4, this.zak());
            }
            return this.zae.zaa(api);
        }
        return this.zad.zaa(api);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa() {
        this.zan = 2;
        this.zal = false;
        zaq zaq2 = this;
        this.zak = null;
        zaq2.zaj = null;
        zaq2.zad.zaa();
        zaq2.zae.zaa();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult zab() {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult zaa(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zac() {
        this.zak = null;
        this.zaj = null;
        this.zan = 0;
        this.zad.zac();
        this.zae.zac();
        this.zai();
    }

    @Override
    public final boolean zad() {
        this.zam.lock();
        try {
            boolean bl = this.zad.zad() && (this.zae.zad() || this.zaj() || this.zan == 1);
            return bl;
        }
        finally {
            this.zam.unlock();
        }
    }

    @Override
    public final boolean zae() {
        this.zam.lock();
        try {
            boolean bl = this.zan == 2;
            return bl;
        }
        finally {
            this.zam.unlock();
        }
    }

    @Override
    public final boolean zaa(SignInConnectionListener signInConnectionListener) {
        this.zam.lock();
        try {
            if ((this.zae() || this.zad()) && !this.zae.zad()) {
                this.zag.add(signInConnectionListener);
                if (this.zan == 0) {
                    this.zan = 1;
                }
                this.zak = null;
                this.zae.zaa();
                return true;
            }
        }
        finally {
            this.zam.unlock();
        }
        return false;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaf() {
        this.zad.zaf();
        this.zae.zaf();
    }

    @Override
    public final void zag() {
        this.zam.lock();
        try {
            boolean bl = this.zae();
            this.zae.zac();
            this.zak = new ConnectionResult(4);
            if (bl) {
                new com.google.android.gms.internal.base.zap(this.zac).post(new zat(this));
            } else {
                this.zai();
            }
            return;
        }
        finally {
            this.zam.unlock();
        }
    }

    @GuardedBy(value="mLock")
    private final void zah() {
        if (zaq.zab(this.zaj)) {
            if (zaq.zab(this.zak) || this.zaj()) {
                zaq zaq2 = this;
                switch (zaq2.zan) {
                    case 2: {
                        ((zaap)Preconditions.checkNotNull((Object)zaq2.zab)).zaa(zaq2.zai);
                    }
                    case 1: {
                        zaq2.zai();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zaq2.zan = 0;
                return;
            }
            if (this.zak != null) {
                if (this.zan == 1) {
                    this.zai();
                    return;
                }
                this.zaa(this.zak);
                this.zad.zac();
                return;
            }
        } else {
            if (this.zaj != null && zaq.zab(this.zak)) {
                this.zae.zac();
                this.zaa((ConnectionResult)Preconditions.checkNotNull((Object)this.zaj));
                return;
            }
            if (this.zaj != null && this.zak != null) {
                ConnectionResult connectionResult = this.zaj;
                if (this.zae.zac < this.zad.zac) {
                    connectionResult = this.zak;
                }
                this.zaa(connectionResult);
            }
        }
    }

    @GuardedBy(value="mLock")
    private final void zaa(ConnectionResult connectionResult) {
        switch (this.zan) {
            case 2: {
                this.zab.zaa(connectionResult);
            }
            case 1: {
                this.zai();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zan = 0;
    }

    @GuardedBy(value="mLock")
    private final void zai() {
        Iterator<SignInConnectionListener> iterator = this.zag.iterator();
        while (iterator.hasNext()) {
            iterator.next().onComplete();
        }
        this.zag.clear();
    }

    @GuardedBy(value="mLock")
    private final void zaa(int n, boolean bl) {
        this.zab.zaa(n, bl);
        this.zak = null;
        this.zaj = null;
    }

    @GuardedBy(value="mLock")
    private final boolean zaj() {
        return this.zak != null && this.zak.getErrorCode() == 4;
    }

    private final boolean zac(BaseImplementation.ApiMethodImpl<? extends Result, ? extends Api.AnyClient> apiMethodImpl) {
        Api.AnyClientKey<? extends Api.AnyClient> anyClientKey = apiMethodImpl.getClientKey();
        zaax zaax2 = this.zaf.get(anyClientKey);
        Preconditions.checkNotNull((Object)zaax2, (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return zaax2.equals(this.zae);
    }

    @Nullable
    private final PendingIntent zak() {
        if (this.zah == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.zaa, (int)System.identityHashCode(this.zab), (Intent)this.zah.getSignInIntent(), (int)0x8000000);
    }

    private final void zaa(@Nullable Bundle bundle) {
        if (this.zai == null) {
            this.zai = bundle;
            return;
        }
        if (bundle != null) {
            this.zai.putAll(bundle);
        }
    }

    private static boolean zab(@Nullable ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void zaa(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zae.zaa(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zad.zaa(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zaa(zaq zaq2) {
        return zaq2.zam;
    }

    static /* synthetic */ void zab(zaq zaq2) {
        zaq2.zah();
    }

    static /* synthetic */ void zaa(zaq zaq2, Bundle bundle) {
        zaq2.zaa(bundle);
    }

    static /* synthetic */ ConnectionResult zaa(zaq zaq2, ConnectionResult connectionResult) {
        zaq2.zaj = connectionResult;
        return zaq2.zaj;
    }

    static /* synthetic */ boolean zac(zaq zaq2) {
        return zaq2.zal;
    }

    static /* synthetic */ ConnectionResult zad(zaq zaq2) {
        return zaq2.zak;
    }

    static /* synthetic */ boolean zaa(zaq zaq2, boolean bl) {
        zaq2.zal = bl;
        return zaq2.zal;
    }

    static /* synthetic */ void zaa(zaq zaq2, int n, boolean bl) {
        zaq2.zaa(n, bl);
    }

    static /* synthetic */ zaax zae(zaq zaq2) {
        return zaq2.zae;
    }

    static /* synthetic */ ConnectionResult zab(zaq zaq2, ConnectionResult connectionResult) {
        zaq2.zak = connectionResult;
        return zaq2.zak;
    }

    static /* synthetic */ zaax zaf(zaq zaq2) {
        return zaq2.zad;
    }
}

