/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.images.zae;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="WebImageCreator")
public final class WebImage
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<WebImage> CREATOR = new zae();
    @SafeParcelable.VersionField(id=1)
    private final int zaa;
    @SafeParcelable.Field(id=2, getter="getUrl")
    private final Uri zab;
    @SafeParcelable.Field(id=3, getter="getWidth")
    private final int zac;
    @SafeParcelable.Field(id=4, getter="getHeight")
    private final int zad;

    @SafeParcelable.Constructor
    WebImage(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) Uri uri, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) int n3) {
        this.zaa = n;
        this.zab = uri;
        this.zac = n2;
        this.zad = n3;
    }

    public WebImage(@RecentlyNonNull Uri uri, @RecentlyNonNull int n, @RecentlyNonNull int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(@RecentlyNonNull Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    @KeepForSdk
    public WebImage(@RecentlyNonNull JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zaa(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    private static Uri zaa(JSONObject jSONObject) {
        Uri uri = Uri.EMPTY;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {}
        }
        return uri;
    }

    @RecentlyNonNull
    public final Uri getUrl() {
        return this.zab;
    }

    @RecentlyNonNull
    public final int getWidth() {
        return this.zac;
    }

    @RecentlyNonNull
    public final int getHeight() {
        return this.zad;
    }

    @RecentlyNonNull
    public final String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zac, this.zad, this.zab.toString());
    }

    @KeepForSdk
    @RecentlyNonNull
    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zab.toString());
            jSONObject.put("width", this.zac);
            jSONObject.put("height", this.zad);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    @RecentlyNonNull
    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return Objects.equal((Object)this.zab, (Object)webImage.zab) && this.zac == webImage.zac && this.zad == webImage.zad;
    }

    @RecentlyNonNull
    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zab, this.zac, this.zad});
    }

    public final void writeToParcel(@RecentlyNonNull Parcel parcel, @RecentlyNonNull int n) {
        Parcel parcel2 = parcel;
        WebImage webImage = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)webImage.zaa);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)webImage.getUrl(), (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)webImage.getWidth());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)webImage.getHeight());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

