/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.base.R;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zaab;
import com.google.android.gms.common.internal.zay;
import com.google.android.gms.dynamic.RemoteCreator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    public static final int COLOR_AUTO = 2;
    private int zaa;
    private int zab;
    private View zac;
    @Nullable
    private View.OnClickListener zad = null;

    public SignInButton(@RecentlyNonNull Context context) {
        this(context, null);
    }

    public SignInButton(@RecentlyNonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SignInButton(@RecentlyNonNull Context context, @Nullable AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        AttributeSet attributeSet2 = attributeSet;
        Context context2 = context;
        SignInButton signInButton = this;
        TypedArray typedArray = context2.getTheme().obtainStyledAttributes(attributeSet2, R.styleable.SignInButton, 0, 0);
        try {
            signInButton.zaa = typedArray.getInt(R.styleable.SignInButton_buttonSize, 0);
            signInButton.zab = typedArray.getInt(R.styleable.SignInButton_colorScheme, 2);
        }
        finally {
            typedArray.recycle();
        }
        this.setStyle(this.zaa, this.zab);
    }

    public final void setSize(int n) {
        this.setStyle(n, this.zab);
    }

    public final void setColorScheme(int n) {
        this.setStyle(this.zaa, n);
    }

    @Deprecated
    public final void setScopes(@RecentlyNonNull Scope[] scopeArray) {
        this.setStyle(this.zaa, this.zab);
    }

    public final void setStyle(int n, int n2) {
        this.zaa = n;
        this.zab = n2;
        Context context = this.getContext();
        SignInButton signInButton = this;
        if (signInButton.zac != null) {
            signInButton.removeView(signInButton.zac);
        }
        try {
            signInButton.zac = zay.zaa(context, signInButton.zaa, signInButton.zab);
        }
        catch (RemoteCreator.RemoteCreatorException remoteCreatorException) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            int n3 = signInButton.zab;
            int n4 = signInButton.zaa;
            Context context2 = context;
            zaab zaab2 = new zaab(context2);
            zaab2.zaa(context2.getResources(), n4, n3);
            signInButton.zac = zaab2;
        }
        signInButton.addView(signInButton.zac);
        signInButton.zac.setEnabled(signInButton.isEnabled());
        signInButton.zac.setOnClickListener((View.OnClickListener)signInButton);
    }

    @Deprecated
    public final void setStyle(int n, int n2, @RecentlyNonNull Scope[] scopeArray) {
        this.setStyle(n, n2);
    }

    public final void setOnClickListener(@Nullable View.OnClickListener onClickListener) {
        this.zad = onClickListener;
        if (this.zac != null) {
            this.zac.setOnClickListener((View.OnClickListener)this);
        }
    }

    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.zac.setEnabled(bl);
    }

    public final void onClick(@RecentlyNonNull View view) {
        if (this.zad != null && view == this.zac) {
            this.zad.onClick((View)this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorScheme {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ButtonSize {
    }
}

