/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;

@KeepName
public class GoogleApiActivity
extends Activity
implements DialogInterface.OnCancelListener {
    @VisibleForTesting
    private int zaa = 0;

    @RecentlyNonNull
    public static PendingIntent zaa(@RecentlyNonNull Context context, @RecentlyNonNull PendingIntent pendingIntent, int n) {
        int n2 = n;
        PendingIntent pendingIntent2 = pendingIntent;
        Context context2 = context;
        return PendingIntent.getActivity((Context)context2, (int)0, (Intent)GoogleApiActivity.zaa(context2, pendingIntent2, n2, true), (int)0x8000000);
    }

    @RecentlyNonNull
    public static Intent zaa(@RecentlyNonNull Context context, @RecentlyNonNull PendingIntent pendingIntent, int n, boolean bl) {
        Intent intent = new Intent(context, GoogleApiActivity.class);
        intent.putExtra("pending_intent", (Parcelable)pendingIntent);
        intent.putExtra("failing_client_id", n);
        intent.putExtra("notify_manager", bl);
        return intent;
    }

    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.zaa = bundle.getInt("resolution");
        }
        if (this.zaa != 1) {
            GoogleApiActivity googleApiActivity = this;
            Bundle bundle2 = googleApiActivity.getIntent().getExtras();
            if (bundle2 == null) {
                Log.e((String)"GoogleApiActivity", (String)"Activity started without extras");
                googleApiActivity.finish();
                return;
            }
            PendingIntent pendingIntent = (PendingIntent)bundle2.get("pending_intent");
            Integer n = (Integer)bundle2.get("error_code");
            if (pendingIntent == null && n == null) {
                Log.e((String)"GoogleApiActivity", (String)"Activity started without resolution");
                googleApiActivity.finish();
                return;
            }
            if (pendingIntent != null) {
                try {
                    googleApiActivity.startIntentSenderForResult(pendingIntent.getIntentSender(), 1, null, 0, 0, 0);
                    googleApiActivity.zaa = 1;
                    return;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    if (bundle2.getBoolean("notify_manager", true)) {
                        GoogleApiManager.zaa((Context)googleApiActivity).zab(new ConnectionResult(22, null), googleApiActivity.getIntent().getIntExtra("failing_client_id", -1));
                    } else {
                        PendingIntent pendingIntent2 = pendingIntent;
                        ActivityNotFoundException activityNotFoundException2 = activityNotFoundException;
                        String string2 = String.valueOf(pendingIntent2);
                        String string3 = new StringBuilder(36 + String.valueOf(string2).length()).append("Activity not found while launching ").append(string2).append(".").toString();
                        if (Build.FINGERPRINT.contains("generic")) {
                            string3 = String.valueOf(string3).concat(" This may occur when resolving Google Play services connection issues on emulators with Google APIs but not Google Play Store.");
                        }
                        Log.e((String)"GoogleApiActivity", (String)string3, (Throwable)activityNotFoundException2);
                    }
                    googleApiActivity.zaa = 1;
                    googleApiActivity.finish();
                    return;
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.e((String)"GoogleApiActivity", (String)"Failed to launch pendingIntent", (Throwable)sendIntentException);
                    googleApiActivity.finish();
                    return;
                }
            }
            int n2 = (Integer)Preconditions.checkNotNull((Object)n);
            GoogleApiAvailability.getInstance().showErrorDialogFragment(googleApiActivity, n2, 2, googleApiActivity);
            googleApiActivity.zaa = 1;
        }
    }

    protected void onActivityResult(int n, int n2, @RecentlyNonNull Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (n == 1) {
            boolean bl = this.getIntent().getBooleanExtra("notify_manager", true);
            this.zaa = 0;
            Object object = intent;
            this.setResult(n2, (Intent)object);
            if (bl) {
                object = GoogleApiManager.zaa((Context)this);
                GoogleApiActivity googleApiActivity = this;
                switch (n2) {
                    case 0: {
                        ((GoogleApiManager)object).zab(new ConnectionResult(13, null), googleApiActivity.getIntent().getIntExtra("failing_client_id", -1));
                        break;
                    }
                    case -1: {
                        ((GoogleApiManager)object).zac();
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (n == 2) {
            this.zaa = 0;
            Intent intent2 = intent;
            this.setResult(n2, intent2);
        }
        this.finish();
    }

    protected void onSaveInstanceState(@RecentlyNonNull Bundle bundle) {
        bundle.putInt("resolution", this.zaa);
        super.onSaveInstanceState(bundle);
    }

    public void onCancel(@RecentlyNonNull DialogInterface dialogInterface) {
        this.zaa = 0;
        this.setResult(0);
        this.finish();
    }
}

