/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ConnectionTelemetryConfiguration;
import com.google.android.gms.common.internal.RootTelemetryConfigManager;
import com.google.android.gms.common.internal.RootTelemetryConfiguration;
import com.google.android.gms.common.internal.zao;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;

final class zabr<T>
implements OnCompleteListener<T> {
    private final GoogleApiManager zaa;
    private final int zab;
    private final ApiKey<?> zac;
    private final long zad;

    @VisibleForTesting
    private zabr(GoogleApiManager googleApiManager, int n, ApiKey<?> apiKey, long l) {
        this.zaa = googleApiManager;
        this.zab = n;
        this.zac = apiKey;
        this.zad = l;
    }

    @WorkerThread
    public final void onComplete(@NonNull Task<T> task) {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.zaa.zad()) {
            return;
        }
        boolean bl = this.zad > 0L;
        int n5 = 0;
        RootTelemetryConfiguration rootTelemetryConfiguration = RootTelemetryConfigManager.getInstance().getConfig();
        if (rootTelemetryConfiguration != null) {
            if (!rootTelemetryConfiguration.getMethodInvocationTelemetryEnabled()) {
                return;
            }
            bl &= rootTelemetryConfiguration.getMethodTimingTelemetryEnabled();
            n4 = rootTelemetryConfiguration.getBatchPeriodMillis();
            n3 = rootTelemetryConfiguration.getMaxMethodInvocationsInBatch();
            n5 = rootTelemetryConfiguration.getVersion();
            GoogleApiManager.zaa zaa2 = this.zaa.zaa(this.zac);
            if (zaa2 != null && zaa2.zab().isConnected() && zaa2.zab() instanceof BaseGmsClient) {
                ConnectionTelemetryConfiguration connectionTelemetryConfiguration = zabr.zaa(zaa2, this.zab);
                if (connectionTelemetryConfiguration == null) {
                    return;
                }
                bl = connectionTelemetryConfiguration.getMethodTimingTelemetryEnabled() && this.zad > 0L;
                n3 = connectionTelemetryConfiguration.getMaxMethodInvocationsLogged();
            }
        } else {
            n4 = 5000;
            n3 = 100;
        }
        boolean bl2 = bl;
        Task<T> task2 = task;
        zabr zabr2 = this;
        if (task2.isSuccessful()) {
            n2 = 0;
            n = 0;
        } else if (task2.isCanceled()) {
            n2 = 100;
            n = -1;
        } else {
            Exception exception = task2.getException();
            if (exception instanceof ApiException) {
                Status status = ((ApiException)exception).getStatus();
                n2 = status.getStatusCode();
                ConnectionResult connectionResult = status.getConnectionResult();
                n = connectionResult == null ? -1 : connectionResult.getErrorCode();
            } else {
                n2 = 101;
                n = -1;
            }
        }
        long l = 0L;
        long l2 = 0L;
        if (bl2) {
            l = zabr2.zad;
            l2 = System.currentTimeMillis();
        }
        this.zaa.zaa(new zao(zabr2.zab, n2, n, l, l2), n5, n4, n3);
    }

    @Nullable
    private static ConnectionTelemetryConfiguration zaa(GoogleApiManager.zaa<?> zaa2, int n) {
        ConnectionTelemetryConfiguration connectionTelemetryConfiguration;
        block5: {
            block4: {
                int[] nArray;
                connectionTelemetryConfiguration = ((BaseGmsClient)zaa2.zab()).getTelemetryConfiguration();
                if (connectionTelemetryConfiguration == null) break block4;
                int n2 = n;
                ConnectionTelemetryConfiguration connectionTelemetryConfiguration2 = connectionTelemetryConfiguration;
                if (connectionTelemetryConfiguration2.getMethodInvocationTelemetryEnabled() ? (nArray = connectionTelemetryConfiguration2.getMethodInvocationMethodKeyAllowlist()) == null || ArrayUtils.contains((int[])nArray, (int)n2) : false) break block5;
            }
            return null;
        }
        if (zaa2.zam() < connectionTelemetryConfiguration.getMaxMethodInvocationsLogged()) {
            return connectionTelemetryConfiguration;
        }
        return null;
    }

    @Nullable
    static <T> zabr<T> zaa(GoogleApiManager googleApiManager, int n, ApiKey<?> apiKey) {
        if (!googleApiManager.zad()) {
            return null;
        }
        boolean bl = true;
        RootTelemetryConfiguration rootTelemetryConfiguration = RootTelemetryConfigManager.getInstance().getConfig();
        if (rootTelemetryConfiguration != null) {
            if (!rootTelemetryConfiguration.getMethodInvocationTelemetryEnabled()) {
                return null;
            }
            bl = rootTelemetryConfiguration.getMethodTimingTelemetryEnabled();
            GoogleApiManager.zaa zaa2 = googleApiManager.zaa(apiKey);
            if (zaa2 != null && zaa2.zab().isConnected() && zaa2.zab() instanceof BaseGmsClient) {
                ConnectionTelemetryConfiguration connectionTelemetryConfiguration = zabr.zaa(zaa2, n);
                if (connectionTelemetryConfiguration == null) {
                    return null;
                }
                zaa2.zan();
                bl = connectionTelemetryConfiguration.getMethodTimingTelemetryEnabled();
            }
        }
        return new zabr<T>(googleApiManager, n, apiKey, bl ? System.currentTimeMillis() : 0L);
    }
}

