/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.FastSafeParcelableJsonResponse;
import com.google.android.gms.common.server.response.zaj;
import com.google.android.gms.common.server.response.zap;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.MapUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@VisibleForTesting
@SafeParcelable.Class(creator="SafeParcelResponseCreator")
@KeepForSdk
public class SafeParcelResponse
extends FastSafeParcelableJsonResponse {
    @SafeParcelable.VersionField(id=1, getter="getVersionCode")
    private final int zaa;
    @SafeParcelable.Field(id=2, getter="getParcel")
    private final Parcel zab;
    private final int zac;
    @SafeParcelable.Field(id=3, getter="getFieldMappingDictionary")
    private final zaj zad;
    @Nullable
    private final String zae;
    private int zaf;
    private int zag;
    @KeepForSdk
    @RecentlyNonNull
    public static final Parcelable.Creator<SafeParcelResponse> CREATOR = new zap();

    public SafeParcelResponse(zaj zaj2, String string2) {
        this.zaa = 1;
        this.zab = Parcel.obtain();
        this.zac = 0;
        this.zad = (zaj)((Object)Preconditions.checkNotNull((Object)((Object)zaj2)));
        this.zae = (String)Preconditions.checkNotNull((Object)string2);
        this.zaf = 0;
    }

    private SafeParcelResponse(SafeParcelable safeParcelable, zaj zaj2, String string2) {
        this.zaa = 1;
        this.zab = Parcel.obtain();
        safeParcelable.writeToParcel(this.zab, 0);
        this.zac = 1;
        this.zad = (zaj)((Object)Preconditions.checkNotNull((Object)((Object)zaj2)));
        this.zae = (String)Preconditions.checkNotNull((Object)string2);
        this.zaf = 2;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T extends FastJsonResponse> SafeParcelResponse from(@RecentlyNonNull T t) {
        String string2 = (String)Preconditions.checkNotNull((Object)t.getClass().getCanonicalName());
        T t2 = t;
        zaj zaj2 = new zaj(t2.getClass());
        SafeParcelResponse.zaa(zaj2, t2);
        zaj2.zab();
        zaj2.zaa();
        zaj zaj3 = zaj2;
        return new SafeParcelResponse((SafeParcelable)t, zaj3, string2);
    }

    private static void zaa(zaj zaj2, FastJsonResponse fastJsonResponse) {
        Class<?> clazz = fastJsonResponse.getClass();
        if (!zaj2.zaa(clazz)) {
            Map<String, FastJsonResponse.Field<?, ?>> map = fastJsonResponse.getFieldMappings();
            zaj2.zaa(clazz, map);
            for (String string2 : map.keySet()) {
                FastJsonResponse.Field<?, ?> field = map.get(string2);
                Class<? extends FastJsonResponse> clazz2 = field.zag;
                if (clazz2 == null) continue;
                try {
                    FastJsonResponse fastJsonResponse2 = clazz2.newInstance();
                    SafeParcelResponse.zaa(zaj2, fastJsonResponse2);
                }
                catch (InstantiationException instantiationException) {
                    String string3 = String.valueOf(((Class)Preconditions.checkNotNull(field.zag)).getCanonicalName());
                    throw new IllegalStateException(string3.length() != 0 ? "Could not instantiate an object of type ".concat(string3) : new String("Could not instantiate an object of type "), instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    String string4 = String.valueOf(((Class)Preconditions.checkNotNull(field.zag)).getCanonicalName());
                    throw new IllegalStateException(string4.length() != 0 ? "Could not access object of type ".concat(string4) : new String("Could not access object of type "), illegalAccessException);
                }
            }
        }
    }

    @SafeParcelable.Constructor
    SafeParcelResponse(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) Parcel parcel, @SafeParcelable.Param(id=3) zaj zaj2) {
        this.zaa = n;
        this.zab = (Parcel)Preconditions.checkNotNull((Object)parcel);
        this.zac = 2;
        this.zad = zaj2;
        this.zae = this.zad == null ? null : this.zad.zac();
        this.zaf = 2;
    }

    public void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        zaj zaj2;
        Parcel parcel2 = parcel;
        SafeParcelResponse safeParcelResponse = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)safeParcelResponse.zaa);
        SafeParcelWriter.writeParcel((Parcel)parcel2, (int)2, (Parcel)safeParcelResponse.zaa(), (boolean)false);
        SafeParcelResponse safeParcelResponse2 = safeParcelResponse;
        switch (safeParcelResponse2.zac) {
            case 0: {
                zaj2 = null;
                break;
            }
            case 1: {
                zaj2 = safeParcelResponse2.zad;
                break;
            }
            case 2: {
                zaj2 = safeParcelResponse2.zad;
                break;
            }
            default: {
                int n3 = safeParcelResponse2.zac;
                throw new IllegalStateException(new StringBuilder(34).append("Invalid creation type: ").append(n3).toString());
            }
        }
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)zaj2, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private final Parcel zaa() {
        switch (this.zaf) {
            case 0: {
                this.zag = SafeParcelWriter.beginObjectHeader((Parcel)this.zab);
            }
            case 1: {
                SafeParcelWriter.finishObjectHeader((Parcel)this.zab, (int)this.zag);
                this.zaf = 2;
            }
        }
        return this.zab;
    }

    @Override
    @RecentlyNullable
    public Map<String, FastJsonResponse.Field<?, ?>> getFieldMappings() {
        if (this.zad == null) {
            return null;
        }
        return this.zad.zaa((String)Preconditions.checkNotNull((Object)this.zae));
    }

    @Override
    @RecentlyNonNull
    public Object getValueObject(@RecentlyNonNull String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    public boolean isPrimitiveFieldSet(@RecentlyNonNull String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    private final void zaa(FastJsonResponse.Field<?, ?> field) {
        if (!(field.zaf != -1)) {
            throw new IllegalStateException("Field does not have a valid safe parcelable field id.");
        }
        if (this.zab == null) {
            throw new IllegalStateException("Internal Parcel object is null.");
        }
        switch (this.zaf) {
            case 0: {
                this.zag = SafeParcelWriter.beginObjectHeader((Parcel)this.zab);
                this.zaf = 1;
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                throw new IllegalStateException("Attempted to parse JSON with a SafeParcelResponse object that is already filled with data.");
            }
        }
        throw new IllegalStateException("Unknown parse state in SafeParcelResponse.");
    }

    @Override
    protected void setIntegerInternal(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, int n) {
        this.zaa(field);
        SafeParcelWriter.writeInt((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (int)n);
    }

    @Override
    protected final void zaa(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<Integer> arrayList) {
        this.zaa(field);
        int n = ((ArrayList)Preconditions.checkNotNull(arrayList)).size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeIntArray((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (int[])nArray, (boolean)true);
    }

    @Override
    protected final void zaa(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable BigInteger bigInteger) {
        this.zaa(field);
        SafeParcelWriter.writeBigInteger((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (BigInteger)bigInteger, (boolean)true);
    }

    @Override
    protected final void zab(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<BigInteger> arrayList) {
        this.zaa(field);
        int n = ((ArrayList)Preconditions.checkNotNull(arrayList)).size();
        BigInteger[] bigIntegerArray = new BigInteger[n];
        for (int i = 0; i < n; ++i) {
            bigIntegerArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeBigIntegerArray((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (BigInteger[])bigIntegerArray, (boolean)true);
    }

    @Override
    protected void setLongInternal(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, long l) {
        this.zaa(field);
        SafeParcelWriter.writeLong((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (long)l);
    }

    @Override
    protected final void zac(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<Long> arrayList) {
        this.zaa(field);
        int n = ((ArrayList)Preconditions.checkNotNull(arrayList)).size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeLongArray((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (long[])lArray, (boolean)true);
    }

    @Override
    protected final void zaa(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, float f) {
        this.zaa(field);
        SafeParcelWriter.writeFloat((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (float)f);
    }

    @Override
    protected final void zad(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<Float> arrayList) {
        this.zaa(field);
        int n = ((ArrayList)Preconditions.checkNotNull(arrayList)).size();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = arrayList.get(i).floatValue();
        }
        SafeParcelWriter.writeFloatArray((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (float[])fArray, (boolean)true);
    }

    @Override
    protected final void zaa(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, double d) {
        this.zaa(field);
        SafeParcelWriter.writeDouble((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (double)d);
    }

    @Override
    protected final void zae(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<Double> arrayList) {
        this.zaa(field);
        int n = ((ArrayList)Preconditions.checkNotNull(arrayList)).size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeDoubleArray((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (double[])dArray, (boolean)true);
    }

    @Override
    protected final void zaa(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable BigDecimal bigDecimal) {
        this.zaa(field);
        SafeParcelWriter.writeBigDecimal((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (BigDecimal)bigDecimal, (boolean)true);
    }

    @Override
    protected final void zaf(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<BigDecimal> arrayList) {
        this.zaa(field);
        int n = ((ArrayList)Preconditions.checkNotNull(arrayList)).size();
        BigDecimal[] bigDecimalArray = new BigDecimal[n];
        for (int i = 0; i < n; ++i) {
            bigDecimalArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeBigDecimalArray((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (BigDecimal[])bigDecimalArray, (boolean)true);
    }

    @Override
    protected void setBooleanInternal(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, boolean bl) {
        this.zaa(field);
        SafeParcelWriter.writeBoolean((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (boolean)bl);
    }

    @Override
    protected final void zag(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<Boolean> arrayList) {
        this.zaa(field);
        int n = ((ArrayList)Preconditions.checkNotNull(arrayList)).size();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeBooleanArray((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (boolean[])blArray, (boolean)true);
    }

    @Override
    protected void setStringInternal(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable String string3) {
        this.zaa(field);
        SafeParcelWriter.writeString((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (String)string3, (boolean)true);
    }

    @Override
    protected void setStringsInternal(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<String> arrayList) {
        this.zaa(field);
        int n = ((ArrayList)Preconditions.checkNotNull(arrayList)).size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeStringArray((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (String[])stringArray, (boolean)true);
    }

    @Override
    protected void setDecodedBytesInternal(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable byte[] byArray) {
        this.zaa(field);
        SafeParcelWriter.writeByteArray((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (byte[])byArray, (boolean)true);
    }

    @Override
    protected void setStringMapInternal(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable Map<String, String> map) {
        this.zaa(field);
        Bundle bundle = new Bundle();
        for (String string3 : ((Map)Preconditions.checkNotNull(map)).keySet()) {
            bundle.putString(string3, map.get(string3));
        }
        SafeParcelWriter.writeBundle((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (Bundle)bundle, (boolean)true);
    }

    @Override
    public <T extends FastJsonResponse> void addConcreteTypeInternal(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @RecentlyNonNull T t) {
        this.zaa(field);
        Parcel parcel = ((SafeParcelResponse)t).zaa();
        SafeParcelWriter.writeParcel((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), (Parcel)parcel, (boolean)true);
    }

    @Override
    public <T extends FastJsonResponse> void addConcreteTypeArrayInternal(@RecentlyNonNull FastJsonResponse.Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<T> arrayList) {
        this.zaa(field);
        ArrayList<Parcel> arrayList2 = new ArrayList<Parcel>();
        ((ArrayList)Preconditions.checkNotNull(arrayList)).size();
        ArrayList<T> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            T t = arrayList3.get(i);
            FastJsonResponse fastJsonResponse = (FastJsonResponse)t;
            arrayList2.add(((SafeParcelResponse)fastJsonResponse).zaa());
        }
        SafeParcelWriter.writeParcelList((Parcel)this.zab, (int)field.getSafeParcelableFieldId(), arrayList2, (boolean)true);
    }

    @Override
    @RecentlyNonNull
    public String toString() {
        Preconditions.checkNotNull((Object)((Object)this.zad), (Object)"Cannot convert to JSON on client side.");
        Parcel parcel = this.zaa();
        parcel.setDataPosition(0);
        StringBuilder stringBuilder = new StringBuilder(100);
        this.zaa(stringBuilder, (Map)Preconditions.checkNotNull(this.zad.zaa((String)Preconditions.checkNotNull((Object)this.zae))), parcel);
        return stringBuilder.toString();
    }

    private final void zaa(StringBuilder stringBuilder, Map<String, FastJsonResponse.Field<?, ?>> map, Parcel parcel) {
        Object object = map;
        Object object2 = new SparseArray();
        for (Map.Entry<String, FastJsonResponse.Field<?, ?>> object3 : object.entrySet()) {
            object2.put(object3.getValue().getSafeParcelableFieldId(), object3);
        }
        SparseArray sparseArray = object2;
        stringBuilder.append('{');
        int n = SafeParcelReader.validateObjectHeader((Parcel)parcel);
        boolean bl = false;
        while (parcel.dataPosition() < n) {
            block51: {
                Object object3;
                Object object4;
                Object object5;
                FastJsonResponse.Field field;
                Parcel parcel2;
                int n2;
                FastJsonResponse.Field field2;
                Parcel parcel3;
                int n3;
                block50: {
                    int n4 = SafeParcelReader.readHeader((Parcel)parcel);
                    int n5 = SafeParcelReader.getFieldId((int)n4);
                    Map.Entry entry = (Map.Entry)sparseArray.get(n5);
                    if (entry == null) continue;
                    if (bl) {
                        stringBuilder.append(",");
                    }
                    n3 = n4;
                    parcel3 = parcel;
                    field2 = (FastJsonResponse.Field)((Object)entry.getValue());
                    String string2 = (String)entry.getKey();
                    object2 = stringBuilder;
                    object = this;
                    ((StringBuilder)object2).append("\"").append(string2).append("\":");
                    if (!field2.zab()) break block50;
                    n2 = n3;
                    parcel2 = parcel3;
                    field = field2;
                    object5 = object2;
                    switch (field.zac) {
                        case 0: {
                            int l = SafeParcelReader.readInt((Parcel)parcel2, (int)n2);
                            SafeParcelResponse.zaa((StringBuilder)object5, field, SafeParcelResponse.zaa(field, l));
                            break block51;
                        }
                        case 1: {
                            BigInteger f = SafeParcelReader.createBigInteger((Parcel)parcel2, (int)n2);
                            SafeParcelResponse.zaa((StringBuilder)object5, field, SafeParcelResponse.zaa(field, f));
                            break block51;
                        }
                        case 2: {
                            long d = SafeParcelReader.readLong((Parcel)parcel2, (int)n2);
                            SafeParcelResponse.zaa((StringBuilder)object5, field, SafeParcelResponse.zaa(field, d));
                            break block51;
                        }
                        case 3: {
                            float bigDecimal = SafeParcelReader.readFloat((Parcel)parcel2, (int)n2);
                            SafeParcelResponse.zaa((StringBuilder)object5, field, SafeParcelResponse.zaa(field, Float.valueOf(bigDecimal)));
                            break block51;
                        }
                        case 4: {
                            double bl2 = SafeParcelReader.readDouble((Parcel)parcel2, (int)n2);
                            SafeParcelResponse.zaa((StringBuilder)object5, field, SafeParcelResponse.zaa(field, bl2));
                            break block51;
                        }
                        case 5: {
                            BigDecimal string3 = SafeParcelReader.createBigDecimal((Parcel)parcel2, (int)n2);
                            SafeParcelResponse.zaa((StringBuilder)object5, field, SafeParcelResponse.zaa(field, string3));
                            break block51;
                        }
                        case 6: {
                            boolean byArray = SafeParcelReader.readBoolean((Parcel)parcel2, (int)n2);
                            SafeParcelResponse.zaa((StringBuilder)object5, field, SafeParcelResponse.zaa(field, byArray));
                            break block51;
                        }
                        case 7: {
                            String n7 = SafeParcelReader.createString((Parcel)parcel2, (int)n2);
                            SafeParcelResponse.zaa((StringBuilder)object5, field, SafeParcelResponse.zaa(field, n7));
                            break block51;
                        }
                        case 8: 
                        case 9: {
                            byte[] objectArray = SafeParcelReader.createByteArray((Parcel)parcel2, (int)n2);
                            SafeParcelResponse.zaa((StringBuilder)object5, field, SafeParcelResponse.zaa(field, objectArray));
                            break block51;
                        }
                        case 10: {
                            Bundle bl4 = SafeParcelReader.createBundle((Parcel)parcel2, (int)n2);
                            object4 = new HashMap<String, String>();
                            for (String string3 : bl4.keySet()) {
                                ((HashMap)object4).put(string3, (String)Preconditions.checkNotNull((Object)bl4.getString(string3)));
                            }
                            object3 = object4;
                            SafeParcelResponse.zaa((StringBuilder)object5, field, SafeParcelResponse.zaa(field, object3));
                            break block51;
                        }
                        case 11: {
                            throw new IllegalArgumentException("Method does not accept concrete type.");
                        }
                        default: {
                            int n9 = field.zac;
                            throw new IllegalArgumentException(new StringBuilder(36).append("Unknown field out type = ").append(n9).toString());
                        }
                    }
                }
                n2 = n3;
                parcel2 = parcel3;
                field = field2;
                object5 = object2;
                Object object6 = object;
                if (field.zad) {
                    ((StringBuilder)object5).append("[");
                    switch (field.zac) {
                        case 0: {
                            Object[] bigInteger = SafeParcelReader.createIntArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (int[])bigInteger);
                            break;
                        }
                        case 1: {
                            Object[] bigInteger = SafeParcelReader.createBigIntegerArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (Object[])bigInteger);
                            break;
                        }
                        case 2: {
                            Object[] bigInteger = SafeParcelReader.createLongArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (long[])bigInteger);
                            break;
                        }
                        case 3: {
                            Object[] bigInteger = SafeParcelReader.createFloatArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (float[])bigInteger);
                            break;
                        }
                        case 4: {
                            Object[] bigInteger = SafeParcelReader.createDoubleArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (double[])bigInteger);
                            break;
                        }
                        case 5: {
                            Object[] bigInteger = SafeParcelReader.createBigDecimalArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (Object[])bigInteger);
                            break;
                        }
                        case 6: {
                            Object[] bigInteger = SafeParcelReader.createBooleanArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (boolean[])bigInteger);
                            break;
                        }
                        case 7: {
                            Object[] bigInteger = SafeParcelReader.createStringArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeStringArray((StringBuilder)object5, (String[])bigInteger);
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: {
                            throw new UnsupportedOperationException("List of type BASE64, BASE64_URL_SAFE, or STRING_MAP is not supported");
                        }
                        case 11: {
                            Parcel[] parcelArray = SafeParcelReader.createParcelArray((Parcel)parcel2, (int)n2);
                            Object[] bigInteger = parcelArray;
                            int n6 = parcelArray.length;
                            for (int i = 0; i < n6; ++i) {
                                if (i > 0) {
                                    ((StringBuilder)object5).append(",");
                                }
                                bigInteger[i].setDataPosition(0);
                                super.zaa((StringBuilder)object5, field.zad(), (Parcel)bigInteger[i]);
                            }
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown field type out.");
                        }
                    }
                    ((StringBuilder)object5).append("]");
                } else {
                    switch (field.zac) {
                        case 0: {
                            int l = SafeParcelReader.readInt((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(l);
                            break;
                        }
                        case 1: {
                            BigInteger f = SafeParcelReader.createBigInteger((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(f);
                            break;
                        }
                        case 2: {
                            long d = SafeParcelReader.readLong((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(d);
                            break;
                        }
                        case 3: {
                            float bigDecimal = SafeParcelReader.readFloat((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(bigDecimal);
                            break;
                        }
                        case 4: {
                            double bl3 = SafeParcelReader.readDouble((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(bl3);
                            break;
                        }
                        case 5: {
                            BigDecimal string5 = SafeParcelReader.createBigDecimal((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(string5);
                            break;
                        }
                        case 6: {
                            boolean byArray = SafeParcelReader.readBoolean((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(byArray);
                            break;
                        }
                        case 7: {
                            String byArray = SafeParcelReader.createString((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append("\"").append(JsonUtils.escapeString((String)byArray)).append("\"");
                            break;
                        }
                        case 8: {
                            byte[] bundle = SafeParcelReader.createByteArray((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append("\"").append(Base64Utils.encode((byte[])bundle)).append("\"");
                            break;
                        }
                        case 9: {
                            byte[] parcel4 = SafeParcelReader.createByteArray((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append("\"").append(Base64Utils.encodeUrlSafe((byte[])parcel4));
                            ((StringBuilder)object5).append("\"");
                            break;
                        }
                        case 10: {
                            Bundle bundle = SafeParcelReader.createBundle((Parcel)parcel2, (int)n2);
                            object3 = bundle.keySet();
                            ((StringBuilder)object5).append("{");
                            boolean bl2 = true;
                            object4 = object3.iterator();
                            while (object4.hasNext()) {
                                String string4 = (String)object4.next();
                                if (!bl2) {
                                    ((StringBuilder)object5).append(",");
                                }
                                bl2 = false;
                                ((StringBuilder)object5).append("\"").append(string4).append("\"");
                                ((StringBuilder)object5).append(":");
                                ((StringBuilder)object5).append("\"").append(JsonUtils.escapeString((String)bundle.getString(string4))).append("\"");
                            }
                            ((StringBuilder)object5).append("}");
                            break;
                        }
                        case 11: {
                            Parcel parcel4 = SafeParcelReader.createParcel((Parcel)parcel2, (int)n2);
                            parcel4.setDataPosition(0);
                            super.zaa((StringBuilder)object5, field.zad(), parcel4);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown field type out");
                        }
                    }
                }
            }
            bl = true;
        }
        if (parcel.dataPosition() != n) {
            throw new SafeParcelReader.ParseException(new StringBuilder(37).append("Overread allowed size end=").append(n).toString(), parcel);
        }
        stringBuilder.append('}');
    }

    private static void zaa(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Object object) {
        if (field.zab) {
            ArrayList arrayList = (ArrayList)object;
            FastJsonResponse.Field<?, ?> field2 = field;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append("[");
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuilder2.append(",");
                }
                SafeParcelResponse.zaa(stringBuilder2, field2.zaa, arrayList.get(i));
            }
            stringBuilder2.append("]");
            return;
        }
        SafeParcelResponse.zaa(stringBuilder, field.zaa, object);
    }

    private static void zaa(StringBuilder stringBuilder, int n, @Nullable Object object) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                stringBuilder.append(object);
                return;
            }
            case 7: {
                stringBuilder.append("\"").append(JsonUtils.escapeString((String)Preconditions.checkNotNull((Object)object).toString())).append("\"");
                return;
            }
            case 8: {
                stringBuilder.append("\"").append(Base64Utils.encode((byte[])((byte[])object))).append("\"");
                return;
            }
            case 9: {
                stringBuilder.append("\"").append(Base64Utils.encodeUrlSafe((byte[])((byte[])object)));
                stringBuilder.append("\"");
                return;
            }
            case 10: {
                MapUtils.writeStringMapToJson((StringBuilder)stringBuilder, (HashMap)((HashMap)Preconditions.checkNotNull((Object)object)));
                return;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
        }
        throw new IllegalArgumentException(new StringBuilder(26).append("Unknown type = ").append(n).toString());
    }
}

