/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.GoogleSignInOptionsExtensionParcelable;
import com.google.android.gms.auth.api.signin.internal.HashAccumulator;
import com.google.android.gms.auth.api.signin.zac;
import com.google.android.gms.auth.api.signin.zad;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="GoogleSignInOptionsCreator")
public class GoogleSignInOptions
extends AbstractSafeParcelable
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    @RecentlyNonNull
    public static final GoogleSignInOptions DEFAULT_SIGN_IN;
    @RecentlyNonNull
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN;
    @RecentlyNonNull
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR;
    @VisibleForTesting
    @RecentlyNonNull
    public static final Scope zaa;
    @VisibleForTesting
    @RecentlyNonNull
    public static final Scope zab;
    @VisibleForTesting
    @RecentlyNonNull
    public static final Scope zac;
    @VisibleForTesting
    @RecentlyNonNull
    public static final Scope zad;
    @VisibleForTesting
    @RecentlyNonNull
    public static final Scope zae;
    @SafeParcelable.VersionField(id=1)
    final int zaf;
    @SafeParcelable.Field(id=2, getter="getScopes")
    private final ArrayList<Scope> zag;
    @SafeParcelable.Field(id=3, getter="getAccount")
    @Nullable
    private Account zah;
    @SafeParcelable.Field(id=4, getter="isIdTokenRequested")
    private boolean zai;
    @SafeParcelable.Field(id=5, getter="isServerAuthCodeRequested")
    private final boolean zaj;
    @SafeParcelable.Field(id=6, getter="isForceCodeForRefreshToken")
    private final boolean zak;
    @SafeParcelable.Field(id=7, getter="getServerClientId")
    @Nullable
    private String zal;
    @SafeParcelable.Field(id=8, getter="getHostedDomain")
    @Nullable
    private String zam;
    @SafeParcelable.Field(id=9, getter="getExtensions")
    private ArrayList<GoogleSignInOptionsExtensionParcelable> zan;
    @SafeParcelable.Field(id=10, getter="getLogSessionId")
    @Nullable
    private String zao;
    private Map<Integer, GoogleSignInOptionsExtensionParcelable> zap;
    private static Comparator<Scope> zaq;

    @SafeParcelable.Constructor
    GoogleSignInOptions(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) ArrayList<Scope> arrayList, @SafeParcelable.Param(id=3) @Nullable Account account, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) boolean bl3, @SafeParcelable.Param(id=7) @Nullable String string, @SafeParcelable.Param(id=8) @Nullable String string2, @SafeParcelable.Param(id=9) ArrayList<GoogleSignInOptionsExtensionParcelable> arrayList2, @SafeParcelable.Param(id=10) @Nullable String string3) {
        this(n, arrayList, account, bl, bl2, bl3, string, string2, GoogleSignInOptions.zam(arrayList2), string3);
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, @Nullable Account account, boolean bl, boolean bl2, boolean bl3, @Nullable String string, @Nullable String string2, Map<Integer, GoogleSignInOptionsExtensionParcelable> map, @Nullable String string3) {
        this.zaf = n;
        this.zag = arrayList;
        this.zah = account;
        this.zai = bl;
        this.zaj = bl2;
        this.zak = bl3;
        this.zal = string;
        this.zam = string2;
        ArrayList<GoogleSignInOptionsExtensionParcelable> arrayList2 = new ArrayList<GoogleSignInOptionsExtensionParcelable>(map.values());
        this.zan = arrayList2;
        this.zap = map;
        this.zao = string3;
    }

    @KeepForSdk
    @RecentlyNonNull
    public ArrayList<Scope> getScopes() {
        ArrayList<Scope> arrayList = new ArrayList<Scope>(this.zag);
        return arrayList;
    }

    @RecentlyNonNull
    public Scope[] getScopeArray() {
        ArrayList<Scope> arrayList = ((GoogleSignInOptions)((Object)arrayList)).zag;
        return arrayList.toArray(new Scope[arrayList.size()]);
    }

    @KeepForSdk
    @RecentlyNullable
    public Account getAccount() {
        return this.zah;
    }

    @KeepForSdk
    public boolean isIdTokenRequested() {
        return this.zai;
    }

    @KeepForSdk
    public boolean isServerAuthCodeRequested() {
        return this.zaj;
    }

    @KeepForSdk
    public boolean isForceCodeForRefreshToken() {
        return this.zak;
    }

    @KeepForSdk
    @RecentlyNullable
    public String getServerClientId() {
        return this.zal;
    }

    @KeepForSdk
    @RecentlyNullable
    public String getLogSessionId() {
        return this.zao;
    }

    @KeepForSdk
    @RecentlyNonNull
    public ArrayList<GoogleSignInOptionsExtensionParcelable> getExtensions() {
        return this.zan;
    }

    public void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.zaf);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)2, this.getScopes(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)3, (Parcelable)this.getAccount(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)4, (boolean)this.isIdTokenRequested());
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)5, (boolean)this.isServerAuthCodeRequested());
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)6, (boolean)this.isForceCodeForRefreshToken());
        SafeParcelWriter.writeString((Parcel)parcel, (int)7, (String)this.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)8, (String)this.zam, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)9, this.getExtensions(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)10, (String)this.getLogSessionId(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        try {
            boolean bl;
            int n;
            boolean bl2;
            int n2;
            object = (GoogleSignInOptions)object;
            int n3 = this.zan.size();
            if (n3 > 0 || (n3 = ((GoogleSignInOptions)object).zan.size()) > 0) {
                return false;
            }
            n3 = this.zag.size();
            if (n3 != (n2 = ((GoogleSignInOptions)object).getScopes().size()) || (n3 = (int)(this.zag.containsAll(((GoogleSignInOptions)object).getScopes()) ? 1 : 0)) == 0) {
                return false;
            }
            Account account = this.zah;
            return (account == null ? (account = ((GoogleSignInOptions)object).getAccount()) == null : (bl2 = account.equals((Object)((GoogleSignInOptions)object).getAccount()))) && ((n = TextUtils.isEmpty((CharSequence)this.zal)) != 0 ? (n = TextUtils.isEmpty((CharSequence)((GoogleSignInOptions)object).getServerClientId())) != 0 : (n = this.zal.equals(((GoogleSignInOptions)object).getServerClientId())) != 0) && (n = this.zak) == (n2 = (int)(((GoogleSignInOptions)object).isForceCodeForRefreshToken() ? 1 : 0)) && (n = (int)(this.zai ? 1 : 0)) == (n2 = (int)(((GoogleSignInOptions)object).isIdTokenRequested() ? 1 : 0)) && (n = (int)(this.zaj ? 1 : 0)) == (n2 = (int)(((GoogleSignInOptions)object).isServerAuthCodeRequested() ? 1 : 0)) && (bl = TextUtils.equals((CharSequence)this.zao, (CharSequence)((GoogleSignInOptions)object).getLogSessionId()));
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zag;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(((Scope)arrayList2.get(i)).getScopeUri());
        }
        Collections.sort(arrayList);
        HashAccumulator hashAccumulator = new HashAccumulator();
        hashAccumulator.addObject(arrayList);
        hashAccumulator.addObject(this.zah);
        hashAccumulator.addObject(this.zal);
        hashAccumulator.zaa(this.zak);
        hashAccumulator.zaa(this.zai);
        hashAccumulator.zaa(this.zaj);
        hashAccumulator.addObject(this.zao);
        return hashAccumulator.hash();
    }

    static {
        Object object = new Scope("profile");
        zaa = object;
        object = new Scope("email");
        zab = object;
        object = new Scope("openid");
        zac = object;
        object = new Scope("https://www.googleapis.com/auth/games_lite");
        zad = object;
        object = new Scope("https://www.googleapis.com/auth/games");
        zae = object;
        object = new Builder();
        ((Builder)object).requestId();
        ((Builder)object).requestProfile();
        DEFAULT_SIGN_IN = ((Builder)object).build();
        object = new Builder();
        ((Builder)object).requestScopes(zad, new Scope[0]);
        DEFAULT_GAMES_SIGN_IN = ((Builder)object).build();
        object = new zad();
        CREATOR = object;
        zaq = object = new zac();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @RecentlyNullable
    public static GoogleSignInOptions zaa(@Nullable String string) throws JSONException {
        void var2_5;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string);
        Object object = new HashSet();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            Scope scope = new Scope(jSONArray.getString(i));
            object.add(scope);
        }
        String string2 = jSONObject.has("accountName") ? jSONObject.optString("accountName") : null;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            Account account = new Account(string2, "com.google");
            string2 = account;
        } else {
            string2 = null;
        }
        ArrayList<Scope> arrayList = new ArrayList<Scope>((Collection<Scope>)object);
        boolean bl = jSONObject.getBoolean("idTokenRequested");
        boolean bl2 = jSONObject.getBoolean("serverAuthRequested");
        boolean bl3 = jSONObject.getBoolean("forceCodeForRefreshToken");
        object = jSONObject.has("serverClientId") ? jSONObject.optString("serverClientId") : null;
        if (jSONObject.has("hostedDomain")) {
            String string3 = jSONObject.optString("hostedDomain");
        } else {
            Object var2_6 = null;
        }
        HashMap<Integer, GoogleSignInOptionsExtensionParcelable> hashMap = new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>();
        return new GoogleSignInOptions(3, arrayList, (Account)string2, bl, bl2, bl3, (String)object, (String)var2_5, hashMap, null);
    }

    private static Map<Integer, GoogleSignInOptionsExtensionParcelable> zam(@Nullable List<GoogleSignInOptionsExtensionParcelable> object) {
        HashMap<Integer, GoogleSignInOptionsExtensionParcelable> hashMap = new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>();
        if (object == null) {
            return hashMap;
        }
        object = object.iterator();
        while (object.hasNext()) {
            GoogleSignInOptionsExtensionParcelable googleSignInOptionsExtensionParcelable = (GoogleSignInOptionsExtensionParcelable)((Object)object.next());
            hashMap.put(googleSignInOptionsExtensionParcelable.getType(), googleSignInOptionsExtensionParcelable);
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RecentlyNonNull
    public final String zab() {
        Object object = new JSONObject();
        try {
            boolean bl;
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zag, zaq);
            Object object2 = this.zag.iterator();
            while (bl = object2.hasNext()) {
                jSONArray.put((Object)object2.next().getScopeUri());
            }
            object.put("scopes", (Object)jSONArray);
            jSONArray = this.zah;
            if (jSONArray != null) {
                object2 = "accountName";
                object.put((String)object2, (Object)jSONArray.name);
            }
            object.put("idTokenRequested", this.zai);
            object.put("forceCodeForRefreshToken", this.zak);
            object.put("serverAuthRequested", this.zaj);
            boolean bl2 = TextUtils.isEmpty((CharSequence)this.zal);
            if (!bl2) {
                object.put("serverClientId", (Object)this.zal);
            }
            if (bl2 = TextUtils.isEmpty((CharSequence)this.zam)) return object.toString();
            object.put("hostedDomain", (Object)this.zam);
            return object.toString();
        }
        catch (JSONException jSONException) {
            object = new RuntimeException(jSONException);
            throw object;
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string, String string2, Map map, String string3, zac zac2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string, string2, map, string3);
    }

    public static final class Builder {
        private Set<Scope> zaa;
        private boolean zab;
        private boolean zac;
        private boolean zad;
        @Nullable
        private String zae;
        @Nullable
        private Account zaf;
        @Nullable
        private String zag;
        private Map<Integer, GoogleSignInOptionsExtensionParcelable> zah;
        @Nullable
        private String zai;

        public Builder() {
            Cloneable cloneable = new Cloneable();
            this.zaa = cloneable;
            this.zah = cloneable;
        }

        public Builder(@RecentlyNonNull GoogleSignInOptions googleSignInOptions) {
            HashSet<Scope> hashSet = new HashSet<Scope>();
            this.zaa = hashSet;
            this.zah = hashSet;
            Preconditions.checkNotNull((Object)googleSignInOptions);
            hashSet = new HashSet<Scope>(googleSignInOptions.zag);
            this.zaa = hashSet;
            this.zab = googleSignInOptions.zaj;
            this.zac = googleSignInOptions.zak;
            this.zad = googleSignInOptions.zai;
            this.zae = googleSignInOptions.zal;
            this.zaf = googleSignInOptions.zah;
            this.zag = googleSignInOptions.zam;
            this.zah = GoogleSignInOptions.zam(googleSignInOptions.zan);
            this.zai = googleSignInOptions.zao;
        }

        @RecentlyNonNull
        public Builder requestId() {
            this.zaa.add(zac);
            return this;
        }

        @RecentlyNonNull
        public Builder requestEmail() {
            this.zaa.add(zab);
            return this;
        }

        @RecentlyNonNull
        public Builder requestProfile() {
            this.zaa.add(zaa);
            return this;
        }

        @RecentlyNonNull
        public Builder requestScopes(@RecentlyNonNull Scope scope, Scope ... scopeArray) {
            this.zaa.add(scope);
            this.zaa.addAll(Arrays.asList(scopeArray));
            return this;
        }

        @RecentlyNonNull
        public Builder requestIdToken(@RecentlyNonNull String string) {
            this.zad = true;
            this.zaa(string);
            this.zae = string;
            return this;
        }

        @RecentlyNonNull
        public Builder requestServerAuthCode(@RecentlyNonNull String string) {
            this.requestServerAuthCode(string, false);
            return this;
        }

        @RecentlyNonNull
        public Builder requestServerAuthCode(@RecentlyNonNull String string, boolean bl) {
            this.zab = true;
            this.zaa(string);
            this.zae = string;
            this.zac = bl;
            return this;
        }

        @RecentlyNonNull
        public Builder setAccountName(@RecentlyNonNull String string) {
            Account account;
            this.zaf = account = new Account(Preconditions.checkNotEmpty((String)string), "com.google");
            return this;
        }

        @RecentlyNonNull
        public Builder setHostedDomain(@RecentlyNonNull String string) {
            this.zag = Preconditions.checkNotEmpty((String)string);
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public Builder setLogSessionId(@RecentlyNonNull String string) {
            this.zai = string;
            return this;
        }

        @RecentlyNonNull
        public Builder addExtension(@RecentlyNonNull GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (((Builder)object).zah.containsKey(googleSignInOptionsExtension.getExtensionType())) {
                Object object = new IllegalStateException("Only one extension per type may be added");
                throw object;
            }
            List<Scope> list = googleSignInOptionsExtension.getImpliedScopes();
            if (list != null) {
                ((Builder)object).zaa.addAll(list);
            }
            list = ((Builder)object).zah;
            int n = googleSignInOptionsExtension.getExtensionType();
            Integer n2 = n;
            GoogleSignInOptionsExtensionParcelable googleSignInOptionsExtensionParcelable = new GoogleSignInOptionsExtensionParcelable(googleSignInOptionsExtension);
            list.put(n2, googleSignInOptionsExtensionParcelable);
            return object;
        }

        @RecentlyNonNull
        public GoogleSignInOptions build() {
            if (this.zaa.contains(zae) && this.zaa.contains(zad)) {
                this.zaa.remove(zad);
            }
            if (this.zad && (this.zaf == null || !this.zaa.isEmpty())) {
                this.requestId();
            }
            ArrayList<Scope> arrayList = new ArrayList<Scope>(this.zaa);
            GoogleSignInOptions googleSignInOptions = new GoogleSignInOptions(3, arrayList, this.zaf, this.zad, this.zab, this.zac, this.zae, this.zag, this.zah, this.zai, null);
            return googleSignInOptions;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final String zaa(String string) {
            Preconditions.checkNotEmpty((String)string);
            String string2 = ((Builder)((Object)string2)).zae;
            boolean bl = string2 != null ? string2.equals(string) : true;
            Preconditions.checkArgument((boolean)bl, (Object)"two different server client ids provided");
            return string;
        }
    }
}

