/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;

@KeepForSdk
public class Storage {
    private static final Lock zaa;
    @GuardedBy(value="sLk")
    @Nullable
    private static Storage zab;
    private final Lock zac;
    @GuardedBy(value="mLk")
    private final SharedPreferences zad;

    @KeepForSdk
    @RecentlyNonNull
    public static Storage getInstance(@RecentlyNonNull Context object) {
        Preconditions.checkNotNull((Object)object);
        zaa.lock();
        try {
            Storage storage = zab;
            if (storage == null) {
                zab = storage = new Storage(object.getApplicationContext());
            }
            object = zab;
        }
        finally {
            zaa.unlock();
        }
        return object;
    }

    @VisibleForTesting
    Storage(Context context) {
        ReentrantLock reentrantLock = new ReentrantLock();
        this.zac = reentrantLock;
        this.zad = context.getSharedPreferences("com.google.android.gms.signin", 0);
    }

    @KeepForSdk
    public void saveDefaultGoogleSignInAccount(@RecentlyNonNull GoogleSignInAccount googleSignInAccount, @RecentlyNonNull GoogleSignInOptions googleSignInOptions) {
        Preconditions.checkNotNull((Object)((Object)googleSignInAccount));
        Preconditions.checkNotNull((Object)googleSignInOptions);
        this.zaa("defaultGoogleSignInAccount", googleSignInAccount.zac());
        Preconditions.checkNotNull((Object)((Object)googleSignInAccount));
        Preconditions.checkNotNull((Object)googleSignInOptions);
        String string = googleSignInAccount.zac();
        this.zaa(Storage.zae("googleSignInAccount", string), googleSignInAccount.zad());
        this.zaa(Storage.zae("googleSignInOptions", string), googleSignInOptions.zab());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNullable
    @KeepForSdk
    public GoogleSignInAccount getSavedDefaultGoogleSignInAccount() {
        void var0_2;
        String string = this.zab("defaultGoogleSignInAccount");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return var0_2;
        }
        String string2 = this.zab(Storage.zae("googleSignInAccount", string));
        if (string2 == null) return var0_2;
        try {
            GoogleSignInAccount googleSignInAccount = GoogleSignInAccount.zaa(string2);
            return var0_2;
        }
        catch (JSONException jSONException) {
            return var0_2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNullable
    @KeepForSdk
    public GoogleSignInOptions getSavedDefaultGoogleSignInOptions() {
        String string = ((Storage)this).zab("defaultGoogleSignInAccount");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if ((this = ((Storage)this).zab(Storage.zae("googleSignInOptions", string))) == null) return null;
        try {
            return GoogleSignInOptions.zaa((String)this);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @RecentlyNullable
    @KeepForSdk
    public String getSavedRefreshToken() {
        return this.zab("refreshToken");
    }

    @KeepForSdk
    public void clear() {
        this.zac.lock();
        try {
            this.zad.edit().clear().apply();
        }
        finally {
            this.zac.unlock();
        }
    }

    static {
        ReentrantLock reentrantLock = new ReentrantLock();
        zaa = reentrantLock;
    }

    protected final void zaa(@RecentlyNonNull String string, @RecentlyNonNull String string2) {
        this.zac.lock();
        try {
            this.zad.edit().putString(string, string2).apply();
        }
        finally {
            this.zac.unlock();
        }
    }

    @RecentlyNullable
    protected final String zab(@RecentlyNonNull String string) {
        this.zac.lock();
        try {
            string = this.zad.getString(string, null);
        }
        finally {
            this.zac.unlock();
        }
        return string;
    }

    public final void zac() {
        String string = this.zab("defaultGoogleSignInAccount");
        this.zad("defaultGoogleSignInAccount");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zad(Storage.zae("googleSignInAccount", string));
        this.zad(Storage.zae("googleSignInOptions", string));
    }

    protected final void zad(@RecentlyNonNull String string) {
        this.zac.lock();
        try {
            this.zad.edit().remove(string).apply();
        }
        finally {
            this.zac.unlock();
        }
    }

    private static final String zae(String string, String string2) {
        int n = string.length();
        String string3 = String.valueOf(string2);
        int n2 = string3.length();
        StringBuilder stringBuilder = new StringBuilder(n + 1 + n2);
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }
}

